<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

$oImageLogo = new d3logo;
$oImageLogo->getLogo();

/**
 * Class d3logo
 */
class d3logo
{
    public function getLogo()
    {
        if ($_GET && isset($_GET['cl']) && $_GET['cl']) {
            switch (strtolower($_GET['cl'])) {
                case 'module_main':
                    $sFncName = '_getEmptyPic';
                    break;
                default:
                    $sFncName = '_getSizeXXS';
            }
        } else {
            $sFncName = '_getSizeXXS';
        }

        if ($_REQUEST && isset($_REQUEST['size']) && $_REQUEST['size']) {
            switch (strtolower($_REQUEST['size'])) {
                case 'xxs':
                    $sFncName = '_getSizeXXS';
                    break;
                case 'xs':
                    $sFncName = '_getSizeXS';
                    break;
                case 's':
                    $sFncName = '_getSizeS';
                    break;
                case 'm':
                    $sFncName = '_getSizeM';
                    break;
                case 'l':
                    $sFncName = '_getSizeL';
                    break;
                case 'xl':
                    $sFncName = '_getSizeXL';
                    break;
                case 'xxl':
                    $sFncName = '_getSizeXXL';
                    break;
            }
        }

        header("Content-type: image/png");
        echo base64_decode($this->{$sFncName}());
        exit;
    }

    /**
     * 12px x 13px
     *
     * @return string
     */
    protected function _getSizeXXS()
    {
        $img_data =
            "iVBORw0KGgoAAAANSUhEUgAAAAwAAAANCAYAAACdKY9CAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAilJREFUeNocUt1LVEEcPTN37pfaXbYWUTdaDFw/IAhMkD58KioKKjGfoiCip1h6D+rBt/4IexMhsh58KJLyISLwISEWI1NZXfJz2dab9+6dO3OnuTvwm4GZcw7nd35DXpVjLO0S7EYENU7GdgIyvhNgUAEk76rvQzmy/amK636M3P1+PGH6AZYBr+pjanlfPY6kcmCktwSNI3XFSoCrefrt6x5xNv/hGHUZaLmmppaqspQI4bhUwFUSiAQyhoRFFSwhRp8PI9uXwS+28Te5vLAmSp1tBO/GbZxwCDpMgvKBxGIlwe0iRaT5R1x2151kkL0u8wcqSNDfRTGqa+swwZdKjBt9JoY7KZ5+bELECT5UJLoz9B79XYtHIDiKHlrrzU+OyekG3q9yZF2CrQbHzFKA2lGMzXo8wvyQe9AKg8fdFuHHnwjgHF3tBFL33giETkV7gsRhSDxqC9GEFCjmjBbB5BKPxlycL1hYXI+wWg01NtYiAo4UTXa6Q61UQlEY6GQtwstbWXg2wXI1wrP5A/gBB2wKhAn6euwVdrFgza5th9dezO9rIIVp6CH6OqH1AHv61LkitZzWhVPts+xs3p5byZsTM58PbraUSDozvelokbpMwaHApWLH/Jkee47mPepPjniloV5nAYZ+ZLpMraxEyzcijqEea+HuOa+Uzxg+018B2Ta2MdBlT9hMPazW4zv1puxN+8m6xsbJrPm2N+dMa0wjEgr/BRgADWz27ZRhGX8AAAAASUVORK5CYII=";

        return $img_data;
    }

    /**
     * 16px x 17px
     *
     * @return string
     */
    protected function _getSizeXS()
    {
        $img_data =
            "iVBORw0KGgoAAAANSUhEUgAAABAAAAARCAYAAADUryzEAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA0tJREFUeNpMU11oVEcU/mbu7N7dZJMYs+tPoqnpJjFQ01SCNq0IFqEPEixBseBPKe1DKW2pD0V8qg++FBQkfZT2JeRBJa3VFkWsCNUgIkJM8CcRsTTZTdI0ySa5u3v37swdz9y7VQfOZZh7znfO9803bOiZgm0B4wvA/XmgIFlizmUfLpX0rkyBNYFWUxUyDTF9rTrKIneyOLYs0dJai5sHWvGFMAmMIkYg80X0PVrAiWxBd/maDrkf/M0VNGoi+OarTmCliCtPHTbyfBlfTjo4wVFZD+fx3Y2//V+ncqrLVwrwKRQBmD0Brbg+fhiW2FLvb/+sHXubE/iFMTwT66uA8+P+x2dH/VOUikREI0RlwdeVgJfX6NnE0V7HcHVCJs/1MgiLr3MVtJhx/DVDT8qnVVmjsYbhjz4btbYpZwHEgqtxeULBIorfvy9wcYKhM8UwnlPNnOuUOPfQO5jNqQ2mW7qaY+uasH+RAE1RSx1H91qOC48ljl530b3ewrd/ehgYkxv3dlgHxci03AOfuEqNltro/5Lg8MU8xmYkBvclsL1JYPcmC5//7qB/mNQlYFgMY9N6D59ZLrdBE9EyCdQQdnc8jXtZD08nPdyZksEZJz51EVJJVAIS08uyTTglGQ8y6N7aV4fCTS0p/Ot41EVjc/1rZyshGLQORHaUinPbVxKeRNRSSNdb4ZXOllGaLeGDtMCuN0Na18aLKOfLdK0EImkCKWFrJXnK1hmUJNbFNN6oAHSkBAY+TeLyJ0nEBMM/OYkf/1oiHuplsWmaiuoM39YkbiHvoW0VR40davDW2giOdFfDJp/emCB7/jSDycWS4Rkay4julrGtUdwSPRvtgSsj+PrRrGv3/Zwl8+nAAT40MosSD4iKMSWiPOxe0SAuUOppjg6I1qQ1ur+r+szg8OLx3+bclw6krFD6CIUZTIXvIhCw6GPfe6vOtCbFKCeK6O1MnNy5uepSMJpFETGhw33wJipBV00Ow862+KXetxMnTS03r05pFD56p/bQjnS8P2ZM4Rmh/FeFZk9nMfhyR7qq3+TSQAVTKyoWgGbIdzTGjiZibOj5f97heUe+u+TqlJm6Ls7mGhKRuy3J6OCG1fZtyg1qzHohwACVM4XQA6QqzQAAAABJRU5ErkJggg==";

        return $img_data;
    }

    /**
     * 32px x 33px
     *
     * @return string
     */
    protected function _getSizeS()
    {
        $img_data =
            "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";

        return $img_data;
    }

    /**
     * 50px x 51px
     *
     * @return string
     */
    protected function _getSizeM()
    {
        $img_data =
            "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";

        return $img_data;
    }

    /**
     * 70px x 71px
     *
     * @return string
     */
    protected function _getSizeL()
    {
        $img_data =
            "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";

        return $img_data;
    }

    /**
     * 120px x 122px
     *
     * @return string
     */
    protected function _getSizeXL()
    {
        $img_data =
            "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";

        return $img_data;
    }

    /**
     * 220px x 224px
     *
     * @return string
     */

    protected function _getSizeXXL()
    {
        $img_data =
            "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";

        return $img_data;
    }

    /**
     * 1px x 1px
     *
     * @return string
     */
    protected function _getEmptyPic()
    {
        $img_data =
            "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAABBJREFUeNpi+P//PwNAgAEACPwC/tuiTRYAAAAASUVORK5CYII=";

        return $img_data;
    }
}

/**
 * @param $imagefile
 *
 * @return string
 */
function base64_encode_image($imagefile)
{
    $imgtype  = array('jpg', 'gif', 'png');
    $filename = file_exists($imagefile) ? htmlentities($imagefile) : die('Image file name does not exist');
    $filetype = pathinfo($filename, PATHINFO_EXTENSION);

    if (in_array($filetype, $imgtype)) {
        $imgbinary = fread(fopen($filename, "r"), filesize($filename));
    } else {
        die ('Invalid image type, jpg, gif, and png is only allowed');
    }

    return 'data:image/' . $filetype . ';base64,' . base64_encode($imgbinary);
}