<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

$sModuleId = 'd3modcfg_lib';

$aModule = array(
    'id'          => $sModuleId,
    'title'       => '<img src="../modules/_d3modcfg/public/d3logo.php?cl=' . $_REQUEST['cl'] .
        '" alt="D&sup3;" title="D&sup3; Data Development"> Modul-Connector',
    'description' => array(
        'de' => 'enth&auml;lt:<ul><li>Modulkonfiguration</li>'.
                '<li>Installationsassistent</li>'.
                '<li>Logging</li>'.
                '<li>TMP leeren</li></ul>',
        'en' => 'contains:<ul><li>Module Configuration</li>'.
                '<li>installation wizzard</li>'.
                '<li>Logging</li>'.
                '<li>Clear TMP</li></ul>',
    ),
    'lang'        => 'de',
    'thumbnail'   => 'picture.png',
    'version'     => '4.5.0.1',
    'author'      => 'D&sup3; Data Development (Inh. Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com',
    'extend'      => array(
        #d3_cfg_mod
        'oxmodule'      => '_d3modcfg/modules/models/d3_oxmodule_activecheck',
        'oxshopcontrol' => '_d3modcfg/modules/controllers/d3_oxshopcontrol_modcfg_extension',
        'oxutilsview'   => '_d3modcfg/modules/core/d3_oxutilsview_modcfg',
        'oxshop'        => '_d3modcfg/modules/models/d3_oxshop_modcfg',
        'oxtheme'       => '_d3modcfg/modules/core/d3_oxtheme_modcfg',
        # see at end of file for further variable extensions
        
        #d3install
        'navigation' => '_d3modcfg/modules/controllers/admin/d3_navigation_modcfgupdate',
// ToDo: check, if we can enable this
        //'oxemail' => '_d3modcfg/modules/core/d3_oxemail_log',
    ),
    'files'       => array(
        #d3_cfg_mod
        'd3_cfg_mod'         => '_d3modcfg/models/d3_cfg_mod.php',
        'd3_cfg_mod_variant' => '_d3modcfg/models/d3_cfg_mod_variant.php',
        'd3modprofile'       => '_d3modcfg/models/d3modprofile.php',
        'd3modprofilelist'   => '_d3modcfg/models/d3modprofilelist.php',
        'd3_cfg_mod_update'  => '_d3modcfg/setup/d3_cfg_mod_update.php',
        'd3_cfg_mod_cleaning'=> '_d3modcfg/setup/d3_cfg_mod_cleaning.php',
        'd3feeds'            => '_d3modcfg/models/d3feeds.php',
        'd3pagenavigation'   => '_d3modcfg/models/d3pagenavigation.php',
        'd3tickercontrol'    => '_d3modcfg/models/d3tickercontrol.php',
        'd3counter'          => '_d3modcfg/models/d3counter.php',
        'd3utils'            => '_d3modcfg/models/d3utils.php',
        'd3decoder'          => '_d3modcfg/models/d3decoder.php',
        'd3encoder'          => '_d3modcfg/models/d3encoder.php',
        'd3maintenanceactions'=> '_d3modcfg/models/d3maintenanceactions.php',

        'd3filegenerator'    => '_d3modcfg/models/filegenerator/d3filegenerator.php',
        'd3filegeneratorcronsh'=> '_d3modcfg/models/filegenerator/d3filegeneratorcronsh.php',

        'd3installcheck'     => '_d3modcfg/models/installcheck/d3installcheck.php',
        'd3InstallCheckInterface'     => '_d3modcfg/models/installcheck/d3InstallCheckInterface.php',
        'd3InstallCheckModuleVersionsIdentical'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckModuleVersionsIdentical.php',
        'd3installcheckextenditemsareactive'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckExtendItemsAreActive.php',
        'd3InstallCheckClassItemsAreAvailable'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckClassItemsAreAvailable.php',
        'd3InstallCheckTemplateItemsAreAvailable'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckTemplateItemsAreAvailable.php',
        'd3installcheckblockitemsareactive'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckBlockItemsAreActive.php',
        'd3InstallCheckHasNoInstallItem'     =>
            '_d3modcfg/models/installcheck/d3InstallCheckHasNoInstallItem.php',

        'd3_cfg_mod_'        => '_d3modcfg/controllers/admin/d3_cfg_mod_.php',
        'd3_cfg_mod_licence' => '_d3modcfg/controllers/admin/d3_cfg_mod_licence.php',
        'd3_cfg_mod_list'    => '_d3modcfg/controllers/admin/d3_cfg_mod_list.php',
        'd3_cfg_mod_main'    => '_d3modcfg/controllers/admin/d3_cfg_mod_main.php',
        'd3cfgitems'         => '_d3modcfg/controllers/admin/d3cfgitems.php',
        'd3mod_status'       => '_d3modcfg/controllers/admin/d3mod_status.php',
        'd3modext'           => '_d3modcfg/controllers/admin/d3modext.php',
        'd3modext_list'      => '_d3modcfg/controllers/admin/d3modext_list.php',
        'd3modext_status'    => '_d3modcfg/controllers/admin/d3modext_status.php',
        'd3modext_new'       => '_d3modcfg/controllers/admin/d3modext_new.php',
        'd3moditems'         => '_d3modcfg/controllers/admin/d3moditems.php',
        'd3modlib'           => '_d3modcfg/controllers/admin/d3modlib.php',
        'd3modlib_list'      => '_d3modcfg/controllers/admin/d3modlib_list.php',
        'd3modlib_status'    => '_d3modcfg/controllers/admin/d3modlib_status.php',
        'd3modlib_support'   => '_d3modcfg/controllers/admin/d3modlib_support.php',
        'd3sysitems'         => '_d3modcfg/controllers/admin/d3sysitems.php',
        'd3sysitems_list'    => '_d3modcfg/controllers/admin/d3sysitems_list.php',
        'd3mod_activation'   => '_d3modcfg/controllers/admin/d3mod_activation.php',
        'd3maintenance'      => '_d3modcfg/controllers/admin/d3maintenance.php',

        'd3selection'        => '_d3modcfg/models/d3selection.php',
        'd3ParameterContainer'          => '_d3modcfg/models/parameterContainer/d3parametercontainer.php',
        'd3ParameterContainerInterface' => '_d3modcfg/models/parameterContainer/d3parametercontainerinterface.php',
        'd3ParameterNotFoundException'  => '_d3modcfg/models/parameterContainer/d3parameternotfoundexception.php',
        
        'd3shopcompatibilityadapterhandler'  =>
            '_d3modcfg/models/shopcompatibility/d3shopcompatibilityadapterhandler.php',
        'd3shopcompatibilityadapterinterface'  =>
            '_d3modcfg/models/shopcompatibility/d3shopcompatibilityadapterinterface.php',
        'd3shopcompatibilityadapterexception'  =>
            '_d3modcfg/models/shopcompatibility/d3shopcompatibilityadapterexception.php',
        'd3shopcompatibility47adapter'  =>
            '_d3modcfg/models/shopcompatibility/d3shopcompatibility47adapter.php',
        'd3shopcompatibility49adapter'  =>
            '_d3modcfg/models/shopcompatibility/d3shopcompatibility49adapter.php',
        'd3shopversionconverter'  =>
            '_d3modcfg/models/shopcompatibility/d3shopversionconverter.php',

        'd3installaction'           => '_d3modcfg/models/installwizzard/d3installaction.php',
        'd3installdatahandler'      => '_d3modcfg/models/installwizzard/d3installdatahandler.php',
        'd3installcleandbstructurelist'    => '_d3modcfg/models/installwizzard/d3installcleandbstructurelist.php',
        'd3install2shoprelation'    => '_d3modcfg/models/installwizzard/d3install2shoprelation.php',
        'd3installdbtable'          => '_d3modcfg/models/installwizzard/d3installdbtable.php',
        'd3installdbtablemultilang' => '_d3modcfg/models/installwizzard/d3installdbtablemultilang.php',
        'd3installdbtablemultishop' => '_d3modcfg/models/installwizzard/d3installdbtablemultishop.php',
        'd3installdbfield'          => '_d3modcfg/models/installwizzard/d3installdbfield.php',
        'd3installdbfieldmultilang' => '_d3modcfg/models/installwizzard/d3installdbfieldmultilang.php',
        'd3installdbfieldcollation' => '_d3modcfg/models/installwizzard/d3installdbfieldcollation.php',
        'd3installdbindizes'        => '_d3modcfg/models/installwizzard/d3installdbindizes.php',
        'd3installdbrecord'         => '_d3modcfg/models/installwizzard/d3installdbrecord.php',
        'd3installdbrecordmultilang'=> '_d3modcfg/models/installwizzard/d3installdbrecordmultilang.php',
        'd3installconfirmmessage'   => '_d3modcfg/models/installwizzard/d3installconfirmmessage.php',
        'd3installupdatefile'       => '_d3modcfg/models/installwizzard/d3installupdatefile.php',
        'd3installdbcommon'         => '_d3modcfg/models/installwizzard/d3installdbcommon.php',
        'd3installoxconfig'         => '_d3modcfg/models/installwizzard/d3installoxconfig.php',
        'd3installmodule'           => '_d3modcfg/models/installwizzard/d3installmodule.php',
        'd3installmodcfg'           => '_d3modcfg/models/installwizzard/d3installmodcfg.php',
        'd3installskipupdate'       => '_d3modcfg/models/installwizzard/d3installskipupdate.php',
        'd3installskipjob'          => '_d3modcfg/models/installwizzard/d3installskipjob.php',
        'd3installfile'             => '_d3modcfg/models/installwizzard/d3installfile.php',

        #d3install
        'd3_mod_install'       => '_d3modcfg/controllers/admin/d3_mod_install.php',
        'd3_mod_update'        => '_d3modcfg/controllers/admin/d3_mod_update.php',
        'd3bit'                => '_d3modcfg/models/d3bit.php',
        'd3database'           => '_d3modcfg/models/d3database.php',
        'd3filesystem'         => '_d3modcfg/models/d3filesystem.php',
        'd3install'            => '_d3modcfg/models/d3install.php',
        'd3remotecache'        => '_d3modcfg/models/d3remotecache.php',
        'd3install_updatebase' => '_d3modcfg/models/d3install_updatebase.php',
        'd3simplexml'          => '_d3modcfg/models/d3simplexml.php',
        'd3str'                => '_d3modcfg/models/d3str.php',
        'd3stream'             => '_d3modcfg/models/d3stream.php',
        'd3webdav'             => '_d3modcfg/models/d3webdav.php',
        
        #d3log
        'd3_cfg_log'                                     => '_d3modcfg/controllers/admin/d3_cfg_log.php',
        'd3_cfg_log_export'                              => '_d3modcfg/controllers/admin/d3_cfg_log_export.php',
        'd3_cfg_log_cleanup'                              => '_d3modcfg/controllers/admin/d3_cfg_log_cleanup.php',
        'd3_cfg_log_list'                                => '_d3modcfg/controllers/admin/d3_cfg_log_list.php',
        'd3_cfg_log_main'                                => '_d3modcfg/controllers/admin/d3_cfg_log_main.php',
        'd3log'                                          => '_d3modcfg/models/d3log.php',
        'd3log_exception'                                => '_d3modcfg/models/d3log_exception.php',
        'd3log_update'                                   => '_d3modcfg/setup/d3log_update.php',
        'd3transactionlog'                               => '_d3modcfg/models/d3transactionlog.php',
        'd3transactionloglist'                           => '_d3modcfg/models/d3transactionloglist.php',
        'd3_d3log_models_transactionlog_reader_abstract' => '_d3modcfg/models/transactionlog/reader/abstract.php',
        'd3_d3log_models_oxobject2d3transactionlog'      => '_d3modcfg/models/oxobject2d3transactionlog.php',
        
        #d3cleartmp
        'd3cleartmp'       => '_d3modcfg/controllers/admin/d3cleartmp.php',
        'd3clrtmp'         => '_d3modcfg/models/d3clrtmp.php',
        'd3cleartmp_frame' => '_d3modcfg/controllers/admin/d3cleartmp_frame.php',
        'd3cleartmp_list'  => '_d3modcfg/controllers/admin/d3cleartmp_list.php',
        'd3shopmaintenance'=> '_d3modcfg/controllers/admin/d3shopmaintenance.php',
    ),
    'blocks'      => array(),
    'settings'    => array(
        array(
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToFlow_'.$sModuleId,
            'type' => 'str',
        ),
        array(
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToMobile_'.$sModuleId,
            'type' => 'str',
        ),
        array(
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToAzure_'.$sModuleId,
            'type' => 'str',
        ),
    ),
    'templates'   => array(
        #d3_cfg_mod
        'd3_cfg_mod_.tpl'        => '_d3modcfg/views/admin/tpl/d3_cfg_mod_.tpl',
        'd3_adm_header.tpl'      => '_d3modcfg/views/admin/tpl/d3_adm_header.tpl',
        'd3_adm_navigation.tpl'  => '_d3modcfg/views/admin/tpl/d3_adm_navigation.tpl',
        'd3_cfg_mod_inc.tpl'     => '_d3modcfg/views/admin/tpl/inc/d3_cfg_mod_inc.tpl',
        'd3_cfg_mod_bottom.tpl'  => '_d3modcfg/views/admin/tpl/inc/d3_cfg_mod_bottom.tpl',
        'd3_cfg_mod_active.tpl'  => '_d3modcfg/views/admin/tpl/inc/d3_cfg_mod_active.tpl',
        'd3_modprofile_actionbuttons.tpl'  => '_d3modcfg/views/admin/tpl/inc/d3_modprofile_actionbuttons.tpl',
        'd3_cfg_mod_licence.tpl' => '_d3modcfg/views/admin/tpl/d3_cfg_mod_licence.tpl',
        'd3_cfg_mod_list.tpl'    => '_d3modcfg/views/admin/tpl/d3_cfg_mod_list.tpl',
        'd3_cfg_mod_main.tpl'    => '_d3modcfg/views/admin/tpl/d3_cfg_mod_main.tpl',
        'd3cfgitems.tpl'         => '_d3modcfg/views/admin/tpl/d3cfgitems.tpl',
        'd3modcfg_lib_cfg.tpl'   => '_d3modcfg/views/admin/tpl/d3modcfg_lib_cfg.tpl',
        'd3moditems.tpl'         => '_d3modcfg/views/admin/tpl/d3moditems.tpl',
        'd3modlib_status.tpl'    => '_d3modcfg/views/admin/tpl/d3modlib_status.tpl',
        'd3mod_activation.tpl'   => '_d3modcfg/views/admin/tpl/d3mod_activation.tpl',
        'd3maintenance.tpl'      => '_d3modcfg/views/admin/tpl/d3maintenance.tpl',
        'd3pagenavigation.tpl'   => '_d3modcfg/views/admin/tpl/d3pagenavigation.tpl',
        
        #d3install
        'd3_mod_install.tpl'    => '_d3modcfg/views/admin/tpl/d3_mod_install.tpl',
        'd3_mod_update.tpl'     => '_d3modcfg/views/admin/tpl/d3_mod_update.tpl',
        'd3install_lib_cfg.tpl' => '_d3modcfg/views/admin/tpl/d3install_lib_cfg.tpl',
        
        #d3log
        'd3_cfg_log_cleanup.tpl' => '_d3modcfg/views/admin/tpl/d3_cfg_log_cleanup.tpl',
        'd3_cfg_log_export.tpl'  => '_d3modcfg/views/admin/tpl/d3_cfg_log_export.tpl',
        'd3_cfg_log_list.tpl'    => '_d3modcfg/views/admin/tpl/d3_cfg_log_list.tpl',
        'd3_cfg_log_main.tpl'    => '_d3modcfg/views/admin/tpl/d3_cfg_log_main.tpl',
        'd3log_lib_cfg.tpl'      => '_d3modcfg/views/admin/tpl/d3log_lib_cfg.tpl',
        'd3loglevel_form.tpl'    => '_d3modcfg/views/admin/tpl/inc/d3loglevel_form.tpl',
        
        #d3cleartmp
        'd3cleartmp.tpl'       => '_d3modcfg/views/admin/tpl/d3cleartmp.tpl',
        'd3clrtmp_lib_cfg.tpl' => '_d3modcfg/views/admin/tpl/d3clrtmp_lib_cfg.tpl',
        'd3shopmaintenance.tpl'=> '_d3modcfg/views/admin/tpl/d3shopmaintenance.tpl',
    ),
    'events'      => array(
        'onActivate'   => 'd3install::checkUpdateStart',
        'onDeactivate'   => 'd3install::onDeactivate',
    ),

    'd3FileRegister'    => array(
        '_d3modcfg/metadata.php',
        '_d3modcfg/IntelliSenseHelper.php',
        '_d3modcfg/core/smarty/plugins/block.d3modcfgcheck.php',
        '_d3modcfg/core/smarty/plugins/function.d3getobject.php',
        '_d3modcfg/public/d3logo.php',
        '_d3modcfg/translations/de/d3modcfg_lang.php',
        '_d3modcfg/translations/en/d3modcfg_lang.php',
        '_d3modcfg/views/admin/de/d3clrtmp_lang.php',
        '_d3modcfg/views/admin/de/d3log_lang.php',
        '_d3modcfg/views/admin/de/d3modcfg_lang.php',
        '_d3modcfg/views/admin/de/d3modinstall_lang.php',
        '_d3modcfg/views/admin/de/module_options.php',
        '_d3modcfg/views/admin/en/d3clrtmp_lang.php',
        '_d3modcfg/views/admin/en/d3log_lang.php',
        '_d3modcfg/views/admin/en/d3modcfg_lang.php',
        '_d3modcfg/views/admin/en/d3modinstall_lang.php',
        '_d3modcfg/views/admin/en/module_options.php',
        '_d3modcfg/modules/models/d3_oxmoduleinstaller_activecheck.php', // in shop below 4.9.0 it's not registered
        '_d3modcfg/modules/controllers/admin/d3_roles_bemain_rolesrights.php', // in PE + CE it's not registered
        '_d3modcfg/modules/core/d3_oxemail_log.php',
        '_d3modcfg/public/d3modcfg_maintenance.php',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_1and152.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_1and154.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_1and155.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory52.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory53.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory54.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory55.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory56.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner52cgi.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner52cli.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner53cgi.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner53cli.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner54cgi.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner54cli.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner55cgi.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner55cli.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_mittwald.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost52.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost53.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost54.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost55.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost56.tpl',
        '_d3modcfg/views/admin/tpl/modcfg-pattern/d3shpattern_cron_standard.tpl',
    ),
);

// from 4.9.0 / 5.2.0 and up
if (class_exists('oxmoduleinstaller')) {
    $aModule['extend']['oxmoduleinstaller'] = '_d3modcfg/modules/models/d3_oxmoduleinstaller_activecheck';
}

// EE only
if (class_exists('roles_bemain')) {
    $aModule['extend']['roles_bemain'] = '_d3modcfg/modules/controllers/admin/d3_roles_bemain_rolesrights';
}
