<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @package orderQuantityManager
 * @name d3_oxarticle_oqm
 */
class d3_oxarticle_oqm extends d3_oxarticle_oqm_parent
{

    /**
     * Extended method of oxarticle::save()
     * We differ between zero and NULL values.
     * Empty string will be converted to NULL value.
     * Zero = 0 will not converted.
     *
     * @see oxarticle::save()
     * @return bool
     */
    public function save()
    {
        $oD3CfgMod = d3_cfg_mod::get(d3_d3oqm_model_handler::D3OQMMODID);
        /** @var oxModule $oModule */
        $oModule = oxNew('oxmodule');

        //is module inactive?
        if ($oD3CfgMod && $oD3CfgMod->getFieldData('oxactive') && $oModule->load(
            "d3/" . d3_d3oqm_model_handler::D3OQMMODID
        ) && $oModule->isActive()
        ) {

            foreach ($this->_aFieldNames as $sName => $sVal) {
                $sLongName = $this->_getFieldLongName($sName);
                // we work with values 0 and NULL in the database. We have to react on these values.
                // We convert empty strings and false values to NULL
                // all fields with 'd3oqm' are affected
                if (stripos($sLongName, 'd3oqm') !== false && trim($this->$sLongName->value) == '') {
                    $this->$sLongName->value = null;
                }
            }
        }

        return parent::save();
    }

    /**
     * Returns an array with all available options for this article.
     *
     * @return array
     */
    public function getD3OQMArticleOptions()
    {
        $aOptionArray = array();
        $oD3CfgMod    = d3_cfg_mod::get(d3_d3oqm_model_handler::D3OQMMODID);
        /** @var oxModule $oModule */
        $oModule = oxNew('oxmodule');

        //is module inactive?
        if (false == $oD3CfgMod && false == $oD3CfgMod->getFieldData('oxactive') || false == $oModule->load(
            "d3/" . d3_d3oqm_model_handler::D3OQMMODID
        ) || false == $oModule->isActive()
        ) {
            return $aOptionArray;
        }
        // get all avaible option names
        $aTmpOptions = d3_d3oqm_model_handler::getInstance()->getOptionFieldNames();

        foreach ($aTmpOptions as $sOptionName) {
            $sOptionValue = $this->getFieldData($sOptionName);

            if (false == empty($sOptionValue)) {
                $aOptionArray[$sOptionName] = $sOptionValue;
            }
        }

        return $aOptionArray;
    }

    /**
     * check if this article has avaible options.
     *
     * @return bool
     */
    public function hasD3OQMAvailableOptions()
    {
        $oD3CfgMod = d3_cfg_mod::get(d3_d3oqm_model_handler::D3OQMMODID);
        /** @var oxModule $oModule */
        $oModule = oxNew('oxmodule');

        //is module inactive?
        if (false == $oD3CfgMod && false == $oD3CfgMod->getFieldData('oxactive') || false == $oModule->load(
            "d3/" . d3_d3oqm_model_handler::D3OQMMODID
        ) || false == $oModule->isActive()
        ) {
            return false;
        }

        return (bool)count($this->getD3OQMArticleOptions());
    }
}
