<?php

/**
 * User: kristianhempel
 * Date: 04.03.13
 * automatische Installation
 */
class d3oqm_update extends d3install_updatebase
{
    // Standardwert fr checkModCfgSameRevision() und updateModCfgSameRevision()
    public $sModKey = 'd3oqm';
    public $sModName = 'D3 Bestellmengen Manager';
    public $sModVersion = '4.1.1.0';
    public $sModRevision = '248';
    public $sBaseConf = 'CZUZFIrbTk5NmZ0alk3VGhZVm92ZTJVWGlSMEdONVpJRjJub1QvTWY1dGZGN3A5ZW9QdjE1b2M2eElOb
0tranBiU1pPWmdvVjdhREo2ZnEvSXR0MzArN0tqVnM1N2pwSVN2M2Y5cDdHbUlORmFoU3NIaFlFUEk1V
3pQeVR3d3I3V2FacUF3UWFET1VqdWdmVDU3ZmNXcWRxcDd0a2w4QmFlN2JGK2FYVjFoa1Blc1ZrRnFJK
3R2cGtCeFVwRVBpeUJuK2EvMFErcWF1SHFTUnFXUnU2OUlkWmJKMGZ0NStZMFFkRXQwOWVkTUdWdEVwS
1Y5UmI1NUdOQTBFcnBWN2w0M1oweGt1dDU4NUN3RHBSN2tpSWREUlBwZGNXa1dPYVU3aWUxZGo1cGcrR
FE9';

    public $sBaseValue = '';
    public $sMinModCfgVersion = '4.3.7.0';

    // auszufhrende Check- und Updateanweisungen in auszufhrender Reihenfolge
    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkWrongTemplateBlock',
            'do'    => 'fixWrongTemplateBlock',
        ),
        array(
            'check' => 'hasOldOxmoduleInOxtplblocks',
            'do'    => 'fixOldOxmoduleInOxtplblocks',
        ),
        array(
            'check' => 'checkFields',
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'checkIndizes',
            'do'    => 'fixIndizes'
        ),
        array(
            'check' => 'hasInitialTypeField',
            'do'    => 'updateInitialTypeField',
        ),
        array(
            'check' => 'hasInitialValueField',
            'do'    => 'updateInitialValueField',
        ),
        array(
            'check' => 'checkModCfgSameRevision', // prft auf nachgezogene Revisionsnummer und bertrgt diese ggf.
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    /***** Standardwerte fr aufgerufene Funktionen ********************************************/

    // alle zu aktualisierenden Module, verwendet nicht onDeactivate-Handler
    protected $_aRefreshMetaModuleIds = array('d3oqm');

    // Standardwerte fr checkFields(), _addTable() und fixFields()
    public $aFields = array(
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_PACKAGE',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Verpackungseinheit',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_MINIMUM',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Minimum',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_MAXIMUM',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Maximum',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
    );

    // Standardwerte fr checkIndizes() und fixIndizes()
    public $aIndizes = array(
        array(
            'sTableName'  => 'oxarticles',
            'sType'       => 'INDEX',
            'sName'       => 'D3OQMINDEX',
            'aFields'     => array(
                'D3OQM_PACKAGE' => 'D3OQM_PACKAGE',
                'D3OQM_MAXIMUM' => 'D3OQM_MAXIMUM',
                'D3OQM_MINIMUM' => 'D3OQM_MINIMUM',
            ),
            'blMultilang' => false,
        ),
    );

    ///----------------------------------------

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $oShop = $this->getActShop();

        $aWhere = array(
            'oxmodid'       => $this->sModKey,
            'oxnewrevision' => $this->sModRevision,
            'oxshopid'      => $oShop->getId(),
        );

        return $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            $oShop         = $this->getActShop();
            $aWhere        = array(
                'oxmodid'  => $this->sModKey,
                'oxshopid' => $oShop->getId(),
            );
            $aInsertFields = array(
                'OXID'           => array(
                    'content'      => "md5('" . $this->sModKey . " " . $oShop->getId() . " de')",
                    'force_update' => true,
                ),
                'OXSHOPID'       => array(
                    'content'      => "'" . $oShop->getId() . "'",
                    'force_update' => true,
                ),
                'OXMODID'        => array(
                    'content'      => "'" . $this->sModKey . "'",
                    'force_update' => true,
                ),
                'OXNAME'         => array(
                    'content'      => "'" . $this->sModName . "'",
                    'force_update' => true,
                ),
                'OXACTIVE'       => array(
                    'content'      => "0",
                    'force_update' => false,
                ),
                'OXBASECONFIG'   => array(
                    'content'      => "'" . $this->sBaseConf . "'",
                    'force_update' => true,
                ),
                'OXINSTALLDATE'  => array(
                    'content'      => "NOW()",
                    'force_update' => true,
                ),
                'OXVERSION'      => array(
                    'content'      => "'" . $this->sModVersion . "'",
                    'force_update' => true,
                ),
                'OXSHOPVERSION'  => array(
                    'content'      => "'" . oxRegistry::getConfig()->getEdition() . "'",
                    'force_update' => true,
                ),
                'OXREQUIREMENTS' => array(
                    'content'      => "'" . $this->sRequirements . "'",
                    'force_update' => true,
                ),
                'OXVALUE'        => array(
                    'content'      => "'" . $this->sBaseValue . "'",
                    'force_update' => false,
                ),
                'OXNEWREVISION'  => array(
                    'content'      => "'" . $this->sModRevision . "'",
                    'force_update' => true,
                )
            );
            $aRet          = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
            $blRet         = $aRet['blRet'];
        }

        return $blRet;
    }

    ///----------------------------------------

    /**
     * check if wrong template block
     *
     * @return bool
     */
    public function checkWrongTemplateBlock()
    {
        $oShop  = $this->getActShop();
        $aWhere = array(
            'oxfile'      => 'd3GetMinAmout_input_field',
            'oxblockname' => 'widget_product_listitem_grid_tobasket',
            'oxshopid'    => $oShop->getId(),
        );

        // NOTE: _checkTableItemExist returns true if not exsist
        return !$this->_checkTableItemNotExist('oxtplblocks', $aWhere);
    }

    /**
     * fix Version 3.2.0.1
     *
     * @return bool
     */
    public function fixWrongTemplateBlock()
    {
        $blRet = false;

        if ($this->checkWrongTemplateBlock()) {
            $oShop = $this->getActShop();

            $aWhere = array(
                'oxfile'      => 'd3GetMinAmout_input_field',
                'oxblockname' => 'widget_product_listitem_grid_tobasket',
                'oxshopid'    => $oShop->getId(),
            );

            // abwrtskompatibel auch mit Feldname als Key (siehe "OXNAME"),
            // dann jedoch keine Duplikatentfernung bei mehrfacher Feldzuweisung.
            $aInsertFields = array(
                array(
                    // Feldname ggf. sprachspezifisch mit _getLangAbbrFieldName()
                    'fieldname'     => 'OXFILE',
                    // Feldinhalt
                    'content'       => 'widget_product_listitem_grid_tobasket.tpl',
                    // bei Update, Inhalt wird berschrieben
                    'force_update'  => true,
                    // Inhalt muss gequoted werden
                    'use_quote'     => true,
                    // Multilang-Felder auf Basis dieses Feldes werden bei INSERT mit diesem Wert gefllt,
                    // wenn diese in der Liste nicht anderweitig belegt sind
                    'use_multilang' => false,
                ),
            );
            $aRet          = $this->_updateTableItem2('oxtplblocks', $aInsertFields, $aWhere);
            $blRet         = $aRet['blRet'];
        }

        return $blRet;
    }

    /**
     * check if 'd3/d3oqm' is in oxmodule
     *
     * @return bool
     */
    public function hasOldOxmoduleInOxtplblocks()
    {
        $oShop = $this->getActShop();

        $aWhere = array(
            'oxmodule' => 'd3/d3oqm',
            'oxshopid' => $oShop->getId(),
        );

        // NOTE: _checkTableItemExist returns true if not exsist
        return !$this->_checkTableItemNotExist('oxtplblocks', $aWhere);
    }

    /**
     * @return bool
     */
    public function fixOldOxmoduleInOxtplblocks()
    {
        if ($this->hasOldOxmoduleInOxtplblocks()) {
            $oShop = $this->getActShop();
            $aQueries = array(
                "DELETE FROM oxtplblocks WHERE oxmodule = 'd3/d3oqm' AND  oxshopid = '{$oShop->getId()}';"
            );

            return $this->_executeMultipleQueries($aQueries);
        }

        return true;
    }

    /**
     * @param null $iDirectNumber
     *
     * @return bool
     */
    public function hasInitialTypeField($iDirectNumber = null)
    {
        $blReturn = false;
        if ($iDirectNumber === null) {
            for ($i = 0; $i <= 2; $i++) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_type{$iNumber}");
                if ($blReturn) {
                    return $blReturn;
                }
            }
        } else {
            $iNumber  = $iDirectNumber == 0 ? null : $iDirectNumber;
            $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_type{$iNumber}");
        }

        return $blReturn;
    }

    /**
     * @return bool
     */
    public function updateInitialTypeField()
    {
        $blReturn = false;

        for ($i = 0; $i <= 2; $i++) {
            if ($this->hasInitialTypeField($i)) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_updateInitialTypeField($iNumber);
            }
        }

        return $blReturn;
    }

    /**
     * @param null $iNumber
     *
     * @return bool
     */
    protected function _updateInitialTypeField($iNumber = null)
    {
        if ($this->hasInitialTypeField($iNumber)) {
            $aQueries = array(
                "UPDATE oxarticles SET D3OQM_MINIMUM = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'minimum' AND D3OQM_MINIMUM = 0;",
                "UPDATE oxarticles SET D3OQM_MAXIMUM = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'maximum' AND D3OQM_MAXIMUM = 0;",
                "UPDATE oxarticles SET D3OQM_PACKAGE = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'package' AND D3OQM_PACKAGE = 0;",
                "ALTER TABLE `oxarticles` DROP `d3_ve_type{$iNumber}`;",
            );
            $blReturn = $this->_executeMultipleQueries($aQueries);
            $this->_getDatabaseHandler()->resetFieldCache();
            if ($blReturn) {
                $this->_blRequireViewUpdate = true;
            }

            return $blReturn;
        }

        return true;
    }

    /**
     * definition array see fixFields
     *
     *
     * @return bool
     */
    public function fixFields()
    {
        $blReturn = parent::fixFields();
        if ($blReturn) {
            $this->_blRequireViewUpdate = true;
        }

        return $blReturn;
    }

    /**
     * @param null $iDirectNumber
     *
     * @return bool
     */
    public function hasInitialValueField($iDirectNumber = null)
    {
        $blReturn = false;
        if ($iDirectNumber === null) {
            for ($i = 0; $i <= 2; $i++) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_value{$iNumber}");
                if ($blReturn) {
                    return $blReturn;
                }
            }
        } else {
            $iNumber  = $iDirectNumber == 0 ? null : $iDirectNumber;
            $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_value{$iNumber}");
        }

        return $blReturn;
    }

    /**
     * @return bool
     */
    public function updateInitialValueField()
    {
        $blReturn = false;

        for ($i = 0; $i <= 2; $i++) {
            if ($this->hasInitialValueField($i)) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_updateInitialValueField($iNumber);
            }
        }

        return $blReturn;
    }

    /**
     * @param null $iNumber
     *
     * @return bool
     */
    protected function _updateInitialValueField($iNumber = null)
    {
        if ($this->hasInitialValueField($iNumber)) {
            $aQueries = array(
                "ALTER TABLE `oxarticles` DROP `d3_ve_value{$iNumber}`;"
            );
            $blReturn = $this->_executeMultipleQueries($aQueries);
            $this->_getDatabaseHandler()->resetFieldCache();
            if ($blReturn) {
                $this->_blRequireViewUpdate = true;
            }

            return $blReturn;
        }

        return true;
    }

}
