<?php

/**
 * Class d3_oxarticle_longtexts
 */
class d3_oxarticle_longtexts extends d3_oxarticle_longtexts_parent
{
    /**
     * @param $sLongDesc
     * @param $sField
     * @param $iLang
     */
    public function saveContentTabLongDesc($sLongDesc, $sField, $iLang)
    {
        $oDB             = oxDb::getDb(oxDb::getDb(ADODB_FETCH_ASSOC));
        $sViewName       = getViewName('oxartextends', (int)$iLang);
        $sQuotedLongdesc = $oDB->quote($sLongDesc);

        $sLongDescSQL = "INSERT INTO " . $sViewName . " (oxid, $sField) " //
            . "VALUES (" . $oDB->quote($this->getId()) . "," . $sQuotedLongdesc .") " //
            . "ON DUPLICATE KEY UPDATE $sField = " . $sQuotedLongdesc;
        $oDB->execute($sLongDescSQL);
    }

    /**
     * @return object
     */
    public function getLongDescription()
    {
        oxNew('d3_contentTabs_application_models_handler', $this)->getD3LongDescription();

        return parent::getLongDescription();
    }

    /**
     * @param string $sFieldName
     *
     * @return bool
     */
    public function isMultilingualField($sFieldName)
    {
        switch ($sFieldName) {
            case 'd3longdesc2':
            case 'd3longdesc3':
            case 'd3longdesc4':
            case 'd3longdesc5':
                return true;
        }

        return parent::isMultilingualField($sFieldName);
    }

    /**
     * @param mixed $sName
     *
     * @return bool
     */
    public function __isset($sName)
    {
        switch ($sName) {
            case 'oxarticles__oxlongdesc':
            case 'oxarticles__d3longdesc2':
            case 'oxarticles__d3longdesc3':
            case 'oxarticles__d3longdesc4':
            case 'oxarticles__d3longdesc5':
                //get empty oxlongdesc field
                $this->getLongDescription();

                return true;
        }

        return parent::__isset($sName);
    }
}
