<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3usermanagerList extends d3modprofileList
{
    /**
     * List Object class name
     *
     * @var string
     */
    protected $_sObjectsInListName = 'd3usermanager';

    /**
     * @param $sFolderId
     * @return d3usermanagerList
     * @throws oxConnectionException
     */
    public function d3GetManuallyManagerJobsByFolder($sFolderId)
    {
        /** @var d3usermanager $oListObject */
        $oListObject = $this->getBaseObject();
        $sFieldList = $oListObject->getSelectFields();
        $sQ = "select $sFieldList from " . $oListObject->getViewName();

        $sQ .= " where ";
        $sQ = $this->d3AddActiveSnippet($oListObject, $sQ, true);
        $sQ = $this->d3AddFolderSelection($sFolderId, $oListObject, $sQ);
        $sQ .= " ORDER BY ".$oListObject->getViewName().".oxsort ASC, ".$oListObject->getViewName().".oxfolder ASC";

        $this->selectString($sQ);

        /** @var $oManager d3usermanager */
        foreach ($this->getArray() as $sKey => $oManager) {
            if (false == $this->canExecutedManually($oManager)) {
                $this->offsetUnset($sKey);
            }
        }

        return $this;
    }

    /**
     * @param d3usermanager $oManager
     *
     * @return bool
     * @throws oxConnectionException
     */
    public function canExecutedManually(d3usermanager $oManager)
    {
        return $oManager->getFieldData('D3_UM_EXECMANUALLY') &&
               $oManager->getLicenseActive();
    }

    /**
     * @param d3usermanager $oListObject
     * @param               $sQ
     * @param bool $blManually
     *
     * @return string
     * @throws oxConnectionException
     */
    public function d3AddActiveSnippet(d3usermanager $oListObject, $sQ, $blManually = false)
    {
        $sActiveSnippet = $oListObject->getSqlActiveSnippet();
        if ($sActiveSnippet) {
            $sQ .= " $sActiveSnippet ";
        } else {
            $sQ .= " 1 ";
        }

        if ($blManually) {
            $sFieldName = d3utils::getInstance()->getMultiLangFieldName(
                'D3_UM_EXECMANUALLY',
                '',
                $oListObject
            );
        } else {
            $sFieldName = d3utils::getInstance()->getMultiLangFieldName(
                'oxactive',
                '',
                $oListObject
            );
        }

        $sQ .= " AND " . $oListObject->getViewName() . "." . $sFieldName . " = 1 ";

        return $sQ;
    }

    /**
     * @param               $sFolderId
     * @param d3usermanager $oListObject
     * @param               $sQ
     *
     * @return string
     * @throws oxConnectionException
     */
    public function d3AddFolderSelection($sFolderId, d3usermanager $oListObject, $sQ)
    {
        if ($sFolderId && $sFolderId != '-1') {
            $sQ .= " AND " . $oListObject->getViewName() . ".oxfolder = " . oxDb::getDb()->quote($sFolderId);
        }

        return $sQ;
    }

    /**
     * @param bool|string $iCronJobId
     */
    public function setCronJobId($iCronJobId)
    {
        /** @var d3usermanager $oBaseObject */
        $oBaseObject = $this->getBaseObject();
        $oBaseObject->setCronJobIdFilter($iCronJobId);
    }
}
