<?php
 /**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_cfg_usermanageritem_settings extends d3_cfg_mod_main
{
    protected $_sSetModId = 'd3usermanager';
    protected $_sMenuItemTitle = 'd3mxusermanager';
    protected $_blUseOwnOxid = true;
    protected $_aNaviItems = array(
        'new' => array(
            'sScript' => 'top.oxid.admin.editThis( -1 );return false;',
            'sTranslationId' => 'D3_TOOLTIPS_NEWUSERMANAGER',
        ),
    );
    protected $_sD3ObjectClass = 'd3usermanager';

    /**
     * @return array
     */
    public function getItemFolders()
    {
        return oxRegistry::getConfig()->getConfigParam('aUserfolder');
    }

    /**
     * @return oxlist
     */
    public function getGroupsList()
    {
        /** @var $oGroupsList oxlist */
        $oGroupsList = oxNew('oxlist');
        $oGroupsList->init('oxgroups');
        return $this->_getObjectList($oGroupsList);
    }

    /**
     * @param oxlist $oObjectList
     *
     * @return oxlist
     */
    protected function _getObjectList($oObjectList)
    {
        startProfile(__METHOD__);

        /** @var $oObject oxi18n */
        $oObject = $oObjectList->getBaseObject();
        if ($oObject->isMultilang()) {
            $oObject->setLanguage(oxRegistry::getLang()->getTplLanguage());
        }
        $sFieldList = $oObject->getSelectFields();
        $sQ = "select $sFieldList from " . $oObject->getViewName();
        $oObjectList->selectString($sQ);

        stopProfile(__METHOD__);

        return $oObjectList;
    }

    /**
     * @return bool
     */
    public function isEditMode()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getRestrictionMessage()
    {
        return sprintf(
            oxRegistry::getLang()->translateString('D3_USERMANAGER_ERROR_RESTRICTIONS'),
            d3_cfg_mod::get($this->_sSetModId)->getLicenseConfigData('sEditionId', 'unknown')
        );
    }
}
