<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @link      http://www.oxidmodule.com
 */

use OxidEsales\Eshop\Application as OxidCore;

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'          => 'd3articlevoucher',
    'title'       => (class_exists(\D3\ModCfg\Application\Model\d3utils::class) ? \D3\ModCfg\Application\Model\d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Artikelgutscheine',
    'description' =>   array(
        'de' =>  'Erm&ouml;glicht Artikel als Gutscheinwert zu verwenden',
        'en' =>  '',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '4.0.0.1',
    'author'      => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',

    'events'      => array(
      'onActivate' => \D3\ModCfg\Application\Model\Install\d3install::class . '::checkUpdateStart',
    ),
    'd3SetupClasses' => array(
        d3articlevoucher_update::class,
    ),
    'extend'       => array(
        OxidCore\Controller\Admin\VoucherSerieMain::class => 'd3/d3articlevoucher/modules/controllers/admin/d3_voucherserie_main_addarticle',
        OxidCore\Model\DiscountList::class                => 'd3/d3articlevoucher/modules/models/d3_oxdiscountlist_articlevoucher',
        OxidCore\Model\Discount::class                    => 'd3/d3articlevoucher/modules/models/d3_oxdiscount_articlevoucher',
        OxidCore\Model\Basket::class                      => 'd3/d3articlevoucher/modules/models/d3_oxbasket_articlevoucher',
        OxidCore\Model\BasketItem::class                  => 'd3/d3articlevoucher/modules/models/d3_oxbasketitem_articlevoucher',
        OxidCore\Model\Article::class                     => 'd3/d3articlevoucher/modules/models/d3_oxarticle_articlevoucher',
        OxidCore\Model\Voucher::class                     => 'd3/d3articlevoucher/modules/models/d3_oxvoucher_articlevoucher',
        OxidCore\Controller\BasketController::class       => 'd3/d3articlevoucher/modules/controllers/d3_basket_updatevoucherinfo',
    ),
    'files' => array(
        d3articlevoucher_update::class    => 'd3/d3articlevoucher/setup/d3articlevoucher_update.php',
        d3articlevoucher::class           => 'd3/d3articlevoucher/models/d3articlevoucher.php',
    ),
    'templates'   => array(
        'headitem_d3voucher_css.tpl' => 'd3/d3articlevoucher/views/admin/blocks/headitem_d3voucher_css.tpl',
        'headitem_d3voucher_js.tpl'  => 'd3/d3articlevoucher/views/admin/blocks/headitem_d3voucher_js.tpl',
        'd3_voucherserie_main.tpl'   => 'd3/d3articlevoucher/views/admin/blocks/d3_voucherserie_main.tpl',
    ),
    'blocks' => array(
        // Admin Templateerweiterung and CSS / Javascript
        array(
            'template' => 'headitem.tpl',
            'block'    => 'admin_headitem_inccss',
            'file'     => 'views/admin/blocks/headitem_d3voucher_css.tpl'
        ),
        array(
            'template' => 'headitem.tpl',
            'block'    => 'admin_headitem_incjs',
            'file'     => 'views/admin/blocks/headitem_d3voucher_js.tpl'
        ),
        array(
            'template' => 'voucherserie_main.tpl',
            'block'    => 'admin_voucherserie_main_form_discount_type',
            'file'     => 'views/admin/blocks/d3_voucherserie_main.tpl'
        ),
        // Frontend Templateerweiterung
        array(
            'template' => 'page/checkout/inc/basketcontents.tpl',
            'block'    => 'checkout_basketcontents_voucherdiscount',
            'file'     => 'views/blocks/checkout_basketcontents_voucherdiscount.tpl'
        ),
        array(
            'template' => 'page/checkout/inc/basketcontents.tpl',
            'block'    => 'checkout_basketcontents_summary',
            'file'     => 'views/blocks/checkout_basketcontents_summary.tpl'
        ),
        array(
            'template' => 'page/checkout/inc/basketcontents.tpl',
            'block'    => 'checkout_basketcontents_basketitem_quantity',
            'file'     => 'views/blocks/checkout_basketcontents_basketitem_quantity.tpl'
        ),
        array(
            'template' => 'page/checkout/inc/basketcontents_table.tpl',
            'block'    => 'checkout_basketcontents_basketitem_quantity',
            'file'     => 'views/blocks/checkout_basketcontents_basketitem_quantity_table.tpl'
        ),
        array(
            'template' => 'page/checkout/basket.tpl',
            'block'    => 'checkout_basket_main',
            'file'     => 'views/blocks/checkout_basket_main_adderrormessages.tpl'
        ),
    ),
    'settings' => array(
        array(
            'group' => 'd3articlevoucher_buyablestate',
            'name'  => 'blD3AVArticlesArentBuyable',
            'type'  => 'bool',
            'value' => 'false'
        ),
    ),
);
