<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @link      http://www.oxidmodule.com
 */

/**
 * Class d3articlevoucher_update
 */
class d3articlevoucher_update extends d3install_updatebase
{
    /*******************************************************************************************/
    /***** Standardwerte fr aufgerufene Funktionen ********************************************/
    /*******************************************************************************************/

    public $sModKey = 'd3articlevoucher';
    public $sModName = 'Artikelgutscheine';
    public $sModVersion = '3.1.0.3';
    public $sModRevision = '3103';
    public $sBaseConf = 'Y1yv2==Rjd5K2VBWUNGTHdUSE9UMjV5a0NEWEx0RUlUa3ZpUm1zRU53SmZkaTZWcXFvYjFyaEZLTENQO
HpwL3pNQ1dhTmVDNXZuVjIyWmNtMCtNRHFhOGU2QkNOZWhjSmY1eTc4NFRCUi9ScS91QU5GMXdVMlI5a
0d2dXBrWE1td3ErM0dRS2JXdDl4ckw1TGg5UHA3ZDZqRHFubVUrOUQyMWVua3lRL1p4aUVLNHdVOVlya
m5ocXptMFlvdmFEODNHUm1NbC90N0N4QmQ2ajJNUFIxZ2lwRVdUUCtnWmFOY0lHNFNjVWhjck1OY1IzW
kFXdEhLcVdMRUJmRUY3c0czRlNNQWw4OFU0QjlHWlFXK3VVbjJhMStOT2pMVVlMWmlDbWtOaFg1S1VSR
0RsaE90QmdXbHJkOGo5SzRKZkNFV2xpNlR2THlWR0ZhQ2ZXc3ZTbUtFeTJ3WEtBPT0=';
    public $sRequirements = '';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist', // prft mod-cfg-Eintrag und legt ihn ggf. an
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkFields', // prft Felder in Tabelle und legt sie ggf. an bzw. modifiziert diese
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'hasOldModuleFiles',
            'do'    => 'deleteOldModuleFiles'
        ),
        array(
            'check' => 'checkModCfgSameRevision', // prft mod-cfg-Eintrag und aktualisiert diesen ggf.
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    // Standardwerte fr checkFields(), _addTable() und fixFields()
    public $aFields = array(
        array(
            'sTableName' => 'oxvoucherseries',
            'sFieldName' => 'OXDISCOUNTTYPE',
            'sType' => "ENUM('percent','absolute','discount')",
            'blNull' => false,
            'sDefault' => 'absolute',
            'sComment' => false,
            'sExtra' => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName' => 'oxvoucherseries',
            'sFieldName' => 'D3DISCOUNTID',
            'sType' => 'VARCHAR(32)',
            'blNull' => false,
            'sDefault' => false,
            'sComment' => 'd3articlevoucher',
            'sExtra' => '',
            'blMultilang' => false,
        ),
    );

    // alle zu aktualisierenden Module, verwendet nicht onDeactivate-Handler
    protected $_aRefreshMetaModuleIds = array('d3articlevoucher');

    public $aOldModuleFiles = array(
        'd3/d3articlevoucher/models/d3articlevoucher_update.php'
    );


    /*******************************************************************************************/
    /***** Modul-Eintrag in der d3_cfg_mod -> eintragen und aktualisieren **********************/
    /*******************************************************************************************/

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);
            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }
    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                );
                $aInsertFields = array(
                    'OXID'           => array (
                        'fieldname'     => 'OXID',
                        'content'       => "md5('" . $this->sModKey . " " . $oShop->getId() . " de')",
                        'force_update'  => false,
                        'use_quote'     => false,
                    ),
                    'OXSHOPID'       => array (
                        'fieldname'     => 'OXSHOPID',
                        'content'       => $oShop->getId(),
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXMODID'        => array (
                        'fieldname'     => 'OXMODID',
                        'content'       => $this->sModKey,
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXNAME'         => array (
                        'content'       => $this->sModName,
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXACTIVE'       => array (
                        'content'       => "0",
                        'force_update'  => false,
                        'use_quote'     => false,
                    ),
                    'OXBASECONFIG'   => array (
                        'content'       => $this->sBaseConf,
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXINSTALLDATE'  => array (
                        'content'       => "NOW()",
                        'force_update'  => true,
                        'use_quote'     => false,
                    ),
                    'OXVERSION'      => array (
                        'content'       => $this->sModVersion,
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXSHOPVERSION'  => array (
                        'content'       => oxRegistry::getConfig()->getEdition(),
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXREQUIREMENTS' => array (
                        'content'       => $this->sRequirements,
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    'OXVALUE'        => array(
                        'content'       => $this->sBaseValue,
                        'force_update'  => false,
                        'use_quote'     => true,
                    ),
                    'OXNEWREVISION'  => array(
                        'content'       => $this->sModRevision,
                        'force_update'  => true,
                        'use_quote'     => true,
                    )
                );

                $blRet          = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkModCfgSameRevision()
    {
        return $this->_checkModCfgSameRevision($this->sModKey);
    }
    /**
     * @return bool
     */
    public function updateModCfgSameRevision()
    {
        $blRet = false;

        if ($this->checkModCfgSameRevision()) {
            $aRet = $this->_updateModCfgSameRevision($this->sModKey);

            $this->setActionLog('SQL', $aRet['sql'], __METHOD__);
            $this->setUpdateBreak(false);
            $blRet = $aRet['blRet'];
        }
        return $blRet;
    }
}
