<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @link      http://www.oxidmodule.com
 */

use D3\ModCfg\Application\Model\Install\d3install_updatebase;

/**
 * Class d3articlevoucher_update
 */
class d3articlevoucher_update extends d3install_updatebase
{
    /*******************************************************************************************/
    /***** Standardwerte fr aufgerufene Funktionen ********************************************/
    /*******************************************************************************************/

    public $sModKey = 'd3articlevoucher';
    public $sModName = 'Artikelgutscheine';
    public $sModVersion = '4.0.0.1';
    public $sModRevision = '4001';
    public $sBaseConf = 'x2wv2==WmpSZlU5RjVjNFI5QmZCL2xUVDRVM0ZOVGhWUkRBd2pEeXI3alJTcHZOSWZ2WkJRQmVmNDBFS
jgxZ0p5aVZ0TWhOVHJ4NVl1VkJHNXZ5RVFZNldONW5lRTZ5aEpBR3pvZm1QSG1zSjlvVTN0UGlpQk85R
jlHVlJyVjZIRzJES01XQTdtT3JlR0FzWnY3YUNaMnc0WmRSaDJGYzZUS0RmenpiNHN6ZlBkWWRLblMzc
kM2eUltTW8zWHJnYUFPUlJZY0dGSThrQ3VsQTJSMWEvNlVOUUxMbVVzQjI3L1QyWDFxRldkTDRCWlUrS
kNLdHF3ejJQbjVDOWNQRXozU2NZNzJsYmszeUdreUYzdnRlMytIcFdtZnFCZUJ0K1FzWnJqQlJMV2dId
2VPbi9kMTZNK0pURTJZS1BEYk4xaUVmZ0pJeHQ0akgzT3E1ZWFrNXJaMFVPcjVBPT0=';
    public $sRequirements = '';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist', // prft mod-cfg-Eintrag und legt ihn ggf. an
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkFields', // prft Felder in Tabelle und legt sie ggf. an bzw. modifiziert diese
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'hasOldModuleFiles',
            'do'    => 'deleteOldModuleFiles'
        ),
        array(
            'check' => 'checkModCfgSameRevision', // prft mod-cfg-Eintrag und aktualisiert diesen ggf.
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    // Standardwerte fr checkFields(), _addTable() und fixFields()
    public $aFields = array(
        array(
            'sTableName' => 'oxvoucherseries',
            'sFieldName' => 'OXDISCOUNTTYPE',
            'sType' => "ENUM('percent','absolute','discount')",
            'blNull' => false,
            'sDefault' => 'absolute',
            'sComment' => false,
            'sExtra' => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName' => 'oxvoucherseries',
            'sFieldName' => 'D3DISCOUNTID',
            'sType' => 'VARCHAR(32)',
            'blNull' => false,
            'sDefault' => false,
            'sComment' => 'd3articlevoucher',
            'sExtra' => '',
            'blMultilang' => false,
        ),
    );

    // alle zu aktualisierenden Module, verwendet nicht onDeactivate-Handler
    protected $_aRefreshMetaModuleIds = array('d3articlevoucher');

    public $aOldModuleFiles = array(
        'd3/d3articlevoucher/models/d3articlevoucher_update.php'
    );

}
