<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_ordermanageritem_overview extends d3_cfg_mod_main
{
    protected $_sSetModId = 'd3_ordermanager';
    protected $_sModId = 'd3_ordermanager';
    protected $_sThisTemplate = "d3_cfg_ordermanageritem_overview.tpl";
    protected $_sMenuItemTitle = 'd3mxordermanager';
    protected $_sMenuSubItemTitle = 'd3tbclordermanager_items_overview';
    protected $_blUseOwnOxid = true;
    protected $_aNaviItems = array(
        'new' => array(
            'sScript' => 'top.oxid.admin.editThis( -1 );return false;',
            'sTranslationId' => 'D3_TOOLTIPS_NEWORDERMANAGER',
        ),
    );
    protected $_sD3ObjectClass = 'd3ordermanager';
    protected $_sRequestData;

    /**
     * @param $sName
     * @param $aArguments
     *
     * @return mixed
     */
    public function __call($sName, $aArguments)
    {
        /** @var d3_cfg_ordermanageritem_action $oActionView */
        $oActionView = oxNew('d3_cfg_ordermanageritem_action');
        if (method_exists($oActionView, $sName)) {
            return call_user_func_array(array($oActionView, $sName), $aArguments);
        }

        /** @var d3_cfg_ordermanageritem_requ $oRequView */
        $oRequView = oxNew('d3_cfg_ordermanageritem_requ');
        if (method_exists($oRequView, $sName)) {
            return call_user_func_array(array($oRequView, $sName), $aArguments);
        }

        return parent::__call($sName, $aArguments);
    }

    /**
     * @return d3ordermanager_requirementlist
     */
    public function getRequirementList()
    {
        /** @var d3ordermanager $oManager */
        $oManager = $this->getProfile();
        /** @var d3ordermanager_requirementlist $oRequList */
        $oRequList = oxNew('d3ordermanager_requirementlist', $oManager);
        $oRequList->setRequirements($oManager->getConfiguration()->getRequirementIdList());

        return $oRequList->getRequirementList();
    }

    /**
     * @return d3ordermanager_actionlist
     */
    public function getActionList()
    {
        /** @var d3ordermanager $oManager */
        $oManager = $this->getProfile();
        $oOrder = oxNew('oxorder');
        /** @var d3ordermanager_actionlist $oActionList */
        $oActionList = oxNew('d3ordermanager_actionlist', $oManager, $oOrder);
        $oActionList->setActions($oManager->getConfiguration()->getActionIdList());

        return $oActionList->getActionList();
    }

    /**
     * @return bool
     */
    public function isEditMode()
    {
        return false;
    }

    public function setRequestData()
    {
        $this->_sRequestData = oxRegistry::getConfig()->getRequestParameter('sRequestData');
    }

    /**
     * @return int
     */
    public function getToFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('toFinishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3ordermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getConcernedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('finishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3ordermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getFinishedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getFinishedMonthCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('finishedMonthCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3ordermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getFinishedMonthItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getNotFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('notFinishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3ordermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getNotFinishedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @param $sFunctionName
     *
     * @return bool
     */
    public function canRequestData($sFunctionName)
    {
        return !$this->getDataOnDemand()
            || $this->_sRequestData == $sFunctionName;
    }

    /**
     * @param $iRequestCount
     *
     * @return bool
     */
    public function canUseRequestData($iRequestCount)
    {
        return $this->getDataOnDemand()
            && strlen($iRequestCount);
    }

    /**
     * @return bool
     */
    public function getDataOnDemand()
    {
        return $this->d3GetSet()->getValue('blCalcStatOnDemand');
    }

    /**
     * @param $sRequestName
     * @param $sFunctionName
     *
     * @return bool
     */
    public function hasRequestedData($sRequestName, $sFunctionName)
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter($sRequestName);

        if (strlen($iRequestCount) || $this->_sRequestData == $sFunctionName) {
            return true;
        }

        return false;
    }
}
