<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_ordermanagerset_main extends d3_cfg_mod_main
{
    protected $_sModId = 'd3_ordermanager';
    protected $_sThisTemplate = "d3_cfg_ordermanagerset_main.tpl";
    protected $_blHasDebugSwitch = true;
    protected $_sDebugHelpTextIdent = 'D3_ORDERMANAGER_SET_DEBUG_DESC';

    /**
     * get basic cronjob access password; for cases only, if no password is set
     *
     * @return string
     */
    public function getBaseCronPW()
    {
        $oManager = oxNew('d3ordermanager');
        return $oManager->getBaseCronPW();
    }

    /**
     * @param      $blUsePw
     * @param bool|int $iCronJobId
     *
     * @return string
     */
    public function getCronLink($blUsePw, $iCronJobId = false)
    {
        /** @var $oViewConf oxViewConfig */
        $oViewConf = oxNew('oxViewConfig');

        $sBaseUrl = $oViewConf->getModuleUrl('d3ordermanager').'public/d3_ordermanager_cron.php';

        $aParameters = array(
            'shp' => $oViewConf->getActiveShopId(),
        );

        if ($iCronJobId !== false) {
            $aParameters['cjid'] = $iCronJobId;
        }

        if ($blUsePw) {
            $aParameters['key'] = $this->d3GetSet()->getValue('sCronPassword') ?
                $this->d3GetSet()->getValue('sCronPassword') :
                $this->getBaseCronPW();
        }

        /** @var $oD3Str d3str */
        $oD3Str = oxNew('d3str');
        $sURL   = $oD3Str->generateParameterUrl($sBaseUrl, $aParameters);

        return $sURL;
    }

    /**
     * @return array
     */
    public function getAvailableCronjobIds()
    {
        /** @var d3ordermanager $oManager */
        $oManager = oxNew('d3ordermanager');
        return $oManager->getAvailableCronjobIds();
    }

    /**
     * @param bool|array $aCJID
     *
     * @return string
     */
    public function getCJIDDesc($aCJID)
    {
        if ($aCJID['count'] == 1) {
            return sprintf(
                oxRegistry::getLang()->translateString('D3_ORDERMANAGER_SET_CRON_JOBID', null, true),
                $aCJID['id'],
                $aCJID['count']
            );
        } else {
            return sprintf(
                oxRegistry::getLang()->translateString('D3_ORDERMANAGER_SET_CRON_JOBSID', null, true),
                $aCJID['id'],
                $aCJID['count']
            );
        }
    }

    /**
     * @param bool|int $iCronJobId
     *
     * @return string
     */
    public function getCronTimestampVarName($iCronJobId = false)
    {
        $sVarName = "sCronExecTimestamp";

        if ($iCronJobId !== false) {
            $sVarName .= $iCronJobId;
        }

        return $sVarName;
    }

    /**
     * @return array
     */
    public function getCronProviderList()
    {
        /** @var d3filegeneratorcronsh $oD3ShGenerator */
        $oD3ShGenerator = oxNew('d3filegeneratorcronsh');

        return $oD3ShGenerator->getContentList();
    }

    public function generateCronShFile()
    {
        /** @var oxmodule $oModule */
        $oModule = oxNew('oxmodule');

        /** @var d3ShopCompatibilityAdapterHandler $oD3CompatibilityAdapterHandler */
        $oD3CompatibilityAdapterHandler = oxNew('d3ShopCompatibilityAdapterHandler');
        $sModulePath = $oD3CompatibilityAdapterHandler->call(
            'oxmodule__getModuleFullPath',
            array($oModule, d3_cfg_mod::get($this->_sModId)->getMetaModuleId())
        );

        $sScriptPath = $sModulePath . "/public/d3_ordermanager_cron.php";

        $sCronId = oxRegistry::getConfig()->getRequestParameter('cronid');

        /** @var oxshop $oShop */
        $oShop = oxRegistry::getConfig()->getActiveShop();
        $aParameters = array(
            0 => $oShop->getId(),
            1 => $sCronId,
        );

        /** @var d3filegeneratorcronsh $oD3ShGenerator */
        $oD3ShGenerator = oxNew('d3filegeneratorcronsh');

        $oD3ShGenerator->setContentType(oxRegistry::getConfig()->getRequestParameter('crontype'));
        $oD3ShGenerator->setScriptPath($sScriptPath);
        $oD3ShGenerator->setSortedParameterList($aParameters);
        $oD3ShGenerator->startDownload('d3ordermanager_'.$oShop->getId()."_".$sCronId.".sh");
    }
}
