<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_requirements_d3ordermanagerrequtrackcodefilterTest extends OxidTestCase
{
    /** @var d3ordermanager_requirement_trackcodefilter */
    protected $_oRequ;
    protected $_sActiveVarName = 'blCheckTrackcode_status';

    /**
     * setup basic requirements
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $this->_oRequ = $this->getProxyClass('d3ordermanager_requirement_trackcodefilter', array($oOrderManager));

        // set valid licence for private "_isAllowed", which isn't mockable
        $this->_setOMValidEditionLicence();
    }

    public function tearDown()
    {
        parent::tearDown();

        unset($this->_oRequ);
    }

    public function testisActive_DontExecuteAction()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array(
                'hasRequiredValues',
            ),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));
        $oRequ->getManager()->setValue($this->_sActiveVarName, 0);
        $this->assertFalse($oRequ->isActive());
    }

    public function testisActive_notAllowed()
    {
        // check for private _isAllowed, because it's not mockable
        $this->_setOMUnvalidEditionLicence();
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array('hasRequiredValues'),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));
        $oRequ->getManager()->setValue($this->_sActiveVarName, 1);
        $this->assertFalse($oRequ->isActive());
    }

    public function testisActive_missingConfig()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array(
                'hasRequiredValues',
            ),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(false));
        $oRequ->getManager()->setValue($this->_sActiveVarName, 1);
        $this->assertFalse($oRequ->isActive());
    }

    public function testisActive_ok()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array(
                'hasRequiredValues',
            ),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));
        $oRequ->getManager()->setValue($this->_sActiveVarName, 1);
        $this->assertTrue($oRequ->isActive());
    }

    public function testHasRequiredValues_missing()
    {
        // there are no required values
    }

    public function testHasRequiredValues_ok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues')));
        $this->_oRequ->setManager($oManagerMock);
        $this->assertTrue($this->_oRequ->hasRequiredValues());
    }

    public function testIsAllowed_nok()
    {
        $this->_setOMUnvalidEditionLicence();
        $this->assertFalse($this->_oRequ->isAllowed());
    }

    public function testIsAllowed_ok()
    {
        $this->assertTrue($this->_oRequ->isAllowed());
    }

    public function testGetWhereSql_notactive()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array(
                'isActive',
            ),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('isActive')->will($this->returnValue(false));
        $this->assertEquals('', $oRequ->getWhereSql());
    }

    public function testGetWhereSql_activeorderdate()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues')));
        $this->_oRequ->setManager($oManagerMock);

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirement_trackcodefilter $oRequ */
        $oRequ = $this->getMock(
            'd3ordermanager_requirement_trackcodefilter',
            array(
                'isActive',
            ),
            array($this->_oRequ->getManager())
        );
        $oRequ->expects($this->any())->method('isActive')->will($this->returnValue(true));
        $this->assertEquals(" AND oxorder.oxtrackcode != '' ", $oRequ->getWhereSql());
    }

    /**
     * @return null
     */
    public function getManagerValues()
    {
        return null;
    }

    protected function _setOMValidEditionLicence()
    {
        $this->_oRequ->getManager()->d3getModCfg()->assign(
            array(
                'oxserial'  => '635WUdaNThGNlNEYVZJY0dsVUJZVHpDc2tWQm5UejVXdTZ4eU5OS1lXTjhXUzFoQTQ1SW1YdUlacG13K
1dhOFNoclZBTUFwTzdyNml4NWN3dFc0VG1SK0NkNEg0RERNWU43dllreXRLOTVnVmVxaE1xS3ZpcDZSS
nh4a0RnS1RsZXlHeUR4QmFzQmxMa1B3MmcrQmdBQW1tUXVmYko4QkNxWFFHd295OUliQVg5WXZvWk8wT
Wh5OHRJS3RlekJBWmppMmk3YkhtakdhRFVqV3NQMmUxTExLSk1VQ0VCMnM4dVcwRGpqS3ppWnhPTDRVY
k5tQkJGMndLVmhjblcxUm1VWTM1SlZkcEdsTnkxcGI0ZnZOZVlCV08yK3RQbGxpVWMwbEYxdy9TaXBId
FlsY1ZkVVFMUFZkR1VVZnI0UmZzdDg5MEpDTG41SE5SZjYyYkVmMjRlVVVFcGRSNVdHdVNjUHdYc0VPN
EdIajkrdEFBZjRnSlBlaTNvT2s1NUQ1cUtrSFhTOW1HSkpOSUlqUENBaDNXamtvSm45RWt0VmZreklJe
nphZzNXRERtd3RSOG5LTUJzZkdCZzRKMWUxUmJRMHp2U0ViOWdNbG91YWdyVGI1Z3F1QjE5aXppZXJqU
GcyMWtVcUlvUmdXL0I1VS8xbkNWdU04TlBzSkpSZmJvSmljVDgvRU1BQ1pNQWgwU3p1cHVjKytYZ3NwS
Wd3SEh3M0UxVUYrZVBhb0dVRWh1Y01kVDlocnhpRG1Mb0dPVS9CcU0ybFZSUktGZ1EyNk5PNmVISEduK
2E4Mk1OZTZKYWw2ZkdNRWlacHhWb2pneEtqQ2IrNHFBS2RmR21TNlYwQmczeWNRZWZIVnRBQUlDV2F2U
UdJSUhaTVhzcXAzM3V0VnFwR3pqUktEL3RGWkN5Nm52T2ROekZzQVRBRFdOeEhhZVRwcDlKbyswZkdBU
W0xU2o1WGRBPT0=',
            )
        );
        $sStoreKey = $this->_oRequ->getManager()->d3getModCfg()->d3GetModId() . '#serial';
        d3_cfg_mod_datastore::getInstance()->deleteStore($sStoreKey);
    }

    protected function _setOMUnvalidEditionLicence()
    {
        $this->_oRequ->getManager()->d3getModCfg()->assign(
            array(
                'oxserial'  => 'GvEemVJUlZzWjFCbUNvdnpWYzh6SFU4TzBVVCs5WmNOSGJYOVozVno2TzZpeGVCcFIyNTA3MnYvdEFqN
zVtYnhwRXAxcUlucUZrY2dMMmlxQmVBNzhuUTQ2T0tWVWhZQlVBc0RvajNnczBmM09EeTYxWjBFNFdQN
XlJVXh4ZEt5MjhTblU1dkVkT25QZGppbzRaTkl2SG4vdDV6NlRKVzNqcTZjbEhxcC96WVZFSkVaalhnQ
2MwcnVZQjEzUW8zaktLRFBJSVcvM1NxYlBXWXpXWXVMaEU2K3NRRXVHZ0ZwSmxEUjlHWG56bm1QcHM3R
DBlaVdXVDJpdWJISmJ2YU1LVmFKYTQ5aVRlOEZnUjF3SzJrbHVJaEgzWUR5TDRETmRJTEljZHRlaThHd
1RPVHdIMndTbVFWU3pNUHZFMEQwQjFjUlBZLzlsUmRlL3ViNUVNV2Mrc04wZk1XT2lBTzl0a1RSLyswZ
zRDYVVhSU11SGlBazNRT25Kamc0UzR5UVo3V1h6akJMbytYR25waHU3Vi9rK252aWg2ME9iRzFtQ2F0V
ngxNjlTekF6QzEwZDZVWDY4dFM0eXNXb3VoOHcyNUxkRTg3Q29ld1pIbWh4bVJhV1BKWkZ0MEc0NHAwV
GZRUnI5SjVlZnVzS3lxUHd2Zis0dUtRY09TK1B3QnVaZmxnQTVwRW1ub3FWSWwyR3dhMUM0VXZzMS9jb
Eh6YW4xcktia3QxN1BZamNLTWVkbEJpQXVHbWFQWDh1c2xZQ0Zzd0w5UHRvZnBEaE0zaDZ5YmpjY2srZ
m1VVi92YVBaZTUwNFlYQzBvUmtHdVlVZ0VXUERBVmo0NDUvc0xVV3Vobm1KenF1UWp5Q2tZOTN4Yzd1e
GU0bzc4RlJ0VjRnZVRpWDlmQ2hqb1pmWVpZTWtQTExPRjZMNFpYUWluTDk4Tm5JdmRTenMrSWQ1SzFiN
HZCYWpiRTZyR3U3Q29SNmVHWkgwUzQ2VktsSUVVPQ==',
            )
        );
        $sStoreKey = $this->_oRequ->getManager()->d3getModCfg()->d3GetModId() . '#serial';
        d3_cfg_mod_datastore::getInstance()->deleteStore($sStoreKey);
    }
}
