<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_requirements_d3ordermanagerrequirementlistTest extends OxidTestCase
{
    /** @var d3ordermanager_requirementlist */
    protected $_oRequList;

    /**
     * setup basic requirements
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $this->_oRequList = $this->getProxyClass('d3ordermanager_requirementlist', array($oOrderManager));
    }
    
    public function tearDown()
    {
        parent::tearDown();
        
        unset($this->_oRequList);
    }

    public function testsetRequirements()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->assertEquals(1, count($this->_oRequList->getRequirementList()));
    }

    public function testAddRequirement()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->_oRequList->addRequirement(
            'd3ordermanager_requirement_orderfield',
            'd3ordermanager_requirement_orderfield'
        );

        $this->assertEquals(2, count($this->_oRequList->getRequirementList()));
    }

    public function testHasRequirement()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->assertTrue($this->_oRequList->hasRequirement('d3ordermanager_requirement_countryfilter'));
        $this->assertFalse($this->_oRequList->hasRequirement('d3ordermanager_requirement_otherfilter'));
    }

    public function testRemoveRequirement()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->_oRequList->addRequirement(
            'd3ordermanager_requirement_orderfield',
            'd3ordermanager_requirement_orderfield'
        );

        $this->_oRequList->removeRequirement('d3ordermanager_requirement_countryfilter');

        $this->assertEquals(1, count($this->_oRequList->getRequirementList()));
    }

    public function testClearRequirements()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->_oRequList->addRequirement(
            'd3ordermanager_requirement_orderfield',
            'd3ordermanager_requirement_orderfield'
        );

        $this->_oRequList->clearRequirements();

        $this->assertEquals(0, count($this->_oRequList->getRequirementList()));
    }

    public function testGetRequirementIdList()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $this->_oRequList->addRequirement(
            'd3ordermanager_requirement_orderfield',
            'd3ordermanager_requirement_orderfield'
        );

        $aIdList = $this->_oRequList->getRequirementIdList();

        $this->assertTrue(
            is_array($aIdList) && count($aIdList) == 2 && in_array('d3ordermanager_requirement_countryfilter', $aIdList)
        );
    }

    public function testgetRequirement()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $oRequirement = $this->_oRequList->getRequirement('d3ordermanager_requirement_countryfilter');
        $this->assertTrue(is_object($oRequirement) && $oRequirement instanceof d3ordermanager_requirement_countryfilter);
    }

    public function testgetRequirement_unknown()
    {
        $this->_oRequList->setRequirements(
            array('d3ordermanager_requirement_countryfilter' => 'd3ordermanager_requirement_countryfilter')
        );

        $oRequirement = $this->_oRequList->getRequirement('d3ordermanager_requirement_otherfilter');
        $this->assertNull($oRequirement);
    }

    public function testgetJoinSql()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequMock */
        $oRequMock = $this->getMock(
            'd3ordermanager_requirement_countryfilter',
            array(
                'getJoinSql',
            ),
            array($this->_oRequList->getManager())
        );
        $oRequMock->expects($this->any())->method('getJoinSql')->will($this->returnValue(" LEFT JOIN oxarticles "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequMock2 */
        $oRequMock2 = $this->getMock(
            'd3ordermanager_requirement_fromordernr',
            array(
                'getJoinSql',
            ),
            array($this->_oRequList->getManager())
        );
        $oRequMock2->expects($this->any())->method('getJoinSql')->will($this->returnValue(" LEFT JOIN oxorder "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequListMock */
        $oRequListMock = $this->getMock('d3ordermanager_requirementlist', array('getRequirementList'), array($this->_oRequList->getManager()));
        $oRequListMock->expects($this->any())->method('getRequirementList')->will($this->returnValue(
            array(
                'd3ordermanager_requirement_countryfilter' => $oRequMock,
                'd3ordermanager_requirement_fromordernr' => $oRequMock2,
            )
        ));

        $this->assertEquals(' LEFT JOIN oxarticles  LEFT JOIN oxorder ', $oRequListMock->getJoinSql());
    }

    public function testgetWhereSql()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequMock */
        $oRequMock = $this->getMock(
            'd3ordermanager_requirement_countryfilter',
            array(
                'getWhereSql',
            ),
            array($this->_oRequList->getManager())
        );
        $oRequMock->expects($this->any())->method('getWhereSql')->will($this->returnValue(" 1 AND 1 "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequListMock */
        $oRequListMock = $this->getMock('d3ordermanager_requirementlist', array('getRequirementList'), array($this->_oRequList->getManager()));
        $oRequListMock->expects($this->any())->method('getRequirementList')->will($this->returnValue(array('d3ordermanager_requirement_countryfilter' => $oRequMock)));

        $this->assertEquals(' 1 AND 1 ', $oRequListMock->getWhereSql());
    }

    public function testgetHavingSql()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequMock */
        $oRequMock = $this->getMock(
            'd3ordermanager_requirement_countryfilter',
            array(
                'getHavingSql',
            ),
            array($this->_oRequList->getManager())
        );
        $oRequMock->expects($this->any())->method('getHavingSql')->will($this->returnValue(" 1 AND 1 "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequListMock */
        $oRequListMock = $this->getMock('d3ordermanager_requirementlist', array('getRequirementList'), array($this->_oRequList->getManager()));
        $oRequListMock->expects($this->any())->method('getRequirementList')->will($this->returnValue(array('d3ordermanager_requirement_countryfilter' => $oRequMock)));

        $this->assertEquals(' 1 AND 1 ', $oRequListMock->getHavingSql());
    }

    public function testchangeOrderList()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequMock */
        $oRequMock = $this->getMock(
            'd3ordermanager_requirement_countryfilter',
            array(
                'changeOrderList',
            ),
            array($this->_oRequList->getManager())
        );
        $oRequMock->expects($this->any())->method('changeOrderList')->will($this->returnCallback(array($this, "changeOrderListCallback")));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oRequListMock */
        $oRequListMock = $this->getMock('d3ordermanager_requirementlist', array('getRequirementList'), array($this->_oRequList->getManager()));
        $oRequListMock->expects($this->any())->method('getRequirementList')->will($this->returnValue(array('d3ordermanager_requirement_countryfilter' => $oRequMock)));

        /** @var oxlist $oList */
        $oList = oxNew('oxlist');
        $oList->offsetSet('123', oxNew('oxBase'));
        $oList->offsetSet('456', oxNew('oxBase'));
        $oReturnList = $oRequListMock->changeOrderList($oList);
        $this->assertTrue(is_object($oReturnList) && $oReturnList instanceof oxList && $oReturnList->count() == 1);
    }

    /**
     * @return mixed
     */
    public function changeOrderListCallback()
    {
        $aArgs = func_get_args();

        /** @var oxList $oList */
        $oList = $aArgs[0];
        $oList->offsetUnset('123');

        return $oList;
    }
}
