<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_actions_d3ordermanageractionlistTest extends OxidTestCase
{
    /** @var d3ordermanager_actionlist */
    protected $_oActionList;
    /** @var PHPUnit_Framework_MockObject_Matcher_AnyInvokedCount */
    protected $_oSpy;

    /**
     * setup basic actions
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $oOrder = oxNew('oxorder');
        $this->_oActionList = $this->getProxyClass('d3ordermanager_actionlist', array($oOrderManager, $oOrder));
    }
    
    public function tearDown()
    {
        parent::tearDown();
        
        unset($this->_oActionList);
    }

    public function testsetActions()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $this->assertEquals(1, count($this->_oActionList->getActionList()));
    }

    public function testAddAction()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $this->_oActionList->addAction(
            'd3ordermanager_action_setpaiddate',
            'd3ordermanager_action_setpaiddate'
        );

        $this->assertEquals(2, count($this->_oActionList->getActionList()));
    }

    public function testHasAction()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $this->assertTrue($this->_oActionList->hasAction('d3ordermanager_action_custdelfromgroup'));
        $this->assertFalse($this->_oActionList->hasAction('d3ordermanager_action_other'));
    }

    public function testRemoveAction()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $this->_oActionList->addAction(
            'd3ordermanager_action_setpaiddate',
            'd3ordermanager_action_setpaiddate'
        );

        $this->_oActionList->removeAction('d3ordermanager_action_custdelfromgroup');

        $this->assertEquals(1, count($this->_oActionList->getActionList()));
    }

    public function testClearActions()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $this->_oActionList->addAction(
            'd3ordermanager_action_setpaiddate',
            'd3ordermanager_action_setpaiddate'
        );

        $this->_oActionList->clearActions();

        $this->assertEquals(0, count($this->_oActionList->getActionList()));
    }

    public function testgetAction()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $oAction = $this->_oActionList->getAction('d3ordermanager_action_custdelfromgroup');
        $this->assertTrue(is_object($oAction) && $oAction instanceof d3ordermanager_action_custdelfromgroup);
    }

    public function testgetAction_unknown()
    {
        $this->_oActionList->setActions(
            array('d3ordermanager_action_custdelfromgroup' => 'd3ordermanager_action_custdelfromgroup')
        );

        $oAction = $this->_oActionList->getAction('d3ordermanager_action_other');
        $this->assertNull($oAction);
    }

    public function teststartAction()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_action_abstract $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_custdelfromgroup',
            array(
                'startAction',
            ),
            array($this->_oActionList->getManager(), $this->_oActionList->getOrder())
        );
        $oActionMock->expects($this->_oSpy = $this->any())->method('startAction');

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_actionlist $oActionListMock */
        $oActionListMock = $this->getMock(
            'd3ordermanager_actionlist',
            array('getActionList'),
            array($this->_oActionList->getManager(), $this->_oActionList->getOrder())
        );
        $oActionListMock->expects($this->any())->method('getActionList')->will(
            $this->returnValue(array('d3ordermanager_action_custdelfromgroup' => $oActionMock))
        );

        $oActionListMock->startAction();
        $this->assertEquals(1, count($this->_oSpy->getInvocations()));
    }
}
