<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_ordermanageritem_requ extends d3_cfg_ordermanageritem_settings
{
    protected $_sThisTemplate = "d3_cfg_ordermanageritem_requ.tpl";
    protected $_aTransStatus = array('OK', 'ERROR', 'NOT_OK');
    protected $_sMenuSubItemTitle = 'd3mxordermanager_items';

    /**
     * @return oxpaymentlist
     */
    public function getPaymentList()
    {
        /** @var oxpaymentlist $oPaymentList */
        $oPaymentList = oxNew('oxpaymentlist');
        return $this->_getObjectList($oPaymentList);
    }

    /**
     * @return oxdeliverysetlist
     */
    public function getDeliveryList()
    {
        /** @var oxdeliverylist $oDeliveryList */
        $oDeliveryList = oxNew('oxdeliverysetlist');
        return $this->_getObjectList($oDeliveryList);
    }

    /**
     * @return oxcountrylist
     */
    public function getCountryList()
    {
        /** @var oxcountrylist $oCountryList */
        $oCountryList = oxNew('oxcountrylist');
        return $this->_getObjectList($oCountryList);
    }

    /**
     * @return array
     */
    public function getJobList()
    {
        $sCurrentId = $this->getViewDataElement('edit')->getId();
        /** @var $oManagerList d3OrdermanagerList */
        $oManagerList = oxNew('d3ordermanagerlist');
        $oManagerList->setCustomSorting('oxsort ASC');
        $oManagerList->getList();
        $oManagerList->offsetUnset($sCurrentId);
        return $oManagerList;
    }

    /**
     * @return array
     */
    public function getLanguageList()
    {
        $aLanguageList = oxRegistry::getLang()->getLanguageArray();
        return $aLanguageList;
    }

    /**
     * @return array
     */
    public function getTransStatusList()
    {
        return $this->_aTransStatus;
    }

    /**
     * Sets default values for empty article (currently does nothing), returns
     * array with parameters.
     *
     * @param array $aParams Parameters, to set default values
     *
     * @return array
     */
    public function addDefaultValues($aParams)
    {
        return $aParams;
    }

    /**
     * @return d3ordermanager_requirementgrouplist
     */
    public function getGroupedRequirementList()
    {
        /** @var d3ordermanager $oManager */
        $oManager = $this->getProfile();
        /** @var d3ordermanager_requirementgrouplist $oRequList */
        $oRequList = oxNew('d3ordermanager_requirementgrouplist', $oManager);
        $oRequList->setGroups($oManager->getConfiguration()->getGroupedRequirementIdList());

        return $oRequList->getGroupList();
    }
}
