<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_actions_d3ordermanageractiongrouplistTest extends OxidTestCase
{
    /** @var d3ordermanager_actiongrouplist */
    protected $_oActionGroupList;

    /**
     * setup basic actions
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $oOrder = oxNew('oxOrder');
        $this->_oActionGroupList = $this->getProxyClass('d3ordermanager_actiongrouplist', array($oOrderManager, $oOrder));
    }
    
    public function tearDown()
    {
        parent::tearDown();
        
        unset($this->_oActionGroupList);
    }

    public function testsetGroups()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $this->assertEquals(1, count($this->_oActionGroupList->getGroupList()));
    }

    public function testhasGroup_true()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $this->assertTrue($this->_oActionGroupList->hasGroup('foo'));
    }

    public function testhasGroup_false()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $this->assertFalse($this->_oActionGroupList->hasGroup('bar'));
    }

    public function testremoveGroup()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));
        $this->_oActionGroupList->removeGroup('foo');
        $this->assertEquals(0, count($this->_oActionGroupList->getGroupList()));
    }

    public function testClearGroups()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));
        $this->_oActionGroupList->clearGroups();
        $this->assertEquals(0, count($this->_oActionGroupList->getGroupList()));
    }

    public function testgetGroupIdList()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $aGroupIdList = $this->_oActionGroupList->getGroupIdList();
        $this->assertTrue(is_array($aGroupIdList) && count($aGroupIdList) == 1 && in_array('foo', $aGroupIdList));
    }

    public function testgetGroup()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $oGroup = $this->_oActionGroupList->getGroup('foo');
        $this->assertTrue(is_object($oGroup) && $oGroup instanceof d3ordermanager_actionlist);
    }

    public function testgetGroup_notexistinggroup()
    {
        $this->_oActionGroupList->setGroups(array('foo' => array('d3ordermanager_action_custdelfromgroup')));

        $oGroup = $this->_oActionGroupList->getGroup('bar');
        $this->assertTrue(is_null($oGroup));
    }
}
