<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_ordermanageritem_action extends d3_cfg_ordermanageritem_settings
{
    protected $_sThisTemplate = "d3_cfg_ordermanageritem_action.tpl";
    protected $_sMenuSubItemTitle = 'd3tbclordermanager_items_action';
    protected $_sSavedId;
    protected $_sExportFieldDescMLIdent = 'D3_ORDERMANAGER_FIELDDESC';
    protected $_sExportFieldTitleBaseMLIdent = 'D3_ORDERMANAGER_FIELDTITLE_';
    protected $_sExportFieldLangMLIdent = 'D3_ORDERMANAGER_FIELDADD_LANG';

    /**
     * @return oxcontentlist
     */
    public function getContentList()
    {
        /** @var $oContentList oxcontentlist */
        $oContentList = oxNew('oxcontentlist');
        return $this->_getObjectList($oContentList);
    }

    /**
     * @param $blAdmin
     * @return string
     */
    public function getManagerTemplateDirs($blAdmin)
    {
        return oxRegistry::getConfig()->getTemplateDir($blAdmin);
    }

    /**
     * @return array
     */
    public function getItemFieldNames()
    {
        /** @var oxorder $oOrder */
        $oOrder = oxNew('oxorder');
        return $oOrder->getFieldNames();
    }


    /**
     * @return string
     */
    public function getExportExamplePath()
    {
        /** @var d3ordermanager $oProfile */
        $oProfile = oxNew($this->_sD3ObjectClass);
        $soxId    = oxRegistry::getConfig()->getRequestParameter("oxid");

        if (isset( $soxId) && $soxId && $soxId != "-1") {
            // load object
            $oProfile->loadInLang($this->_iEditLang, $soxId);
            $oProfile = $this->_d3LoadInOtherLang($oProfile, $soxId);
        }

        $aSearch = array(date('Y-m-d_H-i-s', $oProfile->getStartTime()));
        $aReplace = array(oxRegistry::getLang()->translateString('D3_ORDERMANAGER_ACTION_DATEPLACEHOLDER'));

        return str_replace($aSearch, $aReplace, $oProfile->getListExportFilePath());
    }

    /**
     * @param $sFieldName
     *
     * @return string
     */
    public function getFieldNameDescription($sFieldName)
    {
        if (($sFieldNameTitle = $this->getFieldNameTitle($sFieldName))) {
            return sprintf(
                oxRegistry::getLang()->translateString($this->_sExportFieldDescMLIdent),
                $sFieldNameTitle,
                $sFieldName
            );
        } else {
            return $sFieldName;
        }
    }

    /**
     * @param $sFieldName
     *
     * @return null|string
     */
    public function getFieldNameTitle($sFieldName)
    {
        $sLangAdd = '';
        $sPattern = "@(.*)([_]{1}([0-9]{1,3}))$@";
        if (preg_match($sPattern, $sFieldName, $aMatches)) {
            $sFieldMLIdent = $this->_sExportFieldTitleBaseMLIdent.strtoupper($aMatches[1]);
            $aLangNames = oxRegistry::getLang()->getLanguageNames();
            $sLangAdd  = sprintf(
                oxRegistry::getLang()->translateString($this->_sExportFieldLangMLIdent),
                $aLangNames[$aMatches[3]]
            );
        } else {
            $sFieldMLIdent = $this->_sExportFieldTitleBaseMLIdent.strtoupper($sFieldName);
        }

        $sFieldName = oxRegistry::getLang()->translateString($sFieldMLIdent);

        if ($sFieldName != $sFieldMLIdent) {
            return $sFieldName.$sLangAdd;
        } else {
            return null;
        }
    }

    /**
     * @return bool
     */
    public function canGeneratePdf()
    {
        /** @var d3ordermanager $oProfile */
        $oProfile = $this->getProfile();

        /** @var oxorder $oOrder */
        $oOrder = oxNew('oxorder');

        /** @var d3ordermanager_pdfhandler $oPDFHandler */
        $oPDFHandler = oxNew('d3ordermanager_pdfhandler', $oProfile, $oOrder);
        return $oPDFHandler->canGeneratePdf();
    }

    /**
     * @return d3ordermanager_actiongrouplist
     */
    public function getGroupedActionList()
    {
        /** @var d3ordermanager $oManager */
        $oManager = $this->getProfile();
        $oItem = oxNew('oxorder');

        /** @var d3ordermanager_actiongrouplist $oActionList */
        $oActionList = oxNew('d3ordermanager_actiongrouplist', $oManager, $oItem);
        $oActionList->setGroups($oManager->getConfiguration()->getGroupedActionIdList());

        return $oActionList->getGroupList();
    }

    /**
     * @param d3ordermanager $oProfile
     * @param               $soxId
     *
     * @return d3ordermanager
     */
    protected function _d3LoadInOtherLang(d3ordermanager $oProfile, $soxId)
    {
        // load object in other languages
        $oOtherLang = $oProfile->getAvailableInLangs();
        if (false == isset($oOtherLang[$this->_iEditLang])) {
            $oProfile->loadInLang(key($oOtherLang), $soxId);
        }

        return $oProfile;
    }

    /**
     * @return array
     */
    public function getModulePathList()
    {
        $sModulesDir = oxRegistry::getConfig()->getModulesDir();
        $aModulePathList = array();

        /** @var oxmodule $oModule */
        $oModule = oxNew('oxmodule');
        /** @var oxmodulelist $oModuleList */
        $oModuleList = oxNew("oxModuleList");
        foreach (array_keys($oModuleList->getModulesFromDir($sModulesDir)) as $sId) {
            /** @var d3ShopCompatibilityAdapterHandler $oD3CompatibilityAdapterHandler */
            $oD3CompatibilityAdapterHandler = oxNew('d3ShopCompatibilityAdapterHandler');
            $sModulePath = $oD3CompatibilityAdapterHandler->call(
                'oxmodule__getModuleFullPath',
                array($oModule, $sId)
            );

            $aModulePathList[$sId] = $sModulePath;
        };

        return $aModulePathList;
    }

    public function markAsFinished()
    {
        /** @var d3ordermanager $oProfile */
        $oProfile = $this->getProfile();
        $iCount = $oProfile->markConcernedItemsAsFinished();
        $this->_aMessages[] = sprintf(
            oxRegistry::getLang()->translateString('D3_ORDERMANAGER_ACTION_MARKASFINISHED_MESSAGE'),
            $iCount
        );
    }
}
