<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_actions_d3ordermanageractionchangedelcostsTest extends OxidTestCase
{
    /** @var d3ordermanager_action_changedelcosts */
    protected $_oAction;
    protected $_dCosts = 123.45;
    protected $_dExpected = 67.89;

    /**
     * setup basic requirements
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $oOrder = oxNew('oxorder');
        $aAssign = array(
            'oxcurrate'    => 1,
            'oxdelcost'    => $this->_dCosts,
        );
        $oOrder->assign($aAssign);

        $this->_oAction = $this->getProxyClass('d3ordermanager_action_changedelcosts', array($oOrderManager, $oOrder));

        // set valid licence for private "_isAllowed", which isn't mockable
        $this->_setOMValidEditionLicence();
    }

    public function tearDown()
    {
        parent::tearDown();

        unset($this->_oAction);
    }

    public function testStartAction_DontExecuteAction()
    {
        $this->_oAction->getManager()->setValue('sActionChangeDelCostValue', $this->_dExpected);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('canExecuteAction', 'canExecuteMethod', 'hasRequiredValues'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('canExecuteAction')->will($this->returnValue(false));
        $oActionMock->expects($this->any())->method('canExecuteMethod')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));

        $oActionMock->startAction();
        $this->assertEquals(
            $this->_dCosts,
            $this->_oAction->getOrder()->getFieldData('oxdelcost')
        );
    }

    public function testStartAction_DontExecuteJob()
    {
        $this->_oAction->getManager()->setValue('sActionChangeDelCostValue', $this->_dExpected);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('canExecuteAction', 'canExecuteMethod', 'hasRequiredValues'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('canExecuteAction')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('canExecuteMethod')->will($this->returnValue(false));
        $oActionMock->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));

        $oActionMock->startAction();
        $this->assertEquals(
            $this->_dCosts,
            $this->_oAction->getOrder()->getFieldData('oxdelcost')
        );
    }

    public function testStartAction_MissingValues()
    {
        $this->_oAction->getManager()->setValue('sActionChangeDelCostValue', $this->_dExpected);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('canExecuteAction', 'canExecuteMethod', 'hasRequiredValues'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('canExecuteAction')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('canExecuteMethod')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(false));

        $oActionMock->startAction();
        $this->assertEquals(
            $this->_dCosts,
            $this->_oAction->getOrder()->getFieldData('oxdelcost')
        );
    }

    public function testStartAction_Ok()
    {
        $this->_oAction->getManager()->setValue('sActionChangeDelCostValue', $this->_dExpected);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('canExecuteAction', 'canExecuteMethod', 'hasRequiredValues'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('canExecuteAction')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('canExecuteMethod')->will($this->returnValue(true));
        $oActionMock->expects($this->any())->method('hasRequiredValues')->will($this->returnValue(true));

        $oActionMock->startAction();
        $this->assertEquals(
            $this->_dExpected,
            $this->_oAction->getOrder()->getFieldData('oxdelcost')
        );
    }

    public function testCanExecuteAction_disabledAction()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues')));
        $this->_oAction->setManager($oManagerMock);

        $this->assertFalse($this->_oAction->canExecuteAction());
        $this->assertFalse($this->_oAction->isActive());
    }

    /**
     * @return bool|null
     */
    public function getManagerValues()
    {
        $aArgs = func_get_args();

        switch ($aArgs[0]) {
            case 'blActionOrderChangeDeliveryCost_status':
                return false;
            case 'sActionChangeDelCostValue':
                return null;
        }

        $this->fail('Unknown variable '.$aArgs[0]);
        return null;
    }

    public function testCanExecuteAction_unvalidLicence()
    {
        // private method _isAllowed isn't mockable
        $this->_setOMUnvalidEditionLicence();
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues1')));
        $this->_oAction->setManager($oManagerMock);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('isCommonExecutable'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('isCommonExecutable')->will($this->returnValue(true));

        $this->assertFalse($oActionMock->canExecuteAction());
        $this->assertFalse($oActionMock->isActive());
    }

    /**
     * @return bool|null
     */
    public function getManagerValues1()
    {
        $aArgs = func_get_args();

        switch ($aArgs[0]) {
            case 'blActionOrderChangeDeliveryCost_status':
                return true;
            case 'sActionChangeDelCostValue':
                return $this->_dExpected;
        }

        $this->fail('Unknown variable '.$aArgs[0]);
        return null;
    }

    public function testCanExecuteAction_managernotexecutable()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues1')));
        $this->_oAction->setManager($oManagerMock);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('isCommonExecutable'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('isCommonExecutable')->will($this->returnValue(false));

        $this->assertFalse($oActionMock->canExecuteAction());
        $this->assertFalse($oActionMock->isActive());
    }

    public function testCanExecuteAction_ok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues1')));
        $this->_oAction->setManager($oManagerMock);

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('isCommonExecutable'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('isCommonExecutable')->will($this->returnValue(true));

        $this->assertTrue($oActionMock->canExecuteAction());
        $this->assertTrue($oActionMock->isActive());
    }

    public function testCanExecuteMethod_nok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnValue(false));
        $this->_oAction->setManager($oManagerMock);

        $this->assertFalse($this->_oAction->canExecuteMethod());
    }

    public function testCanExecuteMethod_ok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnValue(true));
        $this->_oAction->setManager($oManagerMock);

        $this->assertTrue($this->_oAction->canExecuteMethod());
    }

    public function testHasRequiredValues_nok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues')));
        $this->_oAction->setManager($oManagerMock);

        $this->assertFalse($this->_oAction->hasRequiredValues());
    }

    public function testHasRequiredValues_ok()
    {
        $oManagerMock = $this->getMock('d3ordermanager', array('getValue'));
        $oManagerMock->expects($this->any())->method('getValue')->will($this->returnCallback(array($this, 'getManagerValues1')));
        $this->_oAction->setManager($oManagerMock);

        $this->assertTrue($this->_oAction->hasRequiredValues());
    }

    public function testGetTplName()
    {
        $this->assertEquals('d3ordermanager_action_changedelcosts.tpl', $this->_oAction->getTplName());
    }

    public function testIsAllowed()
    {
        $blRet = $this->_oAction->isAllowed();
        $this->assertTrue($blRet);

        $this->_setOMUnvalidEditionLicence();
        $blRet = $this->_oAction->isAllowed();
        $this->assertFalse($blRet);
    }

    public function testIsCommonExecutable_newLicenceOk()
    {
        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('isOrdermanagerExecutable'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('isOrdermanagerExecutable')->will($this->returnValue(true));

        $this->assertTrue($oActionMock->isCommonExecutable(false));
    }

    public function testIsCommonExecutable_oldLicenceNOk()
    {
        $this->_setOMOldLicence();

        /** @var d3ordermanager_action_changedelcosts|PHPUnit_Framework_MockObject_MockObject $oActionMock */
        $oActionMock = $this->getMock(
            'd3ordermanager_action_changedelcosts',
            array('isOrdermanagerExecutable'),
            array($this->_oAction->getManager(), $this->_oAction->getOrder())
        );
        $oActionMock->expects($this->any())->method('isOrdermanagerExecutable')->will($this->returnValue(true));

        $this->assertFalse($oActionMock->isCommonExecutable(true));
    }

    public function testIsOrdermanagerExecutable_Ok()
    {
        $this->assertTrue($this->_oAction->isOrdermanagerExecutable());
    }

    public function testIsOrdermanagerExecutable_NOK_Order()
    {
        $this->_oAction->setOrder(false);
        $this->assertFalse($this->_oAction->isOrdermanagerExecutable());
    }

    protected function _setOMValidEditionLicence()
    {
        $this->_oAction->getManager()->d3getModCfg()->assign(
            array(
                'oxserial'  => '635WUdaNThGNlNEYVZJY0dsVUJZVHpDc2tWQm5UejVXdTZ4eU5OS1lXTjhXUzFoQTQ1SW1YdUlacG13K
1dhOFNoclZBTUFwTzdyNml4NWN3dFc0VG1SK0NkNEg0RERNWU43dllreXRLOTVnVmVxaE1xS3ZpcDZSS
nh4a0RnS1RsZXlHeUR4QmFzQmxMa1B3MmcrQmdBQW1tUXVmYko4QkNxWFFHd295OUliQVg5WXZvWk8wT
Wh5OHRJS3RlekJBWmppMmk3YkhtakdhRFVqV3NQMmUxTExLSk1VQ0VCMnM4dVcwRGpqS3ppWnhPTDRVY
k5tQkJGMndLVmhjblcxUm1VWTM1SlZkcEdsTnkxcGI0ZnZOZVlCV08yK3RQbGxpVWMwbEYxdy9TaXBId
FlsY1ZkVVFMUFZkR1VVZnI0UmZzdDg5MEpDTG41SE5SZjYyYkVmMjRlVVVFcGRSNVdHdVNjUHdYc0VPN
EdIajkrdEFBZjRnSlBlaTNvT2s1NUQ1cUtrSFhTOW1HSkpOSUlqUENBaDNXamtvSm45RWt0VmZreklJe
nphZzNXRERtd3RSOG5LTUJzZkdCZzRKMWUxUmJRMHp2U0ViOWdNbG91YWdyVGI1Z3F1QjE5aXppZXJqU
GcyMWtVcUlvUmdXL0I1VS8xbkNWdU04TlBzSkpSZmJvSmljVDgvRU1BQ1pNQWgwU3p1cHVjKytYZ3NwS
Wd3SEh3M0UxVUYrZVBhb0dVRWh1Y01kVDlocnhpRG1Mb0dPVS9CcU0ybFZSUktGZ1EyNk5PNmVISEduK
2E4Mk1OZTZKYWw2ZkdNRWlacHhWb2pneEtqQ2IrNHFBS2RmR21TNlYwQmczeWNRZWZIVnRBQUlDV2F2U
UdJSUhaTVhzcXAzM3V0VnFwR3pqUktEL3RGWkN5Nm52T2ROekZzQVRBRFdOeEhhZVRwcDlKbyswZkdBU
W0xU2o1WGRBPT0=',
            )
        );
        $sStoreKey = $this->_oAction->getManager()->d3getModCfg()->d3GetModId() . '#serial';
        d3_cfg_mod_datastore::getInstance()->deleteStore($sStoreKey);
    }

    protected function _setOMUnvalidEditionLicence()
    {
        $this->_oAction->getManager()->d3getModCfg()->assign(
            array(
                'oxserial'  => 'GvEemVJUlZzWjFCbUNvdnpWYzh6SFU4TzBVVCs5WmNOSGJYOVozVno2TzZpeGVCcFIyNTA3MnYvdEFqN
zVtYnhwRXAxcUlucUZrY2dMMmlxQmVBNzhuUTQ2T0tWVWhZQlVBc0RvajNnczBmM09EeTYxWjBFNFdQN
XlJVXh4ZEt5MjhTblU1dkVkT25QZGppbzRaTkl2SG4vdDV6NlRKVzNqcTZjbEhxcC96WVZFSkVaalhnQ
2MwcnVZQjEzUW8zaktLRFBJSVcvM1NxYlBXWXpXWXVMaEU2K3NRRXVHZ0ZwSmxEUjlHWG56bm1QcHM3R
DBlaVdXVDJpdWJISmJ2YU1LVmFKYTQ5aVRlOEZnUjF3SzJrbHVJaEgzWUR5TDRETmRJTEljZHRlaThHd
1RPVHdIMndTbVFWU3pNUHZFMEQwQjFjUlBZLzlsUmRlL3ViNUVNV2Mrc04wZk1XT2lBTzl0a1RSLyswZ
zRDYVVhSU11SGlBazNRT25Kamc0UzR5UVo3V1h6akJMbytYR25waHU3Vi9rK252aWg2ME9iRzFtQ2F0V
ngxNjlTekF6QzEwZDZVWDY4dFM0eXNXb3VoOHcyNUxkRTg3Q29ld1pIbWh4bVJhV1BKWkZ0MEc0NHAwV
GZRUnI5SjVlZnVzS3lxUHd2Zis0dUtRY09TK1B3QnVaZmxnQTVwRW1ub3FWSWwyR3dhMUM0VXZzMS9jb
Eh6YW4xcktia3QxN1BZamNLTWVkbEJpQXVHbWFQWDh1c2xZQ0Zzd0w5UHRvZnBEaE0zaDZ5YmpjY2srZ
m1VVi92YVBaZTUwNFlYQzBvUmtHdVlVZ0VXUERBVmo0NDUvc0xVV3Vobm1KenF1UWp5Q2tZOTN4Yzd1e
GU0bzc4RlJ0VjRnZVRpWDlmQ2hqb1pmWVpZTWtQTExPRjZMNFpYUWluTDk4Tm5JdmRTenMrSWQ1SzFiN
HZCYWpiRTZyR3U3Q29SNmVHWkgwUzQ2VktsSUVVPQ==',
            )
        );
        $sStoreKey = $this->_oAction->getManager()->d3getModCfg()->d3GetModId() . '#serial';
        d3_cfg_mod_datastore::getInstance()->deleteStore($sStoreKey);
    }

    protected function _setOMOldLicence()
    {
        $this->_oAction->getManager()->d3getModCfg()->assign(
            array(
                'oxserial'  => 'fUBVUxoTDUrMDE1TFZBb2JrWU5MU2RCYnhtUDYybWEzSWQxTjhkRndXVjdoY01vd1oyTHNud3oxa2U2T
HMwSGxORG5haklOcGd4MVFSTWFYMnNkWW1ZSHRySHJ2ZWcvZEtQWGtwVW1UaCs0cnIxRytOM0ZCUDUxa
1VRdHpaVXo5Y0liU0pJZjRyMXUrVWpFbWVNQmZRc2JYNUdGT09yWnplTGpBc3VSOG1NakcvbDNpT041W
lNVRGJham50Qnl0M2kyNm9vS3JmRjlUZnYrYkg4di90QlM4M1ZrQ2xPSXBLUXYxd2tUd1EyQU1lS0tPZ
kZ4WkNGVVRjdEcvV3J6MnFNWXoyRENyYmtYRGl2elpxbGFEQUVOeHd6Y0d1MW9DamM4NEttWk56Tm5UW
HlYaEg5NmQwTVduU1kyZE91czNNL1BrRHZEd0g3K0Q3NVBsM1d5NU1lS2hoZk1teThody9MYUlBTkFGU
FRWRHJra1M5T1VuMlFkazYwK0ZTSjB0S3JwWjJ3VEQwcGVFK244bHErc3VDTkc1cXRxdWVQT29sSVdFe
mJ6WGUwd3F6UVRTcCtLZ2M2L3ZzdVplNEVvVHM3WlVSbFpnbERWUXRWdy9uRE9MOHkrVTQ0SUNmVnFFY
VBWWTkyZDVxa2ZrQmY2bmxSMEtVRFVsdzJkVmMxNU5uWkk2UWlRREN1ME91MXRsZHBBbXVMK2JUSXA3Y
Uh2d2lIVU42R0tBTXExaUZQdGlOZjhKTkkrbW5rVGhvcStYQlFIK0NUVnAzOGZ6eHVnQmxWSldrbS8wV
lZ5Q3hveXdPY1pPMXhPU1NaWi8vZ1hkbklHYzA0WUVyR09RQ2ZrYzdZUjZCck8xQkhtcHpTYTJjMThte
DMrK0kwR3pMenVqZnU5MG1NVTF2L2dDTzlmSktyWWNybjJZSWRCSDBGS3hvdnYxdFVsZ0FiMEFCT1FPS
0wzeG13cFA1TWs5UWVwZnF3Q2FhU0JtTklaYjFjNFlZOU9MVUVFMlFiNlYwZTc1dHlYOWIzMTBhUzFOa
EdybFg3T0ZSTHFKdXRvb1QyZWdqdmtaTzRHcENtNDVoVT0=',
            )
        );
        $sStoreKey = $this->_oAction->getManager()->d3getModCfg()->d3GetModId() . '#serial';
        d3_cfg_mod_datastore::getInstance()->deleteStore($sStoreKey);
    }
}
