<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_ordermanager_jobs extends oxAdminDetails
{
    /** @var d3ordermanagerlist */
    protected $_aJobList;
    protected $_sHelpLinkMLAdd;

    /**
     * @return string
     */
    public function render()
    {
        parent::render();

        $soxId = $this->getEditObjectId();
        $this->addTplParam("oxid", $soxId);

        if ($soxId != "-1" && isset($soxId)) {
            // load object
            $oItem = oxNew("oxorder");
            $oItem->load($soxId);
            $this->addTplParam("edit", $oItem);
        }

        $sJobFolder = oxRegistry::getSession()->getVariable('d3OrderManagerFolderSelect');
        $this->addTplParam("jobfolder", $sJobFolder);
        $this->_aJobList = $this->_d3GetManuallyManagerJobs($sJobFolder);

        return "d3_ordermanager_jobs.tpl";
    }

    public function changeFolder()
    {
        oxRegistry::getSession()->setVariable(
            'd3OrderManagerFolderSelect',
            oxRegistry::getConfig()->getRequestParameter('jobfolder')
        );
    }

    /**
     * @return d3ordermanagerlist
     */
    public function d3GetManagerJobs()
    {
        /** @var d3ordermanagerlist $oManagerList */
        $oManagerList = oxNew('d3ordermanagerlist');
        $oManagerList->getList();

        return $oManagerList;
    }

    /**
     * @param $sFolderId
     * @return d3ordermanagerlist
     */
    protected function _d3GetManuallyManagerJobs($sFolderId)
    {
        /** @var $oManagerList d3ordermanagerlist */
        $oManagerList = oxNew('d3ordermanagerlist');
        return $oManagerList->d3GetManuallyManagerJobsByFolder($sFolderId);
    }

    /**
     * @return array
     */
    public function d3GetJobList()
    {
        return $this->_aJobList->getArray();
    }

    public function d3execordermanager()
    {
        /** @var d3ordermanager $oManager */
        $oManager = oxNew('d3ordermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('ordermanagerid'));
        /** @var d3ordermanager_execute $oManagerExec */
        $oManagerExec = oxNew('d3ordermanager_execute', $oManager);
        $oManagerExec->exec4order(oxRegistry::getConfig()->getRequestParameter('oxid'));
        $oManagerExec->finishJobExecution();
    }

    public function d3ExecChangedOrderManager()
    {
        /** @var d3ordermanager $oManager */
        $oManager = oxNew('d3ordermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('ordermanagerid'));
        $oManager->setEditedValues(oxRegistry::getConfig()->getRequestParameter('aContent'));
        /** @var d3ordermanager_execute $oManagerExec */
        $oManagerExec = oxNew('d3ordermanager_execute', $oManager);
        $oManagerExec->exec4order(oxRegistry::getConfig()->getRequestParameter('oxid'));
        $oManagerExec->finishJobExecution();
    }

    public function d3resetOrderManagerAssignment()
    {
        /** @var d3ordermanager $oManager */
        $oManager = oxNew('d3ordermanager');
        /** @var d3ordermanager_toOrderAssignment $oAssignment */
        $oAssignment = oxNew('d3ordermanager_toorderassignment', $oManager);
        $oAssignment->resetAssignment(
            oxRegistry::getConfig()->getRequestParameter('ordermanagerid'),
            oxRegistry::getConfig()->getRequestParameter('oxid')
        );
    }

    /**
     * @return mixed
     */
    public function getFolderList()
    {
        /** @var d3ordermanager $oManager */
        $oManager = oxNew('d3ordermanager');
        return $oManager->d3getSelectableFolderList();
    }

    public function execChangedContents()
    {
        $sItemId = oxRegistry::getConfig()->getRequestParameter('oxid');
        /** @var $oManager d3ordermanager */
        $oManager = oxNew('d3ordermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('ordermanagerid'));
        $this->addTplParam('aMailContent', $oManager->getEditableContent($sItemId));
        $this->addTplParam('sAction', __FUNCTION__);
        $this->addTplParam('oOrderManager', $oManager);
    }

    /**
     * @return array
     */
    public function getUserMessages()
    {
        return array();
    }

    /**
     * @deprecated
     * @return string
     */
    public function getBGLogoUrl()
    {
        return '';
    }

    /**
     * @deprecated
     */
    public function background_logo()
    {
        d3_cfg_mod::background_logo();
    }

    /**
     * @return string
     */
    public function getHelpURL()
    {
        $sUrl = $this->d3GetSet()->getHelpURL();
        /** @var $oFS d3filesystem */
        $oFS = oxNew('d3filesystem');

        if ($this->_sHelpLinkMLAdd) {
            $sUrl .= $oFS->unprefixedslashit(oxRegistry::getLang()->TranslateString($this->_sHelpLinkMLAdd));
        }

        $aFileName = $oFS->splitFilename($sUrl);

        // has no extension
        if (false == $aFileName['ext']) {
            $sUrl = $oFS->trailingslashit($sUrl);
        }

        return $sUrl;
    }

    /**
     * @return d3_cfg_mod
     */
    public function d3GetSet()
    {
        return d3_cfg_mod::get('d3_ordermanager');
    }

    public function getLink()
    {
        return '';
    }
}
