<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3ordermanager_unit_models_requirements_d3ordermanagerrequirementgrouplistTest extends OxidTestCase
{
    /** @var d3ordermanager_requirementgrouplist */
    protected $_oRequGroupList;

    /**
     * setup basic requirements
     */
    public function setUp()
    {
        parent::setUp();

        $oOrderManager = oxNew('d3ordermanager');
        $this->_oRequGroupList = $this->getProxyClass('d3ordermanager_requirementgrouplist', array($oOrderManager));
    }
    
    public function tearDown()
    {
        parent::tearDown();
        
        unset($this->_oRequGroupList);
    }

    public function testsetGroups()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $this->assertEquals(1, count($this->_oRequGroupList->getGroupList()));
    }

    public function testhasGroup_true()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $this->assertTrue($this->_oRequGroupList->hasGroup('foo'));
    }

    public function testhasGroup_false()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $this->assertFalse($this->_oRequGroupList->hasGroup('bar'));
    }

    public function testremoveGroup()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));
        $this->_oRequGroupList->removeGroup('foo');
        $this->assertEquals(0, count($this->_oRequGroupList->getGroupList()));
    }

    public function testClearGroups()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));
        $this->_oRequGroupList->clearGroups();
        $this->assertEquals(0, count($this->_oRequGroupList->getGroupList()));
    }

    public function testgetGroupIdList()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $aGroupIdList = $this->_oRequGroupList->getGroupIdList();
        $this->assertTrue(is_array($aGroupIdList) && count($aGroupIdList) == 1 && in_array('foo', $aGroupIdList));
    }

    public function testgetGroup()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $oGroup = $this->_oRequGroupList->getGroup('foo');
        $this->assertTrue(is_object($oGroup) && $oGroup instanceof d3ordermanager_requirementlist);
    }

    public function testgetGroup_notexistinggroup()
    {
        $this->_oRequGroupList->setGroups(array('foo' => array('d3ordermanager_requirement_countryfilter')));

        $oGroup = $this->_oRequGroupList->getGroup('bar');
        $this->assertTrue(is_null($oGroup));
    }

    public function testgetWhereSql()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oGroupMock */
        $oGroupMock = $this->getMock(
            'd3ordermanager_requirementlist',
            array(
                'getWhereSql',
            ),
            array($this->_oRequGroupList->getManager())
        );
        $oGroupMock->expects($this->any())->method('getWhereSql')->will($this->returnValue(" 1 AND 1 "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementgrouplist $oGroupListMock */
        $oGroupListMock = $this->getMock('d3ordermanager_requirementgrouplist', array('getGroupList'), array($this->_oRequGroupList->getManager()));
        $oGroupListMock->expects($this->any())->method('getGroupList')->will($this->returnValue(array('foobar' => $oGroupMock)));

        $this->assertEquals(' 1 AND 1 ', $oGroupListMock->getWhereSql());
    }

    public function testgetWhereSql_Empty()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementgrouplist $oGroupListMock */
        $oGroupListMock = $this->getMock('d3ordermanager_requirementgrouplist', array('getGroupList'), array($this->_oRequGroupList->getManager()));
        $oGroupListMock->expects($this->any())->method('getGroupList')->will($this->returnValue(array()));

        $this->assertEquals('', $oGroupListMock->getWhereSql());
    }

    public function testgetHavingSql()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementlist $oGroupMock */
        $oGroupMock = $this->getMock(
            'd3ordermanager_requirementlist',
            array(
                'getHavingSql',
            ),
            array($this->_oRequGroupList->getManager())
        );
        $oGroupMock->expects($this->any())->method('getHavingSql')->will($this->returnValue(" 1 AND 1 "));

        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementgrouplist $oGroupListMock */
        $oGroupListMock = $this->getMock('d3ordermanager_requirementgrouplist', array('getGroupList'), array($this->_oRequGroupList->getManager()));
        $oGroupListMock->expects($this->any())->method('getGroupList')->will($this->returnValue(array('foobar' => $oGroupMock)));

        $this->assertEquals(' 1 AND 1 ', $oGroupListMock->getHavingSql());
    }

    public function testgetHavingSql_Empty()
    {
        /** @var PHPUnit_Framework_MockObject_MockObject|d3ordermanager_requirementgrouplist $oGroupListMock */
        $oGroupListMock = $this->getMock('d3ordermanager_requirementgrouplist', array('getGroupList'), array($this->_oRequGroupList->getManager()));
        $oGroupListMock->expects($this->any())->method('getGroupList')->will($this->returnValue(array()));

        $this->assertEquals('', $oGroupListMock->getHavingSql());
    }
}
