<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3_oxorder_printorder extends d3_oxorder_printorder_parent
{

    /**
     * @return string|null
     */
    public function d3GetPrintOrderPreviewLink()
    {
        return d3printorder_application_models_handler::getInstance()->getPreviewLink($this->getId());
    }

    /**
     * @param null $sOrderId
     *
     * @return bool|string
     */
    public function d3GetPrintOrderFilePath($sOrderId = null)
    {
        if (empty($sOrderId)) {
            $sOrderId = $this->getId();
        }

        return d3printorder_application_models_handler::getInstance()->getExistingFilePath($sOrderId);
    }

    /**
     * @return null|oxbasket
     */
    public function getBasket()
    {
        $oReturn = parent::getBasket();

        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            if (empty($oReturn)) {
                $oReturn = $this->d3getBasketFromOrder();
            }
        }

        return $oReturn;
    }

    /**
     * Returns order payment
     *
     * @return oxUserPayment
     */
    public function getPayment()
    {
        $oReturn = parent::getPayment();

        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            if (empty($oReturn)) {
                $oReturn = $this->_setPayment($this->getBasket()->getPaymentId());
            }
        }

        return $oReturn;
    }

    /**
     * @return null|oxbasket
     */
    public function d3getBasketFromOrder()
    {
        $oBasket = null;

        try {
            $oBasket = $this->_getOrderBasket();

            // add order articles to virtual basket and calculate basket
            $this->_addOrderArticlesToBasket($oBasket, $this->getOrderArticles(true));
            $oBasket->calculateBasket(true);

        } catch (Exception $oE) {
            d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'can not load basket from order', //
                ''
            );
        }

        return $oBasket;
    }
}