<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'          => 'd3printorder',
    'title'       => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') //
        . ' Bestellbest&auml;tigung drucken',
    'description' => array(
        'de' => 'Speichert beim Abschlie&szlig;en einer Bestellung die HTML-E-Mail an den Kunden. ' //
            . 'Erm&ouml;glicht dadurch das nachtr&auml;gliche Ausdrucken der Bestellbest&auml;tigung.<br><br>' //
            . 'Dies kann auch f&uuml;r bereits existierende Bestellungen im Nachgang erfolen.',
        'en' => 'n/a',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '3.1.0.0',
    'author'      => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'extend'      => array(
        'oxemail'        => 'd3/d3printorder/modules/core/d3_oxemail_bestellbestaetigungdrucken',
        'oxorder'        => 'd3/d3printorder/modules/application/models/d3_oxorder_printorder',
        'oxorderarticle' => 'd3/d3printorder/modules/application/models/d3_oxorderarticle_printorder',
        'oxshop'         => 'd3/d3printorder/modules/application/models/d3_oxshop_printorder',
        // more extensions see end of file
    ),
    'files'       => array(
        'd3printorder_preview'                    => 'd3/d3printorder/application/controllers/d3printorder_preview.php',
        'd3printorder_application_models_handler' => 'd3/d3printorder/application/models/handler.php',
        'd3printorder_update'                     => 'd3/d3printorder/setup/d3printorder_update.php',
    ),
    'templates'   => array(
        'd3printorder_cfg.tpl'                      => 'd3/d3printorder/views/admin/tpl/d3printorder_cfg.tpl',
        'email_order_cust_print.tpl'                => 'd3/d3printorder/views/tpl/email_order_cust_print.tpl',
        // themeabhngige TPL
        'd3printorder_azure_page_account_order.tpl' => 'd3/d3printorder/views/azure/tpl/d3printorder_account_order.tpl',
        'd3printorder_mobil_page_account_order.tpl' => 'd3/d3printorder/views/mobile/tpl/d3printorder_account_order.tpl',
    ),
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'blocks'      => array(
        array(
            'template' => 'page/account/order.tpl',
            'block'    => 'd3printorder_account_order',
            'file'     => 'views/blocks/d3printorder_page_account_order.tpl'
        ),
        array(
            'template' => 'page/checkout/thankyou.tpl',
            'block'    => 'checkout_thankyou_proceed',
            'file'     => 'views/blocks/d3printorder_page_checkout_thankyou.tpl'
        ),
    )
);

if (class_exists('d3modext_status')) {
    $aModule['extend']['d3modext_status'] = 'd3/d3printorder/modules/application/controllers/admin/d3modext_status_printbasket';
}