<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @link          http://www.oxidmodule.com
 */

/**
 * Class d3modext_status_printbasket
 */
class d3modext_status_printbasket extends d3modext_status_printbasket_parent
{

    /**
     * @return mixed
     */
    public function render()
    {
        $blMobileSettingsNeeded = false;
        $blOldPrintorders       = false;

        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            $blMobileSettingsNeeded = d3printorder_application_models_handler::getInstance()->d3isMobileInstalled();
            $blOldPrintorders       = d3printorder_application_models_handler::getInstance()->showButtonToMoveOldOrderPrintsToNewDir();
        }

        $this->addTplParam('blShowMobileSettings', $blMobileSettingsNeeded);
        $this->addTplParam('blOldPrintorders', $blOldPrintorders);

        return parent::render();
    }

    /**
     *
     */
    public function moveOldPrintOrderFilesToNewDir()
    {
        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            d3printorder_application_models_handler::getInstance()->moveOldOrderPrintsToNewDir();
        }
    }

    /**
     *
     */
    public function d3printorder_recaching()
    {
        d3printorder_application_models_handler::getInstance()->d3recachingOrder();
    }

    /**
     * template getter for modulesettings
     * @param $sSetting
     *
     * @return mixed
     */
    public function getModuleSetting($sSetting)
    {
        return d3printorder_application_models_handler::getInstance()->getOption($sSetting);
    }
}