<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3printorder_update extends d3install_updatebase
{
    public $sModKey = 'd3printorder';

    public $sModName = 'Bestellbesttigung drucken';

    public $sModVersion = '3.1.0.0';

    public $sModRevision = '49';

    public $sBaseConf = '269bC9IYm1mWGRGRDdFMWxSc0l6VUJuTk1xOFV0Y0RFMnhDYVVDRTZuWDZ1NEZwUVVHOFBIQWREVXVTR
mJvaHZyZ3BVZlBIM1ZxbmtDUEIzNW5FbCtuK2Q1U0kvQ3diZ0NoNnhGZmdlS0NUMUZVTkhDbW1iVElxV
k9PM0xhNlArbjUxRExpdWt4SFRyWjAyQXMyb2ZWb21XUlRvdzkwN1A0dzZHdlovZWZDTWF3RXRiYjdsY
y9tSkNTNmw3enVSaGFHYTFTUklMbTFEWmxPYmIyZGp4djNja0F0Q0tNd3VzSUJIcVlXREF4OEZxdjBJb
TdBMGo5VERocVJRL3ZsV3VZTCtFYVNXeWNwekJmV2R6TUFDRzlKY3lEbGVpTzM5dUswL1lJNnFpZysyK
0E9';

    public $sRequirements = '';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'hasOldOrderPrintFiles', // alter Printorder-Pfad sowie Dateien vorhanden?
            'do'    => 'updateOldOrderPrintFiles'
        ),
        array(
            'check' => 'hasOldModuleFiles',
            'do'    => 'deleteOldModuleFiles'
        ),
        array(
            'check' => 'hasOldModuleItems',           // alte oxconfig-Eintrge vorhanden?
            'do'    => 'deleteOldModuleItems'
        ),
        array(
            'check' => 'checkModCfgSameRevision',
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    public $aFields = array();

    public $aIndizes = array();

    protected $_aRefreshMetaModuleIds = array('d3printorder');

    public $aOldModuleFiles = array(
        'd3/d3_bestellbestaetigungdrucken/',
    );

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                    'oxnewrevision' => $this->sModRevision,
                );

                if ($this->_checkTableItemNotExist('d3_cfg_mod', $aWhere)) {
                    // update don't use this property
                    unset($aWhere['oxnewrevision']);

                    $aInsertFields = array(
                        'OXID'           => array(
                            'content'      => "md5('" . $this->sModKey . " " . $oShop->getId() . "')",
                            'force_update' => false,
                            'use_quote'    => false,
                        ),
                        'OXSHOPID'       => array(
                            'content'      => $oShop->getId(),
                            'force_update' => false,
                            'use_quote'    => true,
                        ),
                        'OXMODID'        => array(
                            'content'      => $this->sModKey,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXNAME'         => array(
                            'content'      => $this->sModName,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXACTIVE'       => array(
                            'content'      => "0",
                            'force_update' => false,
                            'use_quote'    => false,
                        ),
                        'OXBASECONFIG'   => array(
                            'content'      => $this->sBaseConf,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXINSTALLDATE'  => array(
                            'content'      => "NOW()",
                            'force_update' => true,
                            'use_quote'    => false,
                        ),
                        'OXVERSION'      => array(
                            'content'      => $this->sModVersion,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXSHOPVERSION'  => array(
                            'content'      => oxRegistry::getConfig()->getEdition(),
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXREQUIREMENTS' => array(
                            'content'      => $this->sRequirements,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXVALUE'        => array(
                            'content'      => $this->sBaseValue,
                            'force_update' => false,
                            'use_quote'    => true,
                        ),
                        'OXNEWREVISION'  => array(
                            'content'      => $this->sModRevision,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                    );
                    $aRet          = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
                    $blRet         = $aRet['blRet'];
                    $this->setActionLog('SQL', $aRet['sql'], __METHOD__);
                    $this->setUpdateBreak(false);

                    if ($this->getStepByStepMode()) {
                        break;
                    }
                }
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkModCfgSameRevision()
    {
        return $this->_checkModCfgSameRevision($this->sModKey);
    }

    /**
     * @return bool
     */
    public function updateModCfgSameRevision()
    {
        $blRet = false;

        if ($this->checkModCfgSameRevision($this->sModKey)) {
            $aRet = $this->_updateModCfgSameRevision($this->sModKey);

            $this->setActionLog('SQL', $aRet['sql'], __METHOD__);
            $this->setUpdateBreak(false);
            $blRet = $aRet['blRet'];
        }

        return $blRet;
    }

    /************************************/
    /*** eigene Printorder - Methoden ***/
    /************************************/

    /**
     * Prft ob innerhalb des Modulverzeichnisses Bestellbesttigungs-Files liegen
     *
     * @return bool
     * TRUE  - Dateien sind vorhanden und mssen verschoben werden
     * FALSE - keine Altlasten vorhanden, kein Update dazu notwendig
     */
    public function hasOldOrderPrintFiles()
    {
        $sOldPath = d3printorder_application_models_handler::getInstance()->getOldPrintOrderFolder();

        if (is_dir($sOldPath)) {
            if (false == oxRegistry::getSession()->getVariable('bld3printorder_hasFilesInOldPath')) {
                return true;
            }
        }

        return false;
    }

    /**
     * Dateien automatisch verschieben, wenn die max. Anzahl an Files bei 10.000 oder weniger
     * andernfalls wird eine Meldung, mit der Aufforderung des manuelen Verschiebens ausgegeben
     *
     * @return bool
     */
    public function updateOldOrderPrintFiles()
    {
        $blRet = true;

        $sNewPath = d3printorder_application_models_handler::getInstance()->getPrintOrderFolder();
        $sOldPath = d3printorder_application_models_handler::getInstance()->getOldPrintOrderFolder();

        if ($this->hasOldOrderPrintFiles()) {
            if(d3printorder_application_models_handler::getInstance()->canMoveFilesInAutoUpdate()) {
                $sTranslation = oxRegistry::getLang()->translateString('D3_ORDERPRINT_AUTOUPDATE_FOLDER_FOR_ORDERPRINTS');
                $sTranslation = sprintf($sTranslation, $sNewPath);
                $blRet        = $this->_confirmMessage($sTranslation);

                if ($this->hasExecute()) {
                    d3printorder_application_models_handler::getInstance()->moveOldOrderPrintsToNewDir();
                    oxRegistry::getSession()->setVariable('bld3printorder_hasFilesInOldPath', 1);
                }
            } else {
                $aArgs        = array($sOldPath, $sNewPath, $sOldPath);
                $sTranslation = oxRegistry::getLang()->translateString('D3_ORDERPRINT_UPDATE_FOLDER_FOR_ORDERPRINTS');
                $sTranslation = vsprintf($sTranslation, $aArgs);
                $blRet        = $this->_confirmMessage($sTranslation);
            }
        }

        return $blRet;
    }
}