<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3printorder_update extends d3install_updatebase
{
    public $sModKey = 'd3printorder';

    public $sModName = 'Bestellbesttigung drucken';

    public $sModVersion = '3.1.1.3';

    public $sModRevision = '69';

    public $sBaseConf = 'qE8OVdWemhiUE9PNU1rbFlMbEdKNDRSMDNQRXhxdzlFckhvcmp4c3F5RHJudDNKcHdNU05XTVdFak9vU
XEveGx2VXJPOW5GRWN5MGhMdElFdHpuem93ZFdPYThrVDdNLytvMUNFeGZNY2dBR3h2REd0UVNXV0kzR
TE3c3VLdS9vc0xadnl5bjMzMjBLUWZvQjk4SnN6djNxYmF3bVd2NFBlOSt2WnZhNkhPYWQydmhBMUZuS
jIwUm95cGxWU29ESThZaXdJSDhFUGM0OWJHaU11SFBaRFQ4S0pLV0l2Q0w0Q0FlNXMxSWsyYUlJbER2M
Hhrck5ycFZCQVFQYk9pb3kvQVBEODNOZGl5aVhOMDBtV29INzVJblYxRFI4WGVueXRITnNEMDAvNlhIV
ytkVFpiWjBDK3dySmQzMVpQTmt3OGxCbEpETjZZY3IrM3VWYU0wTVZUamh3PT0=';

    /**
     * minimale Modul-Connector Versionsprfung fr die Installation
     */
    public $sMinModCfgVersion = '4.4.1.0';

    public $sRequirements = '';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'hasOldOrderPrintFiles', // alter Printorder-Pfad sowie Dateien vorhanden?
            'do'    => 'updateOldOrderPrintFiles'
        ),
        array(
            'check' => 'hasOldModuleFiles',
            'do'    => 'deleteOldModuleFiles'
        ),
        array(
            'check' => 'hasOldModuleItems',           // alte oxconfig-Eintrge vorhanden?
            'do'    => 'deleteOldModuleItems'
        ),
        array(
            'check' => 'hasUnregisteredFiles',          // gltige Modul-Dateien prfen - see metadata.php d3FileRegister
            'do'    => 'showUnregisteredFiles'
        ),
        array(
            'check' => 'checkModCfgSameRevision',
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    public $aFields = array();

    public $aIndizes = array();

    protected $_aRefreshMetaModuleIds = array('d3printorder');

    public $aOldModuleFiles = array(
        'd3/d3_bestellbestaetigungdrucken/',
    );


    /**
     * @return bool
     */
    public function hasUnregisteredFiles()
    {
        return $this->_hasUnregisteredFiles($this->sModKey, array('d3FileRegister'));
    }

    /**
     * @return bool
     */
    public function showUnregisteredFiles()
    {
        return $this->_showUnregisteredFiles($this->sModKey, array('d3FileRegister'));
    }

    /************************************/
    /*** eigene Printorder - Methoden ***/
    /************************************/

    /**
     * Prft ob innerhalb des Modulverzeichnisses Bestellbesttigungs-Files liegen
     *
     * @return bool
     * TRUE  - Dateien sind vorhanden und mssen verschoben werden
     * FALSE - keine Altlasten vorhanden, kein Update dazu notwendig
     */
    public function hasOldOrderPrintFiles()
    {
        $sOldPath = d3printorder_application_models_handler::getInstance()->getOldPrintOrderFolder();

        if (is_dir($sOldPath)) {
            if (false == oxRegistry::getSession()->getVariable('bld3printorder_hasFilesInOldPath')) {
                return true;
            }
        }

        return false;
    }

    /**
     * Dateien automatisch verschieben, wenn die max. Anzahl an Files bei 10.000 oder weniger
     * andernfalls wird eine Meldung, mit der Aufforderung des manuelen Verschiebens ausgegeben
     *
     * @return bool
     */
    public function updateOldOrderPrintFiles()
    {
        $blRet = true;

        $sNewPath = d3printorder_application_models_handler::getInstance()->getPrintOrderFolder();
        $sOldPath = d3printorder_application_models_handler::getInstance()->getOldPrintOrderFolder();

        if ($this->hasOldOrderPrintFiles()) {
            if(d3printorder_application_models_handler::getInstance()->canMoveFilesInAutoUpdate()) {
                $sTranslation = oxRegistry::getLang()->translateString('D3_ORDERPRINT_AUTOUPDATE_FOLDER_FOR_ORDERPRINTS');
                $sTranslation = sprintf($sTranslation, $sNewPath);
                $blRet        = $this->_confirmMessage($sTranslation);

                if ($this->hasExecute()) {
                    d3printorder_application_models_handler::getInstance()->moveOldOrderPrintsToNewDir();
                    oxRegistry::getSession()->setVariable('bld3printorder_hasFilesInOldPath', 1);
                }
            } else {
                $aArgs        = array($sOldPath, $sNewPath, $sOldPath);
                $sTranslation = oxRegistry::getLang()->translateString('D3_ORDERPRINT_UPDATE_FOLDER_FOR_ORDERPRINTS');
                $sTranslation = vsprintf($sTranslation, $aArgs);
                $blRet        = $this->_confirmMessage($sTranslation);
            }
        }

        return $blRet;
    }
}
