<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3_oxorder_printorder extends d3_oxorder_printorder_parent
{

    /**
     * @return string|null
     */
    public function d3GetPrintOrderPreviewLink()
    {
        return d3printorder_application_models_handler::getInstance()->getPreviewLink($this->getId());
    }

    /**
     * @param null $sOrderId
     *
     * @return bool|string
     */
    public function d3GetPrintOrderFilePath($sOrderId = null)
    {
        if (empty($sOrderId)) {
            $sOrderId = $this->getId();
        }

        return d3printorder_application_models_handler::getInstance()->getExistingFilePath($sOrderId);
    }

    /**
     * @return null|oxbasket
     */
    public function getBasket()
    {
        $oReturn = parent::getBasket();

        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            if (empty($oReturn)) {
                $oReturn = $this->d3getBasketFromOrder();
            }
        }

        return $oReturn;
    }

    /**
     * Returns order payment
     *
     * @return oxUserPayment
     */
    public function getPayment()
    {
        if (false == d3_cfg_mod::get('d3printorder')->isActive()) {

            return parent::getPayment();
        }

        $oReturn = parent::getPayment();
        if (false == empty($oReturn)) {
            return $oReturn;
        }

        // payment is empty, try to load it from order
        $oPayment     = oxNew('oxpayment');
        $sPaymentOxid = $this->getBasket()->getPaymentId();
        if ($oPayment->load($sPaymentOxid)) {
            $oReturn = $this->_setPayment($sPaymentOxid);

            return $oReturn;
        }

        // try loading oxempty (standard-oxid-payment)
        $oDb          = oxDb::getDb(oxDb::FETCH_MODE_ASSOC);
        $sSelect      = "SELECT oxid FROM oxpayments WHERE oxid = 'oxempty'";
        $sPaymentOxid = $oDb->getOne($sSelect);

        if ($oPayment->load($sPaymentOxid)) {
            // oxpayment not fount/settet
            d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'oxpayment not found', //
                'order id: ' . $this->getId() . PHP_EOL //
                . 'order nr: ' . $this->oxorder__oxordernr->value . PHP_EOL //
                . 'oxpaymenttype: ' . $this->oxorder__oxpaymenttype->value . PHP_EOL //
                . 'set to oxempty' //
            );

            $oReturn = $this->_setPayment($sPaymentOxid);

            return $oReturn;
        }

        // loading next active Payment
        // payment dont is assiziated to shops AND oxshopid = " . $oDb->quote($this->getShopId());
        $sSelect      = "SELECT oxid FROM oxpayments WHERE oxactive = '1'";
        $sPaymentOxid = $oDb->getOne($sSelect);

        // oxpayment not fount/settet
        d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'oxpayment not found', //
            'order id: ' . $this->getId() . PHP_EOL //
            . 'order nr: ' . $this->oxorder__oxordernr->value . PHP_EOL //
            . 'oxpaymenttype: ' . $this->oxorder__oxpaymenttype->value . PHP_EOL //
            . 'set to next active payment in shop' //
        );

        $oReturn = $this->_setPayment($sPaymentOxid);

        return $oReturn;
    }

    /**
     * @return null|oxbasket
     */
    public function d3getBasketFromOrder()
    {
        $oBasket = null;

        try {
            $oBasket = $this->_getOrderBasket();

            // add order articles to virtual basket and calculate basket
            $this->_addOrderArticlesToBasket($oBasket, $this->getOrderArticles(true));
            $oBasket->calculateBasket(true);

        } catch (Exception $oE) {
            d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
                d3log::ERROR,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'can not load basket from order', //
                '' . $oE->getMessage()
            );
        }

        return $oBasket;
    }

    /**
     * Returns order deliveryset object
     *
     * @return oxDeliverySet
     */
    public function getDelSet()
    {
        $oDelset = parent::getDelSet();

        if (d3_cfg_mod::get('d3printorder')->isActive() && empty($oDelset->oxdeliveryset__oxtitle->value)) {

            // versandart / oxdelset not fount/settet
            d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'oxdeliveryset not found', //
                'order id: ' . $this->getId() . PHP_EOL //
                . 'order nr: ' . $this->oxorder__oxordernr->value . PHP_EOL //
                . 'oxdeltype: ' . $this->oxorder__oxdeltype->value . PHP_EOL //
                . 'set to next active oxdeliveryset in this shop' //
            );

            $oDb         = oxDb::getDb(oxDb::FETCH_MODE_ASSOC);
            $sSelect     = "SELECT oxid FROM oxdeliveryset WHERE oxactive = '1' AND oxshopid = " . $oDb->quote($this->getShopId());
            $sDelsetOxid = $oDb->getOne($sSelect);

            // load deliveryset info
            $this->_oDelSet = oxNew('oxdeliveryset');
            $this->_oDelSet->load($sDelsetOxid);

            return $this->_oDelSet;
        }

        return $oDelset;
    }
}
