<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

/**
 * Class d3_oxemail_bestellbestaetigungdrucken
 */
class d3_oxemail_bestellbestaetigungdrucken extends d3_oxemail_bestellbestaetigungdrucken_parent
{

    public $blD3recaching = false;

    /**
     * call parent::sendOrderEmailToUser() and write HTML-Body in File
     *
     * @param oxOrder $oOrder   Order object
     * @param string  $sSubject user defined subject [optional]
     *
     * @return bool
     */
    public function sendOrderEmailToUser($oOrder, $sSubject = null)
    {
        if (d3_cfg_mod::get('d3printorder')->isActive()) {
            $this->setUseInlineImages(false);
        }

        try {
            $blReturn = parent::sendOrderEmailToUser($oOrder, $sSubject);
        } catch (Exception $oEx) {

            if (d3_cfg_mod::get('d3printorder')->isActive()) {
                d3_cfg_mod::get('d3printorder')->d3getLog()->Log(
                    d3log::ERROR,
                    __CLASS__,
                    __FUNCTION__,
                    __LINE__,
                    'parent-call oxemail::sendOrderEmailToUser', //
                    'order id: ' . $oOrder->getId() . PHP_EOL //
                    . 'order nr: ' . $oOrder->oxorder__oxordernr->value . PHP_EOL //
                    . 'catched exception: ' . $oEx->getMessage() //
                );
            }
        }

        d3printorder_application_models_handler::getInstance()->writeOrderPrint($oOrder, $this->getBody());

        return $blReturn;
    }

    /**
     * Outputs email fields thought email output processor, includes images, and initiate email sending
     * If fails to send mail via SMTP, tries to send via mail(). On failing to send, sends mail to
     * shop administrator about failing mail sending
     *
     * @return bool
     */
    public function send()
    {
        if (d3_cfg_mod::get('d3printorder')->isActive() && $this->d3getOrderRecaching()) {
            //Recaching aller noch nicht angelegten Bestellungen -> d.h. kein Mailversandt
            return true;
        }

        return parent::send();
    }

    /**
     * @param $blDoRecach
     */
    public function d3setOrderRecaching($blDoRecach)
    {
        $this->blD3recaching = $blDoRecach;
    }

    /**
     * @return string
     */
    public function d3getOrderRecaching()
    {
        return $this->blD3recaching;
    }
}
