<?php

$sMetadataVersion = '1.1';
if (class_exists('d3utils')) {
    $sLogo = d3utils::getInstance()->getD3Logo();
} else {
    $sLogo = 'D&sup;';
}

$aModule = array(
    'id'          => 'd3oqm',
    'title'       => $sLogo . ' Bestellmengenmanager',
    'description' => 'Legen Sie fest, in welchen Mengen bzw. Packungsgr&ouml;&szlig;en Sie ihre Produkte abgeben.' //
        . 'Der Kunde wird bei unpassender Mengenangabe informiert.' //
        . 'Optional wird die korrigierte Menge in den Warenkorb gelegt.' //
        . 'Alle Einstellungen sind im Admin zu setzen.</br>' //
        . 'Wenn das Modul &uuml;ber den Shop aktiviert wurde, muss danach unter:</br>' //
        . '<strong>/D&sup3; Module/Modul-Connector/Modulverwaltung/</strong> das Modul aktiviert werden.',
    'thumbnail'   => 'picture.png',
    'version'     => '4.1.1.0',
    'author'      => 'D&sup3; Data Development',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'files'       => array(
        'd3_d3oqm_model_handler' => 'd3/d3oqm/models/handler.php',
        'd3oqm_update'           => 'd3/d3oqm/models/d3oqm_update.php',
    ),
    'templates'   => array(
        'd3_msg_basket_oqm_error.tpl' => 'd3/d3oqm/views/tpl/d3_msg_basket_oqm_error.tpl',
        'd3oqm_cfg.tpl'               => 'd3/d3oqm/views/admin/tpl/d3oqm_cfg.tpl',
    ),
    'extend'      => array(
        'oxarticle'    => 'd3/d3oqm/modules/application/models/d3_oxarticle_oqm',
        'oxbasket'     => 'd3/d3oqm/modules/application/models/d3_oxbasket_oqm',
        'oxutilsview'  => 'd3/d3oqm/modules/core/d3_oxutilsview_oqm',
        'oxviewconfig' => 'd3/d3oqm/modules/core/d3_oxviewconfig_oqm',
    ),
    'blocks'      => array(
        array(
            'template' => 'page/details/inc/productmain.tpl',
            'block'    => 'details_productmain_tobasket',
            'file'     => 'views/blocks/details_productmain_tobasket.tpl'
        ),
        array(
            'template' => 'widget/minibasket/minibasket.tpl',
            'block'    => 'widget_minibasket',
            'file'     => 'views/blocks/widget_minibasket.tpl'
        ),
        array(
            'template' => 'widget/product/listitem_grid.tpl',
            'block'    => 'widget_product_listitem_grid_tobasket',
            'file'     => 'views/blocks/widget_product_listitem_grid_tobasket.tpl'
        ),
        array(
            'template' => 'widget/product/bargainitem.tpl',
            'block'    => 'widget_product_bargainitem_tobasket',
            'file'     => 'views/blocks/widget_product_bargainitem_tobasket.tpl'
        ),
        array(
            'template' => 'widget/product/listitem_infogrid.tpl',
            'block'    => 'widget_product_listitem_infogrid_tobasket',
            'file'     => 'views/blocks/d3getminamount_input_field.tpl'
        ),
        array(
            'template' => 'widget/product/listitem_line.tpl',
            'block'    => 'widget_product_listitem_line_tobasket',
            'file'     => 'views/blocks/widget_product_listitem_line_tobasket.tpl'
        ),
        array(
            'template' => 'article_extend.tpl',
            'block'    => 'admin_article_extend_form',
            'file'     => 'views/admin/blocks/admin_article_extend_form.tpl'
        ),
        array(
            'template' => 'page/details/inc/productmain.tpl',
            'block'    => 'mb_details_productmain_tobasket',
            'file'     => 'views/mobile/blocks/mb_details_productmain_tobasket.tpl'
        ),
        array(
            'template' => 'widget/product/listitem.tpl',
            'block'    => 'widget_product_listitem_line_tobasket',
            'file'     => 'views/mobile/blocks/widget_product_listitem_line_tobasket.tpl'
        ),
    ),
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
);
