<?php

use D3\ModCfg\Application\Model\Install\d3install_updatebase;
use D3\ModCfg\Application\Model\Installwizzard\d3installconfirmmessage;
use OxidEsales\Eshop\Core\Registry;

/**
 * User: kristianhempel
 * Date: 04.03.13
 * automatische Installation
 */
class d3_oqm_Setup_InstallRoutine extends d3install_updatebase
{
    // Standardwert fr checkModCfgSameRevision() und updateModCfgSameRevision()
    public $sModKey = 'd3oqm';
    public $sModName = 'D3 Bestellmengen Manager';
    public $sModVersion = '5.0.1.0';
    public $sModRevision = '5010';
    public $sBaseConf = '8Ecv2==NHNLSnUvWkZ5WHlxelFjc0lvOGdRd0VrQmZQeHU1WDhRZkNxT2V1SzZqcGJXSzNpb0o2MVpmS
3M3RVFsalpMU3crQVovUFRDQXRXblJyaHA3aHBkNWE0NWZOUzY1NkF2akE4MWk3LzFIdVQ1YUt1b0JjO
HF1WHpoay9CbXJKeW9RRGZiNEZmeVE2cHVYSFBEaHJabDFBbm5iRyt0VHoreWl2VlI1bGhXL1Via09hN
0s2TlJldlAxU1VqWkpCZ254QmRaSzFNNWFPZC9pbWVkV2cycytiK3RsMWFsdFFoaEU4QVd1M2tDcE9UZ
y9TalBmNTd0N1cwK2JQaTNDVEZ2Q0NrRWZMZDMxSHpQZmFLK3ErMVJONERRWjd0ZmdXMGhuck9tN0JBb
XB6aXNTN2FDa0s3VHJIOWhBYWg3SHYyWUc=';

    public $sBaseValue = '';
    public $sMinModCfgVersion = '5.1.1.0';

    // auszufhrende Check- und Updateanweisungen in auszufhrender Reihenfolge
    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkWrongTemplateBlock',
            'do'    => 'fixWrongTemplateBlock',
        ),
        array(
            'check' => 'hasOldOxmoduleInOxtplblocks',
            'do'    => 'fixOldOxmoduleInOxtplblocks',
        ),
        array(
            'check' => 'checkFields',
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'checkIndizes',
            'do'    => 'fixIndizes'
        ),
        array(
            'check' => 'hasInitialTypeField',
            'do'    => 'updateInitialTypeField',
        ),
        array(
            'check' => 'hasInitialValueField',
            'do'    => 'updateInitialValueField',
        ),
        array(
            'check' => 'hasOldSmartyFiles',
            'do'    => 'messageOldSmartyFiles',
        ),
        array(
            'check' => 'checkModCfgSameRevision', // prft auf nachgezogene Revisionsnummer und bertrgt diese ggf.
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    /***** Standardwerte fr aufgerufene Funktionen ********************************************/

    // alle zu aktualisierenden Module, verwendet nicht onDeactivate-Handler
    protected $_aRefreshMetaModuleIds = array('d3oqm');

    // Standardwerte fr checkFields(), _addTable() und fixFields()
    public $aFields = array(
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_PACKAGE',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Verpackungseinheit',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_MINIMUM',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Minimum',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3OQM_MAXIMUM',
            'sType'       => 'DOUBLE',
            'blNull'      => true,
            'sDefault'    => 'NULL',
            'sComment'    => 'd3oqm - Bestellmengenmanager Maximum',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
    );

    // Standardwerte fr checkIndizes() und fixIndizes()
    public $aIndizes = array(
        array(
            'sTableName'  => 'oxarticles',
            'sType'       => 'INDEX',
            'sName'       => 'D3OQMINDEX',
            'aFields'     => array(
                'D3OQM_PACKAGE' => 'D3OQM_PACKAGE',
                'D3OQM_MAXIMUM' => 'D3OQM_MAXIMUM',
                'D3OQM_MINIMUM' => 'D3OQM_MINIMUM',
            ),
            'blMultilang' => false,
        ),
    );

    /**
     * check if wrong template block
     *
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     */
    public function checkWrongTemplateBlock()
    {
        $oShop  = $this->getActShop();
        $aWhere = array(
            'oxfile'      => 'd3GetMinAmout_input_field',
            'oxblockname' => 'widget_product_listitem_grid_tobasket',
            'oxshopid'    => $oShop->getId(),
        );

        // NOTE: _checkTableItemExist returns true if not exsist
        return !$this->_checkTableItemNotExist('oxtplblocks', $aWhere);
    }

    /**
     * fix Version 3.2.0.1
     *
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     * @throws \OxidEsales\Eshop\Core\Exception\ConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function fixWrongTemplateBlock()
    {
        $blRet = false;

        if ($this->checkWrongTemplateBlock()) {
            $oShop = $this->getActShop();

            $aWhere = array(
                'oxfile'      => 'd3GetMinAmout_input_field',
                'oxblockname' => 'widget_product_listitem_grid_tobasket',
                'oxshopid'    => $oShop->getId(),
            );

            // abwrtskompatibel auch mit Feldname als Key (siehe "OXNAME"),
            // dann jedoch keine Duplikatentfernung bei mehrfacher Feldzuweisung.
            $aInsertFields = array(
                array(
                    // Feldname ggf. sprachspezifisch mit _getLangAbbrFieldName()
                    'fieldname'     => 'OXFILE',
                    // Feldinhalt
                    'content'       => 'widget_product_listitem_grid_tobasket.tpl',
                    // bei Update, Inhalt wird berschrieben
                    'force_update'  => true,
                    // Inhalt muss gequoted werden
                    'use_quote'     => true,
                    // Multilang-Felder auf Basis dieses Feldes werden bei INSERT mit diesem Wert gefllt,
                    // wenn diese in der Liste nicht anderweitig belegt sind
                    'use_multilang' => false,
                ),
            );
            $aRet          = $this->_updateTableItem2('oxtplblocks', $aInsertFields, $aWhere);
            $blRet         = $aRet['blRet'];
        }

        return $blRet;
    }

    /**
     * check if 'd3/d3oqm' is in oxmodule
     *
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     */
    public function hasOldOxmoduleInOxtplblocks()
    {
        $oShop = $this->getActShop();

        $aWhere = array(
            'oxmodule' => 'd3/d3oqm',
            'oxshopid' => $oShop->getId(),
        );

        // NOTE: _checkTableItemExist returns true if not exsist
        return !$this->_checkTableItemNotExist('oxtplblocks', $aWhere);
    }

    /**
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function fixOldOxmoduleInOxtplblocks()
    {
        if ($this->hasOldOxmoduleInOxtplblocks()) {
            $oShop = $this->getActShop();
            $aQueries = array(
                "DELETE FROM oxtplblocks WHERE oxmodule = 'd3/d3oqm' AND  oxshopid = '{$oShop->getId()}';"
            );

            return $this->_executeMultipleQueries($aQueries);
        }

        return true;
    }

    /**
     * @param null $iDirectNumber
     *
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function hasInitialTypeField($iDirectNumber = null)
    {
        $blReturn = false;
        if ($iDirectNumber === null) {
            for ($i = 0; $i <= 2; $i++) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_type{$iNumber}");
                if ($blReturn) {
                    return $blReturn;
                }
            }
        } else {
            $iNumber  = $iDirectNumber == 0 ? null : $iDirectNumber;
            $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_type{$iNumber}");
        }

        return $blReturn;
    }

    /**
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function updateInitialTypeField()
    {
        $blReturn = false;

        for ($i = 0; $i <= 2; $i++) {
            if ($this->hasInitialTypeField($i)) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_updateInitialTypeField($iNumber);
            }
        }

        return $blReturn;
    }

    /**
     * @param null $iNumber
     *
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    protected function _updateInitialTypeField($iNumber = null)
    {
        if ($this->hasInitialTypeField($iNumber)) {
            $aQueries = array(
                "UPDATE oxarticles SET D3OQM_MINIMUM = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'minimum' AND D3OQM_MINIMUM = 0;",
                "UPDATE oxarticles SET D3OQM_MAXIMUM = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'maximum' AND D3OQM_MAXIMUM = 0;",
                "UPDATE oxarticles SET D3OQM_PACKAGE = IF(d3_ve_value{$iNumber} = 0, NULL, d3_ve_value{$iNumber}) WHERE d3_ve_type{$iNumber} = 'package' AND D3OQM_PACKAGE = 0;",
                "ALTER TABLE `oxarticles` DROP `d3_ve_type{$iNumber}`;",
            );
            $blReturn = $this->_executeMultipleQueries($aQueries);
            $this->_getDatabaseHandler()->resetFieldCache();
            if ($blReturn) {
                $this->_blRequireViewUpdate = true;
            }

            return $blReturn;
        }

        return true;
    }

    /**
     * definition array see fixFields
     *
     *
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     * @throws \OxidEsales\Eshop\Core\Exception\ConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function fixFields()
    {
        $blReturn = parent::fixFields();
        if ($blReturn) {
            $this->_blRequireViewUpdate = true;
        }

        return $blReturn;
    }

    /**
     * @param null $iDirectNumber
     *
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function hasInitialValueField($iDirectNumber = null)
    {
        $blReturn = false;
        if ($iDirectNumber === null) {
            for ($i = 0; $i <= 2; $i++) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_value{$iNumber}");
                if ($blReturn) {
                    return $blReturn;
                }
            }
        } else {
            $iNumber  = $iDirectNumber == 0 ? null : $iDirectNumber;
            $blReturn = $this->_checkTableFieldExist('oxarticles', "d3_ve_value{$iNumber}");
        }

        return $blReturn;
    }

    /**
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function updateInitialValueField()
    {
        $blReturn = false;

        for ($i = 0; $i <= 2; $i++) {
            if ($this->hasInitialValueField($i)) {
                $iNumber  = $i == 0 ? null : $i;
                $blReturn = $this->_updateInitialValueField($iNumber);
            }
        }

        return $blReturn;
    }

    /**
     * @param null $iNumber
     *
     * @return bool
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    protected function _updateInitialValueField($iNumber = null)
    {
        if ($this->hasInitialValueField($iNumber)) {
            $aQueries = array(
                "ALTER TABLE `oxarticles` DROP `d3_ve_value{$iNumber}`;"
            );
            $blReturn = $this->_executeMultipleQueries($aQueries);
            $this->_getDatabaseHandler()->resetFieldCache();
            if ($blReturn) {
                $this->_blRequireViewUpdate = true;
            }

            return $blReturn;
        }

        return true;
    }

    public function hasOldSmartyFiles()
    {

        $file = $this->getConfig()->getConfigParam('sShopDir') . 'core/smarty/plugins/function.d3_oqm_getMinAmount.php';

        if( is_file($file)) {
            return true;
        }
        return false;
    }

    public function messageOldSmartyFiles()
    {
        $file = $this->getConfig()->getConfigParam('sShopDir') . 'core/smarty/plugins/function.d3_oqm_getMinAmount.php';
        /** @var d3installconfirmmessage $oInstallConfirmMessage */
        $oInstallConfirmMessage = oxNew(d3installconfirmmessage::class, $this);
        $oInstallConfirmMessage->ConfirmCustomMessage(
            Registry::getLang()->translateString('D3OQM_INSTALLATION_OLDSMARTYFILEFOUND').  " {$file}"
        );
    }
}
