<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3_contentTabs_update extends d3install_updatebase
{

    public $sModKey = 'd3contenttabs';

    public $sModName = 'Content Tabs';

    public $sModVersion = '3.1.0.2';

    public $sModRevision = '141';

    public $sBaseConf = 'qC9QjlQQVMxclZwTFZ4aFExcU5ueDlMU2VzSXRWUnhDbjZkS2hIeFhyWUo5VzBSQ2ZnS3piem9TeXZUQ
1lCcVp5WUVnSWRWcEo5VzhnQzZOc25XR3g5OTlsdTArMWVNOTZLd1FJeEowZlhzLzIvZHZZdWFEMnJaR
kZzd1p3dGVGL3FFc2VmOE5JQWdLTEo0RlJSUDczNTRoQVlLbGw2RVpYaHdQOFN2UnIxd3N5dy9Nc2ZxQ
UdrVzlpR2h6ZHg0UFhURElHallZUmtOTGx1RTZJODQ3RU13MmZoaDl3dEUrU01RMkNsVVFwQUdkV014d
mF0MEZXZzh4VUoyMXJXend2dzZhRXFCVWJZV3ZnRGVGWVhmZTVKdUJKUlMyNVpDaDNIMXhsMjI3eDFNN
3c9';

    public $sRequirements = '<?xml version="1.0" encoding="UTF-8"?>
      <jobs>
        <registerModule>
          <module class="details" modulepath="d3/d3contenttabs/modules/application/controllers/d3_details_contenttabs" />
          <module class="oxarticle" modulepath="d3/d3contenttabs/modules/application/models/d3_oxarticle_longtexts" />
        </registerModule>
        <database>
          <table name="oxartextends">
            <col name="OXLONGDESC" type="text" />
            <col name="D3LONGDESC2" type="text" />
            <col name="D3LONGDESC3" type="text" />
            <col name="D3LONGDESC4" type="text" />
            <col name="D3LONGDESC5" type="text" />
          </table>
          <table name="oxarticles">
            <col name="D3LONGDESCTITLE" type="varchar" length="255"/>
            <col name="D3LONGDESC2TITLE" type="varchar" length="255"/>
            <col name="D3LONGDESC3TITLE" type="varchar" length="255"/>
            <col name="D3LONGDESC4TITLE" type="varchar" length="255"/>
            <col name="D3LONGDESC5TITLE" type="varchar" length="255"/>
          </table>
        </database>
      </jobs>';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkRenameFields',
            'do'    => 'fixRenameFields'
        ),
        array(
            'check' => 'checkFields',
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'hasOldModuleFiles',
            'do'    => 'deleteOldModuleFiles'
        ),
        array(
            'check' => 'hasOldModuleItems',           // alte oxconfig-Eintrge vorhanden?
            'do'    => 'deleteOldModuleItems'
        ),
        array(
            'check' => 'checkModCfgSameRevision',
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    public $aFields = array(
        'D3LONGDESC2'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC2', //oxlongdesc2 -> OXLONGDESC2 -> D3LONGDESC2 (Type: TEXT)
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC3'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC3', // oxlongdesc3 -> OXLONGDESC3 -> D3LONGDESC3
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC4'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC4', // oxlongdesc4 -> OXLONGDESC4 -> D3LONGDESC4
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC5'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC5', // oxlongdesc5 -> OXLONGDESC5 -> D3LONGDESC5
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESCTITLE'  => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESCTITLE', // OXLONGDESCTITLE -> D3LONGDESCTITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC2TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC2TITLE', // oxlongdesc2title -> OXLONGDESC2TITLE -> D3LONGDESC2TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC3TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC3TITLE', // oxlongdesc3title -> OXLONGDESC3TITLE -> D3LONGDESC3TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC4TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC4TITLE', // oxlongdesc4title -> OXLONGDESC4TITLE -> D3LONGDESC4TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC5TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC5TITLE', // oxlongdesc5title -> OXLONGDESC5TITLE -> D3LONGDESC5TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
    );

    public $aRenameFields = array(
        'D3LONGDESC2'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc2', 'OXLONGDESC2'),
            'sFieldName'     => 'D3LONGDESC2', //oxlongdesc2 -> OXLONGDESC2 -> D3LONGDESC2
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC3'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc3', 'OXLONGDESC3'),
            'sFieldName'     => 'D3LONGDESC3', // oxlongdesc3 -> OXLONGDESC3 -> D3LONGDESC3
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC4'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc4', 'OXLONGDESC4'),
            'sFieldName'     => 'D3LONGDESC4', // oxlongdesc4 -> OXLONGDESC4 -> D3LONGDESC4
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC5'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc5', 'OXLONGDESC5'),
            'sFieldName'     => 'D3LONGDESC5', // oxlongdesc5 -> OXLONGDESC5 -> D3LONGDESC5
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESCTITLE'  => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => 'OXLONGDESCTITLE',
            'sFieldName'     => 'D3LONGDESCTITLE', // OXLONGDESCTITLE -> D3LONGDESCTITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC2TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc2title', 'OXLONGDESC2TITLE'),
            'sFieldName'     => 'D3LONGDESC2TITLE', // oxlongdesc2title -> OXLONGDESC2TITLE -> D3LONGDESC2TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC3TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc3title', 'OXLONGDESC3TITLE'),
            'sFieldName'     => 'D3LONGDESC3TITLE', // oxlongdesc3title -> OXLONGDESC3TITLE -> D3LONGDESC3TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC4TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc4title', 'OXLONGDESC4TITLE'),
            'sFieldName'     => 'D3LONGDESC4TITLE', // oxlongdesc4title -> OXLONGDESC4TITLE -> D3LONGDESC4TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC5TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc5title', 'OXLONGDESC5TITLE'),
            'sFieldName'     => 'D3LONGDESC5TITLE', // oxlongdesc5title -> OXLONGDESC5TITLE -> D3LONGDESC5TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
    );

    protected $_aRefreshMetaModuleIds = array('d3contenttabs');

    public $aOldModuleFiles = array(
        'd3/d3contenttabs/d3_contentTabs_stub.php',
        'd3/d3contenttabs/models/d3_contentTabs_update.php',
        'd3/d3contenttabs/modules/controllers/d3_details_contenttabs.php',
        'd3/d3contenttabs/modules/models/d3_oxarticle_longtexts.php',
        'd3/d3contenttabs/views/azure/tpl/page/details/inc/d3_ajax_content_tab_1.tpl',
        'd3/d3contenttabs/views/azure/tpl/page/details/inc/d3_ajax_content_tab_2.tpl',
        'd3/d3contenttabs/views/azure/tpl/page/details/inc/d3_ajax_content_tab_3.tpl',
        'd3/d3contenttabs/views/azure/tpl/page/details/inc/d3_ajax_content_tab_4.tpl',
        'd3/d3contenttabs/views/azure/tpl/page/details/inc/d3_ajax_content_tab_5.tpl',
        // alte Verzeichnisse (werden zustzlich auf empty geprft, bevor eine Lschung stattfindet)
        'd3/d3contenttabs/modules/models',
        'd3/d3contenttabs/modules/controllers',
        'd3/d3contenttabs/models',
        // umstrukturierung aufgrund mobile anpassung
        'd3/d3contenttabs/views/blocks/details_tabs_longdescription.tpl',
        'd3/d3contenttabs/views/blocks',
        'd3/d3contenttabs/views/azure/tpl/d3contenttabs_tab1.tpl',
        'd3/d3contenttabs/views/azure/tpl/d3contenttabs_tab2.tpl',
        'd3/d3contenttabs/views/azure/tpl/d3contenttabs_tab3.tpl',
        'd3/d3contenttabs/views/azure/tpl/d3contenttabs_tab4.tpl',
        'd3/d3contenttabs/views/azure/tpl/d3contenttabs_tab5.tpl'
    );


    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                    'oxnewrevision' => $this->sModRevision,
                );

                if ($this->_checkTableItemNotExist('d3_cfg_mod', $aWhere)) {
                    // update don't use this property
                    unset($aWhere['oxnewrevision']);

                    $aInsertFields = array(
                        'OXID'           => array(
                            'content'      => "md5('" . $this->sModKey . " " . $oShop->getId() . "')",
                            'force_update' => false,
                            'use_quote'    => false,
                        ),
                        'OXSHOPID'       => array(
                            'content'      => $oShop->getId(),
                            'force_update' => false,
                            'use_quote'    => true,
                        ),
                        'OXMODID'        => array(
                            'content'      => $this->sModKey,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXNAME'         => array(
                            'content'      => $this->sModName,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXACTIVE'       => array(
                            'content'      => "0",
                            'force_update' => false,
                            'use_quote'    => false,
                        ),
                        'OXBASECONFIG'   => array(
                            'content'      => $this->sBaseConf,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXINSTALLDATE'  => array(
                            'content'      => "NOW()",
                            'force_update' => true,
                            'use_quote'    => false,
                        ),
                        'OXVERSION'      => array(
                            'content'      => $this->sModVersion,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXSHOPVERSION'  => array(
                            'content'      => oxRegistry::getConfig()->getEdition(),
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXREQUIREMENTS' => array(
                            'content'      => $this->sRequirements,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                        'OXVALUE'        => array(
                            'content'      => $this->sBaseValue,
                            'force_update' => false,
                            'use_quote'    => true,
                        ),
                        'OXNEWREVISION'  => array(
                            'content'      => $this->sModRevision,
                            'force_update' => true,
                            'use_quote'    => true,
                        ),
                    );
                    $aRet          = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
                    $blRet         = $aRet['blRet'];
                    $this->setActionLog('SQL', $aRet['sql'], __METHOD__);
                    $this->setUpdateBreak(false);

                    if ($this->getStepByStepMode()) {
                        break;
                    }
                }
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkModCfgSameRevision()
    {
        return $this->_checkModCfgSameRevision($this->sModKey);
    }

    /**
     * @return bool
     */
    public function updateModCfgSameRevision()
    {
        $blRet = false;

        if ($this->checkModCfgSameRevision($this->sModKey)) {
            $aRet = $this->_updateModCfgSameRevision($this->sModKey);

            $this->setActionLog('SQL', $aRet['sql'], __METHOD__);
            $this->setUpdateBreak(false);
            $blRet = $aRet['blRet'];
        }

        return $blRet;
    }
}
