<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @link          http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'             => 'd3contenttabs',
    'title'          => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Content Tabs',
    'description'    => array(
        'de' => 'Dieses Modul bietet die M&ouml;glichkeit umfangreiche Artikelinformationen, auf der ' //
            . 'Detailseite, &uuml;bersichtlich aufzugliedern.<br>Sie sehen dieses Modul auch bei uns im Shop. ' //
            . 'Sie k&ouml;nnen z.B. bei diesem Modul zwischen den Tabs "Beschreibung", "Features" und ' //
            . '"Screenshots" w&auml;hlen.',
        'en' => '',
    ),
    'thumbnail'      => 'picture.png',
    'version'        => '3.2.0.1',
    'author'         => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'url'            => 'http://www.shopmodule.com',
    'email'          => 'support@shopmodule.com',
    'extend'         => array(
        'oxwarticledetails' => 'd3/d3contenttabs/modules/application/components/widgets/d3_oxwarticledetails_contenttabs',
        'oxarticle'         => 'd3/d3contenttabs/modules/application/models/d3_oxarticle_longtexts',
        'oxviewconfig'      => 'd3/d3contenttabs/modules/core/d3_oxviewconfig_theme',
    ),
    'files'          => array(
        'd3_longtexts'                              => 'd3/d3contenttabs/application/controllers/admin/d3_longtexts.php',
        'd3_contentTabs_application_models_handler' => 'd3/d3contenttabs/application/models/handler.php',
        'd3_contentTabs_update'                     => 'd3/d3contenttabs/setup/d3_contentTabs_update.php',
    ),
    'templates'      => array(
        'd3_longtexts.tpl'       => 'd3/d3contenttabs/views/admin/tpl/d3_longtexts.tpl',
        'd3contenttabs_tab1.tpl' => 'd3/d3contenttabs/views/tpl/d3contenttabs_tab1.tpl',
        'd3contenttabs_tab2.tpl' => 'd3/d3contenttabs/views/tpl/d3contenttabs_tab2.tpl',
        'd3contenttabs_tab3.tpl' => 'd3/d3contenttabs/views/tpl/d3contenttabs_tab3.tpl',
        'd3contenttabs_tab4.tpl' => 'd3/d3contenttabs/views/tpl/d3contenttabs_tab4.tpl',
        'd3contenttabs_tab5.tpl' => 'd3/d3contenttabs/views/tpl/d3contenttabs_tab5.tpl',
    ),
    'events'         => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'blocks'         => array(
        // azure / flow blocks
        array(
            'template' => 'page/details/inc/tabs.tpl',
            'block'    => 'details_tabs_longdescription',
            'file'     => 'views/blocks/details_tabs_longdescription.tpl',
        ),
        // mobile blocks
        array(
            'template' => 'page/details/inc/fullproductinfo.tpl',
            'block'    => 'd3_content_tabs_mobile',
            'file'     => 'views/mobile/blocks/d3_fullproductinfo_content_tabs_mobile.tpl',
        ),
    ),
    'settings'       => array(),
    'd3FileRegister' => array(
        'd3/d3contenttabs/metadata.php',
        'd3/d3contenttabs/IntelliSenseHelper.php',
        'd3/d3contenttabs/views/admin/de/d3_contenttabs_lang.php',
        'd3/d3contenttabs/translations/de/d3_contenttabs_lang.php',
        'd3/d3contenttabs/application/views/admin/de/d3_contenttabs_lang.php',
        'd3/d3contenttabs/application/translations/de/d3_contenttabs_lang.php',
        'd3/d3contenttabs/views/blocks/details_tabs_longdescription.tpl',
        'd3/d3contenttabs/views/mobile/blocks/d3_fullproductinfo_content_tabs_mobile.tpl',
    ),
);
