<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

/**
 * Class d3_oxviewconfig_theme
 */
class d3_oxviewconfig_theme extends d3_oxviewconfig_theme_parent
{
    /**
     * Active theme name
     *
     * @var null
     */
    protected $_sD3BaseTheme = null;

    /**
     * Returns active theme / parent theme name
     * @deprecated It will be moved to module-connector
     *
     * @param  bool $loadParentThemeID
     * @return string
     */
    public function d3GetBaseThemeId($loadParentThemeID = true)
    {
        if ($this->_sD3BaseTheme === null) {
            /** @var oxTheme $oTheme */
            $oTheme = oxNew('oxTheme');
            $oTheme->load($oTheme->getActiveThemeId());

            // wenn kein ParentTheme, Return === NULL
            if (false == $loadParentThemeID || $oTheme->getParent() == null) {
                $this->_sD3BaseTheme = $oTheme->getActiveThemeId();
            } else {
                $oParentTheme        = $oTheme->getParent();
                $this->_sD3BaseTheme = $oParentTheme->getId();
            }
        }

        return $this->_sD3BaseTheme;
    }
}
