<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class d3_contentTabs_update extends d3install_updatebase
{
    public $sModKey = 'd3contenttabs';

    public $sModName = 'Content Tabs';

    public $sModVersion = '3.2.0.1';

    public $sModRevision = '165';

    public $sBaseConf = 'ntfL0VMUXRydnUwL1liV1N0bkozc1M1d25DZDVtL2xvMTJvemxSTndUN1RTUUQ3MmtYNTFuaTZMOHM0R
zlzeWdNWGI0UkpkWTQwZ25YZkQ1YmYvSWwrek5RRFFVd0JtSTdFZGJhdHBSU05LMExvNHpSTEZqVHY1e
Ct5OERGck9HUXpBampnWXlrREFndGxlbVpjWS9Yd2hFWlRsVzh1T3NMNGxxQ1JCY21yaWNtUlNtd2VHY
U9NRjNiMklHbEFJMk9QWVdHSHRoekhOQXpneWFrSkNyWWIwM1NlY2d1bXVoMzhVNkVRUllESUp1SFB2R
EJMRlhuMGZhTUNWd2tDMkxoR0NWSjZiKzBpUlVNYVpJNTVVQmtPaGExeDJqekJFdUZ3VVRBaDJUMEk5d
Xl4VWliMTFLOWI3OWRsa1g2WDdVWDVZa3VjVU5STCtJd3RVeERoS2R2YklRPT0=';

    /**
     * minimale Modul-Connector Versionsprfung fr die Installation
     */
    public $sMinModCfgVersion = '4.4.1.0';

    public $sRequirements = '';

    public $sBaseValue = '';

    protected $_aUpdateMethods = array(
        array(
            'check' => 'checkModCfgItemExist',
            'do'    => 'updateModCfgItemExist'
        ),
        array(
            'check' => 'checkRenameFields',
            'do'    => 'fixRenameFields'
        ),
        array(
            'check' => 'checkFields',
            'do'    => 'fixFields'
        ),
        array(
            'check' => 'hasOldModuleItems',             // alte oxconfig-Eintrge vorhanden?
            'do'    => 'deleteOldModuleItems'
        ),
        array(
            'check' => 'hasUnregisteredFiles',          // gltige Modul-Dateien prfen - see metadata.php d3FileRegister
            'do'    => 'showUnregisteredFiles'
        ),
        array(
            'check' => 'checkModCfgSameRevision',
            'do'    => 'updateModCfgSameRevision'
        ),
    );

    public $aFields = array(
        'D3LONGDESC2'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC2', //oxlongdesc2 -> OXLONGDESC2 -> D3LONGDESC2 (Type: TEXT)
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC3'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC3', // oxlongdesc3 -> OXLONGDESC3 -> D3LONGDESC3
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC4'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC4', // oxlongdesc4 -> OXLONGDESC4 -> D3LONGDESC4
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC5'      => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3LONGDESC5', // oxlongdesc5 -> OXLONGDESC5 -> D3LONGDESC5
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESCTITLE'  => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESCTITLE', // OXLONGDESCTITLE -> D3LONGDESCTITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC2TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC2TITLE', // oxlongdesc2title -> OXLONGDESC2TITLE -> D3LONGDESC2TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC3TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC3TITLE', // oxlongdesc3title -> OXLONGDESC3TITLE -> D3LONGDESC3TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC4TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC4TITLE', // oxlongdesc4title -> OXLONGDESC4TITLE -> D3LONGDESC4TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
        'D3LONGDESC5TITLE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3LONGDESC5TITLE', // oxlongdesc5title -> OXLONGDESC5TITLE -> D3LONGDESC5TITLE
            'sType'       => 'varchar(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'D3 ContentTabs',
            'sExtra'      => '',
            'blMultilang' => true,
            'blAddBreak'  => true,
        ),
    );

    public $aRenameFields = array(
        'D3LONGDESC2'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc2', 'OXLONGDESC2'),
            'sFieldName'     => 'D3LONGDESC2', //oxlongdesc2 -> OXLONGDESC2 -> D3LONGDESC2
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC3'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc3', 'OXLONGDESC3'),
            'sFieldName'     => 'D3LONGDESC3', // oxlongdesc3 -> OXLONGDESC3 -> D3LONGDESC3
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC4'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc4', 'OXLONGDESC4'),
            'sFieldName'     => 'D3LONGDESC4', // oxlongdesc4 -> OXLONGDESC4 -> D3LONGDESC4
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC5'      => array(
            'sTableName'     => 'oxartextends',
            'mOldFieldNames' => array('oxlongdesc5', 'OXLONGDESC5'),
            'sFieldName'     => 'D3LONGDESC5', // oxlongdesc5 -> OXLONGDESC5 -> D3LONGDESC5
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESCTITLE'  => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => 'OXLONGDESCTITLE',
            'sFieldName'     => 'D3LONGDESCTITLE', // OXLONGDESCTITLE -> D3LONGDESCTITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC2TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc2title', 'OXLONGDESC2TITLE'),
            'sFieldName'     => 'D3LONGDESC2TITLE', // oxlongdesc2title -> OXLONGDESC2TITLE -> D3LONGDESC2TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC3TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc3title', 'OXLONGDESC3TITLE'),
            'sFieldName'     => 'D3LONGDESC3TITLE', // oxlongdesc3title -> OXLONGDESC3TITLE -> D3LONGDESC3TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC4TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc4title', 'OXLONGDESC4TITLE'),
            'sFieldName'     => 'D3LONGDESC4TITLE', // oxlongdesc4title -> OXLONGDESC4TITLE -> D3LONGDESC4TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
        'D3LONGDESC5TITLE' => array(
            'sTableName'     => 'oxarticles',
            'mOldFieldNames' => array('oxlongdesc5title', 'OXLONGDESC5TITLE'),
            'sFieldName'     => 'D3LONGDESC5TITLE', // oxlongdesc5title -> OXLONGDESC5TITLE -> D3LONGDESC5TITLE
            'blMultilang'    => true,
            'blAddBreak'     => true,
        ),
    );

    protected $_aRefreshMetaModuleIds = array('d3contenttabs');

    /**
     * @return bool
     */
    public function hasUnregisteredFiles()
    {
        return $this->_hasUnregisteredFiles($this->sModKey, array('d3FileRegister'));
    }

    /**
     * @return bool
     */
    public function showUnregisteredFiles()
    {
        return $this->_showUnregisteredFiles($this->sModKey, array('d3FileRegister'));
    }
}
