<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_extsearch_response extends oxView
{
    private $_sModId = 'd3_extsearch';

    public $oD3SearchHandler;

    public function init()
    {
        startProfile(__METHOD__);

        oxRegistry::getConfig()->setActiveView($this);

        $mArgs = func_get_args();
        $mArgs = array_change_key_case($mArgs[0], CASE_LOWER);

        if (is_array($mArgs) && count($mArgs) && isset($mArgs['fnc'])) {
            call_user_func_array(array($this, $mArgs['fnc']), array($mArgs));
        }

        $this->_addProfiling();

        stopProfile(__METHOD__);
    }

    public function getSuggestContent($aParams)
    {
        startProfile(__METHOD__);

        $sHeader = "Content-Type: text/html; charset=" . oxRegistry::getLang()->translateString('charset');
        // avoid CRLF injections
        $sHeader = str_replace(array("\n", "\r"), '', $sHeader);
        header($sHeader);
        echo $this->_getD3SearchHandler()->suggestGetContent($aParams['searchparam']);

        stopProfile(__METHOD__);
    }

    /**
     * performance, use a class wide instance
     *
     * @return d3_search
     */
    protected function _getD3SearchHandler()
    {
        if (!$this->oD3SearchHandler) {
            $this->oD3SearchHandler = oxNew('d3_search');
        }

        return $this->oD3SearchHandler;
    }

    protected function _addProfiling()
    {
        startProfile(__METHOD__);

        /** @var d3_cfg_mod $oModCfg */
        $oModCfg = d3_cfg_mod::get($this->_sModId);
        $oModCfg->d3getLog()->d3GetProfiling();

        stopProfile(__METHOD__);
    }

    /**
     * @return string
     */
    public function d3getFilterPageId()
    {
        $mArgs = func_get_args();

        $sPageId = "search##".
            oxRegistry::getLang()->getLanguageAbbr()."##".
            oxRegistry::getConfig()->getShopId()."##".
            md5(rawurlencode(strtolower($mArgs['searchParam'])));

        return $sPageId;
    }
}
