<?php
 /**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <ds@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_manufacturerlist_extsearch extends d3_manufacturerlist_extsearch_parent
{
    protected $_oXListController;
    protected $_sSearchCategory;
    protected $_sSearchVendor;
    protected $_sSearchManufacturer;
    protected $_sD3AdditionalParams = null;
    private $_blUseAlistFilter;

    /**
     * @return string
     */
    public function render()
    {
        $this->d3GetXListController()->render();

        return parent::render();
    }

    /**
     * @param oxmanufacturer $oCategory
     *
     * @return oxArticleList|array
     */
    protected function _loadArticles($oCategory)
    {
        /** @var oxarticlelist $oArtList */
        $mArtList = parent::_loadArticles($oCategory);

        if (is_array($mArtList)) {
            $aKeys = array_keys($mArtList);
            $oArtList = $mArtList[$aKeys[0]];
        } else {
            $oArtList = $mArtList;
        }

        if ($oArtList && $oArtList->count()) {
            $this->d3GetXListController()->addAListFilters($oCategory);
        }

        $this->d3GetXListController()->setTplParams();

        return $mArtList;
    }

    /**
     * @return bool|string
     */
    public function getSearchCategory()
    {
        if ($this->_sSearchCategory === null) {
            $this->_sSearchCategory = rawurldecode($this->getConfig()->getRequestParameter('searchcnid'));
        }

        return $this->_sSearchCategory;
    }

    /**
     * @return bool|string
     */
    public function getSearchVendor()
    {
        if ($this->_sSearchVendor === null) {
            $this->_sSearchVendor = rawurldecode($this->getConfig()->getRequestParameter('searchvendor'));
        }

        return $this->_sSearchVendor;
    }

    /**
     * @return bool|string
     */
    public function getSearchManufacturer()
    {
        if ($this->_sSearchManufacturer === null) {
            $this->_sSearchManufacturer = rawurldecode($this->getConfig()->getRequestParameter('searchmanufacturer'));
        }

        return $this->_sSearchManufacturer;
    }

    /**
     * defines the presentment type, disabled in admin panel
     *
     * @return string
     */
    public function getSearchViewListType()
    {
        if ($this->d3GetSet()->getValue('sExtSearch_ListType')) {
            return $this->d3GetSet()->getValue('sExtSearch_ListType');
        }

        return 'dropdown';
    }

    /**
     * @param string $sUrl
     * @param int    $iPage
     * @param null   $iLang
     *
     * @return string
     */
    protected function _addPageNrParam($sUrl, $iPage, $iLang = null)
    {
        if (false == $this->_d3UseAlistFilters()) {
            return parent::_addPageNrParam($sUrl, $iPage, $iLang);
        }

        $sUrl = parent::_addPageNrParam($sUrl, $iPage, $iLang);

        $sUrlAdd = $this->getViewDataElement('additionalparams');

        if ($sUrlAdd) {
            $sUrl .= ((strpos($sUrl, '?') === false) ? '?' : '') . $sUrlAdd;
        }

        return $sUrl;
    }

    /**
     * returns additional url params for dynamic url building
     *
     * @return string
     */
    public function getDynUrlParams()
    {
        $sRet = parent::getDynUrlParams();

        if ($this->_d3UseAlistFilters()) {
            $sRet .= $this->d3GetXListController()->d3AddBaseUrlParams($sRet);
        }

        return $sRet;
    }

    /**
     * Returns additional URL parameters which must be added to list products urls
     *
     * @return string
     */
    public function getAddUrlParams()
    {
        $sAddParams = parent::getAddUrlParams();

        if ($this->_d3UseAlistFilters()) {
            $sAddParams .= $this->d3GetXListController()->d3AddBaseUrlParams($sAddParams);
        }

        return $sAddParams;
    }

    /**
     * Returns additional URL parameters which must be added to list products seo urls
     */
    public function getAddSeoUrlParams()
    {
        $sAddParams = parent::getAddUrlParams();

        if ($this->_d3UseAlistFilters()) {
            $sAddParams .= $this->d3GetXListController()->d3AddBaseUrlParams($sAddParams);
        }

        return $sAddParams;
    }

    /**
     * Returns array of params => values which are used in hidden forms and as additional url params
     *
     * @return array
     */
    public function getNavigationParams()
    {
        $aParams = parent::getNavigationParams();

        $aParams = $this->d3GetXListController()->addNavigationParams($aParams);

        return $aParams;
    }

    /**
     * @return string
     */
    public function getAdditionalParams()
    {
        $this->_sAdditionalParams = parent::getAdditionalParams();

        if ($this->d3GetSet()->isActive()) {
            $this->_sAdditionalParams .= $this->d3GetXListController()->getD3AdditionalParams();

            if (!strstr($this->_sAdditionalParams, '&amp;isextsearch=') &&
                (
                    count($this->d3GetAttributeFilters()) ||
                    $this->getSearchManufacturer() || count($this->d3GetManufacturerMultiFilter()) ||
                    $this->getSearchCategory() || count($this->d3GetCategoryMultiFilter()) ||
                    $this->getSearchVendor() || count($this->d3GetVendorMultiFilter()) ||
                    count($this->d3GetPriceFilters()))
            ) {
                $this->_sAdditionalParams .= '&amp;isextsearch=alist';
            }
        }

        return $this->_sAdditionalParams;
    }

    /**
     * @return string
     */
    public function d3getFilterPageId()
    {
        return $this->d3GetXListController()->d3getFilterPageId();
    }

    /**
     * @return d3_cfg_mod
     */
    public function d3GetSet()
    {
        return $this->d3GetXListController()->d3GetSet();
    }

    /**
     * @return d3_oxsearch_extsearch
     */
    protected function _d3GetSearchHandler()
    {
        return $this->d3GetXListController()->d3GetSearchHandler();
    }

    /**
     * @return d3_search
     */
    protected function _d3GetOwnSearchHandler()
    {
        return $this->d3GetXListController()->d3GetOwnSearchHandler();
    }

    /**
     * @return array
     */
    public function d3GetCategoryMultiFilter()
    {
        return $this->d3GetXListController()->d3GetCategoryMultiFilter();
    }

    /**
     * @return array
     */
    public function d3GetVendorMultiFilter()
    {
        return $this->d3GetXListController()->d3GetVendorMultiFilter();
    }

    /**
     * @return array
     */
    public function d3GetManufacturerMultiFilter()
    {
        return $this->d3GetXListController()->d3GetManufacturerMultiFilter();
    }

    /**
     * @return array
     */
    public function d3GetAttributeFilters()
    {
        return $this->d3GetXListController()->d3GetAttributeFilters();
    }

    /**
     * @return array
     */
    public function d3GetPriceSelectors()
    {
        return $this->d3GetXListController()->d3GetPriceSelectors();
    }

    /**
     * @return array
     */
    public function d3GetPriceFilters()
    {
        return $this->d3GetXListController()->d3GetPriceFilters();
    }

    /**
     * @return array
     */
    public function d3GetCategoryList()
    {
        return $this->d3GetXListController()->d3GetCategoryList();
    }

    /**
     * @return array
     */
    public function d3GetVendorList()
    {
        return $this->d3GetXListController()->d3GetVendorList();
    }

    /**
     * @return array
     */
    public function d3GetManufacturerList()
    {
        return $this->d3GetXListController()->d3GetManufacturerList();
    }

    /**
     * @return array
     */
    public function d3GetAttributeList()
    {
        return $this->d3GetXListController()->d3GetAttributeList();
    }

    /**
     * @param $sAttrId
     * @return bool
     */
    public function d3AttributeFilterUseMultipleValues($sAttrId)
    {
        return $this->d3GetXListController()->d3AttributeFilterUseMultipleValues($sAttrId);
    }

    /**
     * @return array
     */
    public function d3CategoryFilterUseMultipleValues()
    {
        return $this->d3GetXListController()->d3CategoryFilterUseMultipleValues();
    }

    /**
     * @return array
     */
    public function d3VendorFilterUseMultipleValues()
    {
        return $this->d3GetXListController()->d3VendorFilterUseMultipleValues();
    }

    /**
     * @return array
     */
    public function d3ManufacturerFilterUseMultipleValues()
    {
        return $this->d3GetXListController()->d3ManufacturerFilterUseMultipleValues();
    }

    /**
     * @return array
     */
    public function d3getPriceSteps()
    {
        return $this->d3GetXListController()->d3getPriceSteps();
    }

    /**
     * @return array
     */
    public function d3HasjQuerySlider()
    {
        return $this->d3GetXListController()->d3HasjQuerySlider();
    }

    /**
     * @return array
     */
    public function d3GetDeselectValue()
    {
        return $this->d3GetXListController()->d3GetDeselectValue();
    }

    /**
     * @param $sOptionTitle
     * @return string
     */
    public function d3GetMultipleSelectionTranslation($sOptionTitle)
    {
        return $this->d3GetXListController()->d3GetMultipleSelectionTranslation($sOptionTitle);
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderInfoMinValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderInfoMinValue();
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderInfoMaxValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderInfoMaxValue();
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderInputMinValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderInputMinValue();
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderInputMaxValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderInputMaxValue();
    }

    /**
     * @return array
     */
    public function d3getPriceLimits()
    {
        return $this->d3GetXListController()->d3getPriceLimits();
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderOriginalMinValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderOriginalMinValue();
    }

    /**
     * @return array
     */
    public function d3GetPriceSliderOriginalMaxValue()
    {
        return $this->d3GetXListController()->d3GetPriceSliderOriginalMaxValue();
    }

    /**
     * @return array
     */
    public function d3ClearFilter()
    {
        return $this->d3GetXListController()->d3ClearFilter();
    }

    /**
     * @return bool
     */
    private function _d3UseAlistFilters()
    {
        if (null === $this->_blUseAlistFilter) {
            $this->_blUseAlistFilter = $this->d3GetSet()->isActive()
                && ($this->d3GetSet()->getLicenseConfigData('blUseFilterInArticleLists', false) || $this->d3GetSet()->isDemo())
                && $this->d3GetSet()->getValue('blExtSearch_useAListFilter');
        }
        return $this->_blUseAlistFilter;
    }

    public function d3GetXListController()
    {
        if (false == $this->_oXListController) {
            $this->_oXListController = oxNew('d3_xlist_extsearch', $this);
        }
        return $this->_oXListController;
    }

    /**
     * checks if this view can be cached
     * @return bool
     * @throws d3ShopCompatibilityAdapterException
     * @throws d3_cfg_mod_exception
     */
    public function canCache()
    {
        $canCache = parent::canCache();

        if ($canCache &&
            // need function check, because canCache is called before the filters are reset
            strtolower(oxRegistry::getConfig()->getRequestParameter('fnc')) !== 'd3clearfilter' &&
            count($this->d3GetXListController()->getAllSelections())
        ) {
            $canCache = false;
        }

        return $canCache;
    }
}
