<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

/**
 * Class d3_extsearch_update
 */
class d3_extsearch_update extends d3install_updatebase
{
    public $sModKey = 'd3_extsearch';
    public $sModName = 'erweiterte Suche';
    public $sModVersion = '5.5.2.0';
    public $sModRevision = '1040';
    public $sBaseConf = 'ix3aDJjbmV0R2ZYbVZ5Qko0NmhyOWFDODhubFhvYlhoMnV6QnduWEZiZmF2endHazc5V00zWGN6dkJUO
DBjYTFzbmpsYkFCTEt5a1VFNXJ4OXM2TVUvdCtPUFczOUtiRUZ4ekxGMU45VmEwM3dQeVZjYnVJSHJ2V
XQ5OTA5RnBWNURLVWhraUhHcmUyanpHckg0NW9IcW1BcFhGZG1WczQ5TTd6STBwRS8vR2ZvSEp1a0xRU
05KNkIvU3dGc3gybUlWaE81Njg5RUJ0QjJoeCtqVW5LeTk0ajAxNTdQb1J3TUdaZ25tMlUydlAyVGdwd
nlQVTNQenZaQlgzeVV0dHFwNEtqWk0xcHIvZWdMT2swSHJoZ1dzRjkxVzI4M1RaOXN3eGtkdXZ3MjVkT
DQ9';
    public $sRequirements = '';
    public $sBaseValue = 'TyUzQTglM0ElMjJzdGRDbGFzcyUyMiUzQTU5JTNBJTdCcyUzQTI4JTNBJTIyZDNfY2ZnX21vZF9fYUxp
Y2Vuc2VJbmZvTWFpbCUyMiUzQmElM0EyJTNBJTdCcyUzQTQyJTNBJTIyTk9MSUNLRVlfXzQ3OTM2Mzg3MDJiNjc3MTVmMWRmYmZjOD
MyNDY2OTE0JTIyJTNCcyUzQTE5JTNBJTIyMjAxMy0wMS0xNiUyMDEyJTNBMTAlM0E0MCUyMiUzQnMlM0E0NCUzQSUyMk5PU0VSSUFM
SURfXzQ3OTM2Mzg3MDJiNjc3MTVmMWRmYmZjODMyNDY2OTE0JTIyJTNCcyUzQTE5JTNBJTIyMjAxMy0wMS0xNiUyMDEyJTNBMTElM0
E0MiUyMiUzQiU3RHMlM0E0MiUzQSUyMmQzX2NmZ19tb2RfX2FFeHRTZWFyY2hfc2ltaWxhclNlYXJjaEZpZWxkcyUyMiUzQmElM0E0
JTNBJTdCaSUzQTAlM0JzJTNBMTQlM0ElMjI1MCUyMCUzRCUzRSUyMG94YXJ0bnVtJTIyJTNCaSUzQTElM0JzJTNBMTMlM0ElMjI1MC
UyMCUzRCUzRSUyMG94dGl0bGUlMjIlM0JpJTNBMiUzQnMlM0ExOCUzQSUyMjQwJTIwJTNEJTNFJTIwb3hzZWFyY2hrZXlzJTIyJTNC
aSUzQTMlM0JzJTNBMTclM0ElMjIyMCUyMCUzRCUzRSUyMG94c2hvcnRkZXNjJTIyJTNCJTdEcyUzQTQzJTNBJTIyZDNfY2ZnX21vZF
9fc0V4dFNlYXJjaF9NdWx0aVNlYXJjaHdvcmRVc2FnZSUyMiUzQnMlM0ExMCUzQSUyMnNpbmdsZVdvcmQlMjIlM0JzJTNBMzklM0El
MjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF91c2VBcnROdW1TZWFyY2glMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzklM0ElMj
JkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9vcmRlckJ5UHJpb3JpdHklMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzUlM0ElMjJk
M19jZmdfbW9kX19ibEV4dFNlYXJjaF9vcmRlckJ5UHVzaCUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0NCUzQSUyMmQzX2NmZ1
9tb2RfX2JsRXh0U2VhcmNoX2ZpbmRQdXRJbkFuZExlYXZlT3V0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTM3JTNBJTIyZDNf
Y2ZnX21vZF9fYmxFeHRTZWFyY2hfb3duRm9ybUZpZWxkcyUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzNyUzQSUyMmQzX2NmZ1
9tb2RfX2JsRXh0U2VhcmNoX1ZhcmlhbnRTZWFyY2glMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzUlM0ElMjJkM19jZmdfbW9k
X19zRXh0U2VhcmNoX1ZhcmlhbnRVc2FnZSUyMiUzQnMlM0ExMCUzQSUyMnNob3dQYXJlbnQlMjIlM0JzJTNBMzclM0ElMjJkM19jZm
dfbW9kX19ibEV4dFNlYXJjaF9zaW1pbGFyU2VhcmNoJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTMxJTNBJTIyZDNfY2ZnX21v
ZF9fc0V4dFNlYXJjaF9sYW5nRmlsZSUyMiUzQnMlM0EyMiUzQSUyMmQzX3Bob25ldGljX2RlX3ZvYy5waHAlMjIlM0JzJTNBMzglM0
ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaW1pbGFyRXh0TGlzdCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzNyUzQSUy
MmQzX2NmZ19tb2RfX2lFeHRTZWFyY2hfc2ltaWxhckV4dExpc3QlMjIlM0JzJTNBMiUzQSUyMjEwJTIyJTNCcyUzQTM2JTNBJTIyZD
NfY2ZnX21vZF9faUV4dFNlYXJjaF9taW5QaG9uTGVuZ3RoJTIyJTNCcyUzQTElM0ElMjIyJTIyJTNCcyUzQTM4JTNBJTIyZDNfY2Zn
X21vZF9fYmxFeHRTZWFyY2hfc2VtYW50aWNTZWFyY2glMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBNDMlM0ElMjJkM19jZmdfbW
9kX19ibEV4dFNlYXJjaF9zZW1hbnRpY1VzZVBob25ldGljJTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTQzJTNBJTIyZDNfY2Zn
X21vZF9fYmxFeHRTZWFyY2hfc2VtYW50aWNBbGxvd1Z1bGdhciUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzMyUzQSUyMmQzX2
NmZ19tb2RfX2JsRXh0U2VhcmNoX2NhdFNlYXJjaCUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0EzOCUzQSUyMmQzX2NmZ19tb2Rf
X3NFeHRTZWFyY2hfc2hvd0NhdEFydGljbGVzJTIyJTNCcyUzQTglM0ElMjJhcnRpbmNhdCUyMiUzQnMlM0EzMCUzQSUyMmQzX2NmZ1
9tb2RfX2lFeHRTZWFyY2hfY2F0UHJpbyUyMiUzQnMlM0EyJTNBJTIyNTAlMjIlM0JzJTNBNDIlM0ElMjJkM19jZmdfbW9kX19ibEV4
dFNlYXJjaF9tYW51ZmFjdHVyZXJTZWFyY2glMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19pRX
h0U2VhcmNoX21hbnVmYWN0dXJlclByaW8lMjIlM0JzJTNBMiUzQSUyMjUwJTIyJTNCcyUzQTM5JTNBJTIyZDNfY2ZnX21vZF9fYmxF
eHRTZWFyY2hfc2hvd0NvbnRlbnRMaXN0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fYmxFeH
RTZWFyY2hfY29udGVudFNlYXJjaExvbmd0ZXh0JTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTM0JTNBJTIyZDNfY2ZnX21vZF9f
YmxFeHRTZWFyY2hfbG9nSGl0bGVzcyUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0NSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2
VhcmNoX2dlbmVyYWxseUxvZ0ZvclNlYXJjaCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0E0MSUzQSUyMmQzX2NmZ19tb2RfX2Js
RXh0U2VhcmNoX2FkbWluU2hvd1ZhcmlhbnRzJTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTM4JTNBJTIyZDNfY2ZnX21vZF9faU
V4dFNlYXJjaF9hcnRpY2xlc1BlclRpY2slMjIlM0JzJTNBMiUzQSUyMjEwJTIyJTNCcyUzQTM1JTNBJTIyZDNfY2ZnX21vZF9fYmxF
eHRTZWFyY2hfZW1wdHlTZWFyY2glMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBNDMlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYX
JjaF9zaG93SGlnaGxpZ2h0ZWRUZXh0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTM3JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRT
ZWFyY2hfZ29Ub1VuaXF1ZUhpdCUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0EzNSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2Vhcm
NoX3Nob3dDYXRMaXN0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTM1JTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9vcmRl
ckNhdExpc3QlMjIlM0JzJTNBNyUzQSUyMmNvdW50ZXIlMjIlM0JzJTNBNDIlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG
93T25lSXRlbUNhdExpc3QlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzglM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9z
aG93VmVuZG9yTGlzdCUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0EzOCUzQSUyMmQzX2NmZ19tb2RfX3NFeHRTZWFyY2hfb3JkZX
JWZW5kb3JMaXN0JTIyJTNCcyUzQTclM0ElMjJjb3VudGVyJTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hf
c2hvd09uZUl0ZW1WZW5kb3JMaXN0JTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTQ0JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZW
FyY2hfc2hvd01hbnVmYWN0dXJlckxpc3QlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBNDQlM0ElMjJkM19jZmdfbW9kX19zRXh0
U2VhcmNoX29yZGVyTWFudWZhY3R1cmVyTGlzdCUyMiUzQnMlM0E3JTNBJTIyY291bnRlciUyMiUzQnMlM0E1MSUzQSUyMmQzX2NmZ1
9tb2RfX2JsRXh0U2VhcmNoX3Nob3dPbmVJdGVtTWFudWZhY3R1cmVyTGlzdCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0E0MSUz
QSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX3Nob3dBdHRyaWJ1dGVMaXN0JTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTQxJT
NBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9vcmRlckF0dHJpYnV0ZUxpc3QlMjIlM0JzJTNBNyUzQSUyMmNvdW50ZXIlMjIlM0Jz
JTNBNTUlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93Tm9Bc3NpZ25lZEF0dHJpYnV0ZUFydGljbGVzJTIyJTNCcyUzQT
ElM0ElMjIwJTIyJTNCcyUzQTQxJTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfc2hvd1ByaWNlU2VsZWN0b3IlMjIlM0JzJTNB
MSUzQSUyMjElMjIlM0JzJTNBNDElM0ElMjJkM19jZmdfbW9kX19pRXh0U2VhcmNoX3ByaWNlU2VsZWN0b3JJdGVtcyUyMiUzQnMlM0
ExJTNBJTIyNSUyMiUzQnMlM0E0NSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX1ByaWNlU2VsZWN0b3JzUm91bmRlZCUyMiUz
QnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0NSUzQSUyMmQzX2NmZ19tb2RfX3NFeHRTZWFyY2hfUHJpY2VTZWxlY3RvcnNEaXNwVHlwZS
UyMiUzQnMlM0E4JTNBJTIyZHJvcGRvd24lMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93RmlsdGVy
UGFyYW0lMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19zRXh0U2VhcmNoX2ZpbHRlclBhcmFtRm
llbGQlMjIlM0JzJTNBNyUzQSUyMm94dGl0bGUlMjIlM0JzJTNBNDAlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9lbmFibGVB
amF4U2VhcmNoJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9RdWlja1NlYX
JjaE1heEFydGljbGVzJTIyJTNCcyUzQTMlM0ElMjIyMDAlMjIlM0JzJTNBNDklM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9R
dWlja1NlYXJjaExvYWRDYXRlZ29yaWVzJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTUyJTNBJTIyZDNfY2ZnX21vZF9fYmxFeH
RTZWFyY2hfUXVpY2tTZWFyY2hMb2FkTWFudWZhY3R1cmVycyUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0NiUzQSUyMmQzX2Nm
Z19tb2RfX2JsRXh0U2VhcmNoX1F1aWNrU2VhcmNoTG9hZFZlbmRvcnMlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBNDYlM0ElMj
JkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9RdWlja1NlYXJjaExvYWRDb250ZW50JTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTMx
JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfU2hvd0lBUyUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzMyUzQSUyMmQzX2
NmZ19tb2RfX2JsRXh0U2VhcmNoX1Nob3dQb3B1cCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0E0OCUzQSUyMmQzX2NmZ19tb2Rf
X2JsRXh0U2VhcmNoX1ZhcmlhbnRDaGVja1BhcmVudEFjdGl2ZSUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQiU3RA==';

    protected $_aUpdateMethods = array(
        array('check' => 'checkModCfgItemExist',
              'do'    => 'updateModCfgItemExist'),
        array('check' => 'checkRenameFields',
              'do'    => 'fixRenameFields'),
        array('check' => 'checkDeleteFields',
              'do'    => 'fixDeleteFields'),
        array('check' => 'checkIndexRefreshMsg',
              'do'    => 'fixIndexRefreshMsg'),
        array('check' => 'checkSynsetTablesExist',
              'do'    => 'addSynsetTables'),
        array('check' => 'checkFields',
              'do'    => 'fixFields'),
        array('check' => 'checkIndizes',
              'do'    => 'fixIndizes'),
        array('check' => 'checkContentNoArtItemExist',
              'do'    => 'updateContentNoArtItemExist'),
        array('check' => 'hasUnregisteredFiles',
              'do'    => 'showUnregisteredFiles'),
        array('check' => 'checkModCfgSameRevision',
              'do'    => 'updateModCfgSameRevision'),
    );

    public $aFields = array(
        'D3_PHONETIC'        => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3_PHONETIC',
            'sType'       => 'LONGTEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => true,
        ),
        'D3_SEARCHINDEXDATE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3_SEARCHINDEXDATE',
            'sType'       => 'DATETIME',
            'blNull'      => false,
            'sDefault'    => '0000-00-00 00:00:00',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => true,
        ),
        'D3PUSH'             => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3PUSH',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '1',
            'sComment'    => 'search sort criteria',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3COUNT'            => array(
            'sTableName'  => 'oxlogs',
            'sFieldName'  => 'D3COUNT',
            'sType'       => 'INT(5)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3ISSEARCHABLE'     => array(
            'sTableName'  => 'oxcontents',
            'sFieldName'  => 'D3ISSEARCHABLE',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3NOTUSE4FILTER'    => array(
            'sTableName'  => 'oxattribute',
            'sFieldName'  => 'D3NOTUSE4FILTER',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'attrib use in extsearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3NOTUSE4FILTERCAT'    => array(
            'sTableName'  => 'oxcategories',
            'sFieldName'  => 'D3NOTUSE4FILTER',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'category use in extsearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
    );

    public $aIndizes = array(
        'D3COUNT' => array(
            'sTableName' => 'oxlogs',
            'sType'      => '',
            'sName'      => 'D3COUNT',
            'aFields'    => array(
                'D3COUNT' => 'D3COUNT',
            ),
        ),
    );

    public $aRenameFields = array(
        'D3_PHONETIC'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3_phonetic'), // is case sensitive
           'sFieldName'  => 'D3_PHONETIC',
           'blMultilang' => true,
        ),
        'D3_SEARCHINDEXDATE'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3_searchIndexDate'), // is case sensitive
           'sFieldName'  => 'D3_SEARCHINDEXDATE',
           'blMultilang' => true,
        ),
        'D3PUSH'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3push'), // is case sensitive
           'sFieldName'  => 'D3PUSH',
           'blMultilang' => false,
        ),
        'D3NOTUSE4FILTER'        => array(
           'sTableName'  => 'oxattribute',
           'mOldFieldNames' => array('d3notuse4filter'), // is case sensitive
           'sFieldName'  => 'D3NOTUSE4FILTER',
           'blMultilang' => false,
        ),
    );

    public $aSemanticTables = array();

    public $aOldModuleFiles = array(
        'd3/d3_extsearch/models/d3_extsearch_update.php',
    );

    protected $_aRefreshMetaModuleIds = array('d3_extsearch');

    /**
     * constructor
     */
    public function __construct()
    {
        require_once('d3_extsearch_semanticstructure.php');

        parent::__construct();
    }

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            $this->setInitialExecMethod(__METHOD__);

            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                    'oxnewrevision' => $this->sModRevision,
                );

                if ($this->_checkTableItemNotExist('d3_cfg_mod', $aWhere)) {
                    // update don't use this property
                    unset($aWhere['oxnewrevision']);

                    $aInsertFields = array(
                        'OXID'           => array (
                            'content'       => "md5('" . $this->sModKey . " " . $oShop->getId() . " de')",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXSHOPID'       => array (
                            'content'       => $oShop->getId(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXMODID'        => array (
                            'content'       => $this->sModKey,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXNAME'         => array (
                            'content'       => $this->sModName,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXACTIVE'       => array (
                            'content'       => "0",
                            'force_update'  => false,
                            'use_quote'     => false,
                        ),
                        'OXBASECONFIG'   => array (
                            'content'       => $this->sBaseConf,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSERIAL'   => array (
                            'content'       => "",
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXINSTALLDATE'  => array (
                            'content'       => "NOW()",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXVERSION'      => array (
                            'content'       => $this->sModVersion,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSHOPVERSION'  => array (
                            'content'       => oxRegistry::getConfig()->getEdition(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXREQUIREMENTS' => array (
                            'content'       => $this->sRequirements,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXVALUE'        => array(
                            'content'       => $this->sBaseValue,
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXNEWREVISION'  => array(
                            'content'       => $this->sModRevision,
                            'force_update'  => true,
                            'use_quote'     => true,
                        )
                    );

                    $this->setInitialExecMethod(__METHOD__);
                    $blRet  = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
                }
            }
        }
        return $blRet;
    }

    /**
     * config example:
     *  public $aDeleteFields = array(
     *      'D3_PHONETIC'        => array(
     *          'sTableName'  => 'oxarticles',
     *          'sFieldName'  => 'D3_PHONETIC',
     *          'blMultilang' => true,
     *       ),
     *  );
     *
     * @return bool
     */
    public function checkDeleteFields()
    {
        $blReturn = false;

        $blCS = false; // search is case sensitive

        if ($this->aDeleteFields && is_array($this->aDeleteFields) && count($this->aDeleteFields)) {
            foreach ($this->aDeleteFields as $aField) {
                $iChangeLang = $aField['blMultilang'] ? 15 : 0;
                for ($iLang=$iChangeLang; $iLang >= 0; $iLang--) {
                    $sCheckName = $this->_addMultiLangAddOn($aField['sFieldName'], $iLang);
                    $sMLTableName = getLangTableName($aField['sTableName'], $iLang);
                    $blReturn = $this->_checkTableFieldExist($sMLTableName, $sCheckName, $blCS);

                    if ($blReturn) {
                        return $blReturn;
                    }
                }
            }
        }

        return $blReturn;
    }

    /**
     * config example:
     *  public $aDeleteFields = array(
     *      'D3_PHONETIC'        => array(
     *          'sTableName'  => 'oxarticles',
     *          'sFieldName'  => 'D3_PHONETIC',
     *          'blMultilang' => true,
     *       ),
     *  );
     *
     * @param string $sMethodName
     *
     * @return bool
     */
    public function fixDeleteFields($sMethodName = __METHOD__)
    {
        $blReturn = true;

        if ($this->aDeleteFields && is_array($this->aDeleteFields) && count($this->aDeleteFields)) {
            foreach ($this->aDeleteFields as $aField) {
                $iChangeLang = $aField['blMultilang'] ? 15 : 0;
                for ($iLang=$iChangeLang; $iLang >= 0; $iLang--) {
                    $sCheckName = $this->_addMultiLangAddOn($aField['sFieldName'], $iLang);
                    $sMLTableName = getLangTableName($aField['sTableName'], $iLang);
                    if ($this->_checkTableFieldExist($sMLTableName, $sCheckName, $blCS = false)) {
                        $blReturn = $this->_dropTableField($sMLTableName, $sCheckName, $sMethodName);

                        $sFieldName = 'D3_SEARCHINDEXDATE';
                        $sIndexCheckName = $this->_addMultiLangAddOn($sFieldName, $iLang);

                        if ($this->_checkTableFieldExist($sMLTableName, $sIndexCheckName, $blCS = false)) {
                            $aWhere = array(
                                'oxactive'      => '1',
                            );

                            $aUpdateFields = array(
                                $sIndexCheckName       => array(
                                    'fieldname'    => $sIndexCheckName,
                                    'content'      => '0000-00-00',
                                    'force_update' => true,
                                    'use_quote'    => true,
                                ),
                            );

                            $this->setInitialExecMethod(__METHOD__);
                            $blReturn  = $this->_updateTableItem2($sMLTableName, $aUpdateFields, $aWhere);

                            oxRegistry::getSession()->setVariable('checkIndexRefreshMsg', true);
                        }
                    }
                }
            }
        }

        return $blReturn;
    }

    /**
     * @return bool
     */
    public function checkIndexRefreshMsg()
    {
        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function fixIndexRefreshMsg()
    {
        $blRet = true;

        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            oxRegistry::getSession()->setVariable('checkIndexRefreshMsg', false);
            $this->_confirmMessage('D3_EXTSEARCH_UPDATE_GENPHONETIC');
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkContentNoArtItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('oxcontents', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateContentNoArtItemExist()
    {
        $blRet = false;

        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            if ($this->_checkTableItemNotExist('oxcontents', $aWhere)) {
                $aWhere = array();
                $aInsertFields = array(
                    array (
                        'fieldname'     => 'OXID',
                        'content'       => "md5('d3extsearch_noarticlefound " . $oShop->getId() . "')",
                        'force_update'  => true,
                        'use_quote'     => false,
                    ),
                    array (
                        'fieldname'     => 'OXLOADID',
                        'content'       => "d3extsearch_noarticlefound",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSHOPID',
                        'content'       => $oShop->getId(),
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSNIPPET',
                        'content'       => "1",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXTYPE',
                        'content'       => "0",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXACTIVE',
                        'content'       => "1",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXPOSITION',
                        'content'       => "",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'de'),
                        'content'       => "Leider wurden keine Artikel gefunden",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXCONTENT',
                        'content'       => "<p>Versuchen Sie es mit einem anderen Suchbegriff, einer anderen ".
                            "Schreibweise oder anderen Filtern bitte noch einmal. </p><p>Erhalten Sie dennoch keine ".
                            "Ergebnisse, kontaktieren Sie uns bitte ".
                            "<a href=\"[{oxgetseourl ident=\$oViewConf->getSelfLink()|cat:\"cl=contact\"}]\">hier</a>.".
                            "</p><br />",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'en'),
                        'content'       => "Sorry, no items were found.",
                        'force_update'  => false,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXCATID',
                        'content'       => "kgo83a794223bfd23cbb091d0a34019d",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXFOLDER',
                        'content'       => "CMSFOLDER_USERINFO",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                );

                $this->setInitialExecMethod(__METHOD__);
                $blRet  = $this->_updateTableItem2('oxcontents', $aInsertFields, $aWhere);

                if ($this->getStepByStepMode()) {
                    break;
                }
            }
        }

        return $blRet;
    }

    /**
     * @return bool true, if table is missing
     */
    public function checkSynsetTablesExist()
    {
        foreach ($this->aSemanticTables as $aSemanticTable) {
            if (($blRet = $this->_checkTableNotExist($aSemanticTable['sName']))) {
                return $blRet;
            };
        }

        return false;
    }

    /**
     * @return bool
     */
    public function addSynsetTables()
    {
        $this->setInitialExecMethod(__METHOD__);

        $blDoRet = false;
        foreach ($this->aSemanticTables as $aSemanticTable) {
            if (($blRet = $this->_checkTableNotExist($aSemanticTable['sName']))) {

                if ($this->hasExecute()) {
                    $iCount = $this->getUpdateStepCount();
                    oxRegistry::getSession()->setVariable('iD3UpdatebaseCount', $iCount + 1);
                    oxRegistry::getSession()->setVariable(
                        'sD3UpdatebaseStepDesc',
                        sprintf(
                            oxRegistry::getLang()->translateString('D3_EXTSEARCH_SETUP_ADDTABLE'),
                            $aSemanticTable['sName']
                        )
                    );
                }

                $blDoRet = $this->_addTable2(
                    $aSemanticTable['sName'],
                    $this->aFields,
                    $this->aIndizes,
                    $aSemanticTable['sComment'],
                    $aSemanticTable['sType']
                );

                if ($this->getUpdateBreak() || false == $blDoRet) {
                    return $blDoRet;
                }
            }
        }

        return $blDoRet;
    }

    /**
     * @return bool
     */
    public function hasUnregisteredFiles()
    {
        return $this->_hasUnregisteredFiles('d3_extsearch', array('blocks', 'd3FileRegister'));
    }

    /**
     * @return bool
     */
    public function showUnregisteredFiles()
    {
        return $this->_showUnregisteredFiles('d3_extsearch', array('blocks', 'd3FileRegister'));
    }
}
