<?php

/**
 * Created by PhpStorm.
 * User: danielseifert
 * Date: 17.12.2015
 * Time: 16:12
 */
class d3_rss_extsearch extends d3_rss_extsearch_parent
{
    public $oD3SearchHandler = null;
    protected $_aSelectedAttributes;
    protected $_sD3AdditionalParams = null;
    protected $_sSearchManufacturer;
    protected $_sSearchVendor;

    /**
     * performance, use a class wide instance
     *
     * @return d3_oxsearch_extsearch
     */
    protected function _d3GetSearchHandler()
    {
        if (!$this->oD3SearchHandler) {
            $this->oD3SearchHandler = oxNew('oxsearch');
        }

        return $this->oD3SearchHandler;
    }

    /**
     * @return mixed
     */
    public function d3getFilterPageId()
    {
        if ($this->getConfig()->getConfigParam('bl_rssSearch')) {
            $sClassNameAdd = 'search##';
            $sIdent = md5(rawurlencode(strtolower(oxRegistry::getConfig()->getRequestParameter('searchparam', true))));
        } else {
            $sClassNameAdd = '##';
            $sIdent = oxRegistry::getConfig()->getRequestParameter('cat');
        }

        $sPageId = $sClassNameAdd.
            oxRegistry::getLang()->getLanguageAbbr()."##".
            oxRegistry::getConfig()->getShopId()."##".
            $sIdent;

        return $sPageId;
    }

    /**
     * @return array
     */
    public function getPriceFilters()
    {
        return $this->_d3GetSearchHandler()->getPriceSelectors();
    }

    /**
     * @return array
     */
    public function getAttributeFilters()
    {
        if (null == $this->_aSelectedAttributes) {
            $oSearchHandler = $this->_d3GetSearchHandler();
            $oSearchHandler->setIgnoreSessionAttributes(true);
            $this->_aSelectedAttributes = $this->_d3GetSearchHandler()->getAttributeFilters();
            $oSearchHandler->setIgnoreSessionAttributes(false);

            foreach ($this->_aSelectedAttributes as $sKey => $mValue) {
                if (is_array($mValue) && count($mValue)) {
                    foreach ($mValue as $iIdent => $sValue) {
                        $sAddStr = "&amp;d3searchattribmulti[$sKey][$iIdent]=" . urlencode(trim($sValue));
                        $this->_sD3AdditionalParams .= $sAddStr;
                        /*$this->addTplParam(
                            'additionalparams',
                            $this->getViewDataElement('additionalparams') . $sAddStr
                        );*/
                    }
                } elseif (is_string($mValue) && trim($mValue)) {
                    $sAddStr = "&amp;d3searchattrib[$sKey]=" . urlencode(trim($mValue));
                    $this->_sD3AdditionalParams .= $sAddStr;
                    //$this->addTplParam('additionalparams', $this->getViewDataElement('additionalparams') . $sAddStr);
                }
            }

            $this->addTplParam('aD3AttribFilters', $this->_aSelectedAttributes);
        }

        return $this->_aSelectedAttributes;
    }

    /**
     * @return bool|string
     */
    public function getSearchManufacturer()
    {
        if ($this->_sSearchManufacturer === null) {
            // searching in vendor #671
            $this->_sSearchManufacturer = rawurldecode($this->getConfig()->getRequestParameter('searchmanufacturer'));
        }

        return $this->_sSearchManufacturer;
    }

    /**
     * @return bool|string
     */
    public function getSearchVendor()
    {
        if ($this->_sSearchVendor === null) {
            // searching in vendor #671
            $this->_sSearchVendor = rawurldecode($this->getConfig()->getRequestParameter('searchvendor'));
        }

        return $this->_sSearchVendor;
    }
}