<?php
 /**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <ds@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_details_extsearch extends d3_details_extsearch_parent
{
    public $oD3SearchHandler = null;
    protected $_aSelectedAttributes;

    /**
     * @return array
     */
    public function getNavigationParams()
    {
        $aParams = parent::getNavigationParams();

        $oController = $this->d3GetBaseController();
        $aSearchParams = $oController->getNavigationParams();

        $aParams = array_merge($aSearchParams, $aParams);

        return $aParams;
    }

    /**
     * @return array
     */
    public function d3GetPriceFilters()
    {
        return $this->_d3GetSearchHandler()->getPriceSelectors();
    }

    /**
     * @return array
     */
    public function getAttributeFilters()
    {
        if (null == $this->_aSelectedAttributes) {
            $this->_aSelectedAttributes = $this->_d3GetSearchHandler()->getAttributeFilters();

            /*
            foreach ($this->_aSelectedAttributes as $sKey => $mValue) {
                if (is_array($mValue) && count($mValue)) {
                    foreach ($mValue as $iIdent => $sValue) {
                        $sAddStr = "&amp;d3searchattribmulti[$sKey][$iIdent]=" . urlencode(trim($sValue));
                        //$this->_sD3AdditionalParams .= $sAddStr;
                        //$this->addTplParam(
                        //    'additionalparams',
                        //    $this->getViewDataElement('additionalparams') . $sAddStr
                        //);
                    }
                } elseif (is_string($mValue) && trim($mValue)) {
                    $sAddStr = "&amp;d3searchattrib[$sKey]=" . urlencode(trim($mValue));
                    //$this->_sD3AdditionalParams .= $sAddStr;
                    //$this->addTplParam('additionalparams', $this->getViewDataElement('additionalparams') . $sAddStr);
                }
            }
            */

            $this->addTplParam('aD3AttribFilters', $this->_aSelectedAttributes);
        }

        return $this->_aSelectedAttributes;
    }

    /**
     * performance, use a class wide instance
     *
     * @return d3_oxsearch_extsearch
     */
    protected function _d3GetSearchHandler()
    {
        if (!$this->oD3SearchHandler) {
            $this->oD3SearchHandler = oxNew('oxsearch');
        }

        return $this->oD3SearchHandler;
    }

    /**
     * @return mixed
     */
    public function d3getFilterPageId()
    {
        switch (strtolower($this->getListType())) {
            case 'search':
                $sClassNameAdd = 'search##';
                $sIdent = md5(rawurlencode(strtolower(oxRegistry::getConfig()->getRequestParameter('searchparam', true))));
                break;
            case 'manufacturer':
                $sClassNameAdd = '##';
                $sIdent = oxRegistry::getConfig()->getRequestParameter('mnid');
                break;
            default:
                $sClassNameAdd = '##';
                $sIdent = oxRegistry::getConfig()->getRequestParameter('cnid');
        }

        $sPageId = $sClassNameAdd.
            oxRegistry::getLang()->getLanguageAbbr()."##".
            oxRegistry::getConfig()->getShopId()."##".
            $sIdent;

        return $sPageId;
    }

    /**
     * @return string
     */
    public function getDynUrlParams()
    {
        $sRet = parent::getDynUrlParams();

        $oController = $this->d3GetBaseController();

        if (method_exists($oController, 'd3GetXListController')) {
            $sRet .= $oController->d3GetXListController()->d3AddBaseUrlParams($sRet);
        } else {
            $sRet .= $oController->d3AddBaseUrlParams($sRet);
        }

        return $sRet;
    }

    /**
     * @return d3_ext_search|d3_alist_extsearch|d3_manufacturerlist_extsearch|d3_vendorlist_extsearch
     */
    public function d3GetBaseController()
    {
        $sListType = $this->getConfig()->getRequestParameter('listtype');
        /** @var d3_ext_search|d3_alist_extsearch|d3_manufacturerlist_extsearch|d3_vendorlist_extsearch $oController */
        if ('search' == $sListType) {
            $oController = oxNew('search');
        } elseif ('vendor' == $sListType) {
            $oController = oxNew('vendorlist');
        } elseif ('manufacturer' == $sListType) {
            $oController = oxNew('manufacturerlist');
        } else {
            $oController = oxNew('alist');
        }

        return $oController;
    }

    /**
     * checks if this view can be cached
     * @return bool
     * @throws d3ShopCompatibilityAdapterException
     * @throws d3_cfg_mod_exception
     */
    public function canCache()
    {
        $canCache = parent::canCache();

        $oController = $this->d3GetBaseController();
        if ($canCache &&
            method_exists($oController, 'd3GetXListController') &&
            count($oController->d3GetXListController()->getAllSelections())
        ) {
            $canCache = false;
        }

        return $canCache;
    }
}
