<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_attribute_extsearch_ajax extends ajaxListComponent
{

    /**
     * Columns array
     *
     * @var array
     */
    protected $_aColumns = array(
        'container1' => array( // field , table,         visible, multilanguage, ident
            array('oxtitle', 'oxcategories', 1, 1, 0),
            array('oxdesc', 'oxcategories', 1, 1, 0),
            array('oxid', 'oxcategories', 0, 0, 0),
            array('oxid', 'oxcategories', 0, 0, 1)
        ),
        'container2' => array(
            array('oxtitle', 'oxcategories', 1, 1, 0),
            array('oxdesc', 'oxcategories', 1, 1, 0),
            array('oxid', 'oxcategories', 0, 0, 0),
            array('oxid', 'd3extsearch_attribute2object', 0, 0, 1),
            array('oxid', 'oxcategories', 0, 0, 1)
        ),
    );

    /**
     * @return string
     * @throws oxConnectionException
     */
    protected function _getQuery()
    {
        $oDb = oxDb::getDb();
        $oConfig = $this->getConfig();
        $sId = $oConfig->getRequestParameter('oxid');
        $sSynchId = $oConfig->getRequestParameter('synchoxid');

        $sCategoryTable = $this->_getViewName('oxcategories');

        // category selected or not ?
        if (!$sId) {
            $sQAdd = " from {$sCategoryTable}";
        } else {
            $sQAdd = " from d3extsearch_attribute2object, {$sCategoryTable} " .
                     "where {$sCategoryTable}.oxid=d3extsearch_attribute2object.oxobjectid " .
                     " and d3extsearch_attribute2object.oxattributeid = " . $oDb->quote($sId) .
                     " and d3extsearch_attribute2object.oxtype = 'oxcategories' ";
        }

        if ($sSynchId && $sSynchId != $sId) {
            // performance
            $sSubSelect = " select {$sCategoryTable}.oxid from d3extsearch_attribute2object, {$sCategoryTable} " .
                          "where {$sCategoryTable}.oxid=d3extsearch_attribute2object.oxobjectid " .
                          " and d3extsearch_attribute2object.oxattributeid = " . $oDb->quote($sSynchId) .
                          " and d3extsearch_attribute2object.oxtype = 'oxcategories' ";
            if (stristr($sQAdd, 'where') === false) {
                $sQAdd .= ' where ';
            } else {
                $sQAdd .= ' and ';
            }
            $sQAdd .= " {$sCategoryTable}.oxid not in ( $sSubSelect ) ";
        }

        return $sQAdd;
    }

    /**
     * Removes selected items from list
     * @throws oxConnectionException
     * @throws oxSystemComponentException
     */
    public function removeAttributeCategory()
    {
        $oConfig = $this->getConfig();
        $aChosenCategories = $this->_getActionIds('d3extsearch_attribute2object.oxid');

        /** @var oxAttribute $oAttribute */
        $oAttribute = oxNew('oxAttribute');
        $oAttribute->setId($oConfig->getRequestParameter('oxid'));
        if (method_exists($oAttribute, 'executeDependencyEvent')) {
            $oAttribute->executeDependencyEvent();
        }

        if ($oConfig->getRequestParameter('all')) {
            $sQ = $this->_addFilter("delete d3extsearch_attribute2object.* " . $this->_getQuery());
            oxDb::getDb()->Execute($sQ);
        } elseif (is_array($aChosenCategories)) {
            $sChosenCategories = implode(", ", oxDb::getInstance()->quoteArray($aChosenCategories));
            $sQ = "delete from d3extsearch_attribute2object where d3extsearch_attribute2object.oxid in (" . $sChosenCategories . ") ";
            oxDb::getDb()->Execute($sQ);
        }
    }

    /**
     * Adds selected category (categories) to discount list
     * @throws oxConnectionException
     * @throws oxSystemComponentException
     */
    public function addAttributeCategory()
    {
        $oConfig = $this->getConfig();
        $aChosenCategories = $this->_getActionIds('oxcategories.oxid');
        $soxId = $oConfig->getRequestParameter('synchoxid');

        /** @var oxAttribute $oAttribute */
        $oAttribute = oxNew('oxAttribute');
        $oAttribute->setId($soxId);
        if (method_exists($oAttribute, 'executeDependencyEvent')) {
            $oAttribute->executeDependencyEvent();
        }

        if ($oConfig->getRequestParameter('all')) {
            $sCategoryTable = $this->_getViewName('oxcategories');
            $aChosenCategories = $this->_getAll($this->_addFilter("select $sCategoryTable.oxid " . $this->_getQuery()));
        }

        if ($soxId && $soxId != "-1" && is_array($aChosenCategories)) {
            foreach ($aChosenCategories as $sChosenCat) {
                $oAssignment = oxNew("oxbase");
                $oAssignment->init('d3extsearch_attribute2object');
                $oAssignment->d3extsearch_attribute2object__oxattributeid = new oxField($soxId);
                $oAssignment->d3extsearch_attribute2object__oxobjectid = new oxField($sChosenCat);
                $oAssignment->d3extsearch_attribute2object__oxtype = new oxField("oxcategories");
                $oAssignment->save();
            }
        }

        /** @var oxAttribute $oAttribute */
        $oAttribute = oxNew('oxAttribute');
        if (method_exists($oAttribute, 'executeDependencyEvent')) {
            $oAttribute->executeDependencyEvent();
        }
    }
}
