<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

use D3\Extsearch\Application\Controller as ModuleController;
use D3\Extsearch\Application\Controller\Admin as ModuleAdminController;
use D3\Extsearch\Core as ModuleCore;
use D3\Extsearch\Application\Model as ModuleModel;
use D3\Extsearch\Application\Model\Filters as ModuleFilterModel;
use D3\Extsearch\setup as ModuleSetup;
use D3\ModCfg\Application\Model\d3utils;
use OxidEsales\Eshop\Application\Controller as OxidController;
use OxidEsales\Eshop\Application\Model as OxidModel;
use OxidEsales\Eshop\Application\Component as OxidComponent;
use OxidEsales\Eshop\Core as OxidCore;

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

$sModuleId = 'd3_extsearch';
/**
 * Module information
 */
$aModule = array(
    'id'          => $sModuleId,
    'title'       =>
        (class_exists(d3utils::class) ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Erweiterte Suche / Extended Search',
    'description' => array(
        'de' => 'Stellt fehlertolerante Suche und weitere Filterm&ouml;glichkeiten zur Verf&uuml;gung.<br>Aktivieren Sie die Moduleintr&auml;ge bitte immer und steuern Sie die Modulaktivit&auml;t ausschlie&szlig;lich im Adminbereich des Moduls.',
        'en' => '',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '6.0.0.0',
    'author'      => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'extend'      => array(
        OxidController\Admin\ArticleList::class             => 'd3/extsearch/Modules/Application/Controller/Admin/d3_article_list_extsearch',
        OxidController\ArticleDetailsController::class      => 'd3/extsearch/Modules/Application/Controller/d3_details_extsearch',
        OxidModel\Article::class                            => 'd3/extsearch/Modules/Application/Model/d3_oxarticle_phonetic',
        OxidModel\ArticleList::class                        => 'd3/extsearch/Modules/Application/Model/d3_oxarticlelist_extsearch',
        OxidComponent\BasketComponent::class                => 'd3/extsearch/Modules/Application/Component/d3_oxcmp_basket_extsearch',
        OxidComponent\UtilsComponent::class                 => 'd3/extsearch/Modules/Application/Component/d3_oxcmp_utils_extsearch',
        OxidComponent\Widget\ArticleDetails::class          => 'd3/extsearch/Modules/Application/Component/d3_oxwarticledetails_extsearch',
        OxidComponent\Locator::class                        => 'd3/extsearch/Modules/Application/Controller/d3_oxlocator_extsearch',
        OxidController\ArticleListController::class         => 'd3/extsearch/Modules/Application/Controller/d3_alist_extsearch',
        OxidController\ManufacturerListController::class    => 'd3/extsearch/Modules/Application/Controller/d3_manufacturerlist_extsearch',
        OxidController\VendorListController::class          => 'd3/extsearch/Modules/Application/Controller/d3_vendorlist_extsearch',
        OxidController\RssController::class                 => 'd3/extsearch/Modules/Application/Controller/d3_rss_extsearch',
        OxidModel\RssFeed::class                            => 'd3/extsearch/Modules/Application/Model/d3_oxrssfeed_extsearch',
        OxidModel\Search::class                             => 'd3/extsearch/Modules/Application/Model/d3_oxsearch_extsearch',
        OxidController\SearchController::class              => 'd3/extsearch/Modules/Application/Controller/d3_ext_search',
        OxidCore\UtilsView::class                           => 'd3/extsearch/Modules/Core/d3_oxutilsview_extsearch',
        ddoevisualcmsadmin::class                           => 'd3/extsearch/Modules/Application/Controller/Admin/d3_ddoevisualcmsadmin_extsearch',
        OxidCore\Routing\ModuleControllerMapProvider::class => 'd3/extsearch/Modules/Core/Routing/d3_ModuleControllerMapProvider_extsearch',
    ),
    'files'       => array(
        ModuleController\d3_extsearch_response::class   => 'd3/extsearch/Application/Controller/d3_extsearch_response.php',
        ModuleController\d3_xlist_extsearch::class      => 'd3/extsearch/Application/Controller/d3_xlist_extsearch.php',
        ModuleModel\d3_extsearch_synset::class          => 'd3/extsearch/Application/Model/d3_extsearch_synset.php',
        ModuleModel\d3_extsearch_term::class            => 'd3/extsearch/Application/Model/d3_extsearch_term.php',
        ModuleSetup\d3_extsearch_update::class          => 'd3/extsearch/setup/d3_extsearch_update.php',
        ModuleModel\d3_oxutils_extsearch::class         => 'd3/extsearch/Application/Model/d3_oxutils_extsearch.php',
        ModuleModel\d3_search::class                    => 'd3/extsearch/Application/Model/d3_search.php',
        ModuleModel\d3_search_generator::class          => 'd3/extsearch/Application/Model/d3_search_generator.php',
        ModuleModel\d3_semantic::class                  => 'd3/extsearch/Application/Model/d3_semantic.php',
        ModuleModel\d3_extsearch_statisticlog::class    => 'd3/extsearch/Application/Model/d3_extsearch_statisticlog.php',
        ModuleCore\d3_extsearch_conf::class             => 'd3/extsearch/Core/d3_extsearch_conf.php',

        ModuleFilterModel\d3FilterInterface::class    => 'd3/extsearch/Application/Model/Filters/d3FilterInterface.php',
        ModuleFilterModel\d3Filter::class             => 'd3/extsearch/Application/Model/Filters/d3Filter.php',
        ModuleFilterModel\d3FilterList::class         => 'd3/extsearch/Application/Model/Filters/d3FilterList.php',
        ModuleFilterModel\d3AttributeFilter::class    => 'd3/extsearch/Application/Model/Filters/d3AttributeFilter.php',
        ModuleFilterModel\d3CategoryFilter::class     => 'd3/extsearch/Application/Model/Filters/d3CategoryFilter.php',
        ModuleFilterModel\d3FieldIsFilter::class      => 'd3/extsearch/Application/Model/Filters/d3FieldIsFilter.php',
        ModuleFilterModel\d3FieldLikeFilter::class    => 'd3/extsearch/Application/Model/Filters/d3FieldLikeFilter.php',
        ModuleFilterModel\d3IndexFilter::class        => 'd3/extsearch/Application/Model/Filters/d3IndexFilter.php',
        ModuleFilterModel\d3ManufacturerFilter::class => 'd3/extsearch/Application/Model/Filters/d3ManufacturerFilter.php',
        ModuleFilterModel\d3PriceFilter::class        => 'd3/extsearch/Application/Model/Filters/d3PriceFilter.php',
        ModuleFilterModel\d3VendorFilter::class       => 'd3/extsearch/Application/Model/Filters/d3VendorFilter.php',

        ModuleAdminController\d3_cfg_extsearch::class                           => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch.php',
        ModuleAdminController\d3_cfg_extsearch_licence::class                   => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_licence.php',
        ModuleAdminController\d3_cfg_extsearch_list::class                      => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_list.php',
        ModuleAdminController\d3_cfg_extsearch_main::class                      => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_main.php',
        ModuleAdminController\d3_cfg_extsearch_navigation::class                => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_navigation.php',
        ModuleAdminController\d3_cfg_extsearch_plugins::class                   => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_plugins.php',
        ModuleAdminController\d3_cfg_extsearch_quicksearch::class               => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_quicksearch.php',
        ModuleAdminController\d3_cfg_extsearch_statistik::class                 => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearch_statistik.php',
        ModuleAdminController\d3_cfg_extsearchstat::class                       => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchstat.php',
        ModuleAdminController\d3_cfg_extsearchstat_list::class                  => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchstat_list.php',
        ModuleAdminController\d3_cfg_extsearchsyneditor::class                  => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchsyneditor.php',
        ModuleAdminController\d3_cfg_extsearchsyneditor_list::class             => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchsyneditor_list.php',
        ModuleAdminController\d3_cfg_extsearchsyneditor_main::class             => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchsyneditor_main.php',
        ModuleAdminController\d3_cfg_extsearchsyneditor_manage::class           => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchsyneditor_manage.php',
        ModuleAdminController\d3_cfg_extsearchlog::class                        => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchlog.php',
        ModuleAdminController\d3_cfg_extsearchlog_list::class                   => 'd3/extsearch/Application/Controller/Admin/d3_cfg_extsearchlog_list.php',
        ModuleAdminController\Reports\d3_extsearch_report_base::class           => 'd3/extsearch/Application/Controller/Admin/Reports/d3_extsearch_report_base.php',
        ModuleAdminController\Reports\d3_extsearch_report_hitless::class        => 'd3/extsearch/Application/Controller/Admin/Reports/d3_extsearch_report_hitless.php',
        ModuleAdminController\Reports\d3_extsearch_report_mostsearches::class   => 'd3/extsearch/Application/Controller/Admin/Reports/d3_extsearch_report_mostsearches.php',
    ),
    'templates'   => array(
        'd3_cfg_extsearch_main.tpl'                 => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_main.tpl',
        'd3_cfg_extsearch_main_sortanalysis.tpl'    => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_main_sortanalysis.tpl',
        'd3_cfg_extsearch_navigation.tpl'           => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_navigation.tpl',
        'd3_cfg_extsearch_plugins.tpl'              => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_plugins.tpl',
        'd3_cfg_extsearch_quicksearch.tpl'          => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_quicksearch.tpl',
        'd3_cfg_extsearch_statistik.tpl'            => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearch_statistik.tpl',
        'd3_cfg_extsearchsyneditor_list.tpl'        => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearchsyneditor_list.tpl',
        'd3_cfg_extsearchsyneditor_main.tpl'        => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearchsyneditor_main.tpl',
        'd3_cfg_extsearchsyneditor_manage.tpl'      => 'd3/extsearch/Application/views/admin/tpl/d3_cfg_extsearchsyneditor_manage.tpl',
        'd3_extsearch_report_hitless.tpl'           => 'd3/extsearch/Application/views/admin/tpl/reports/d3_extsearch_report_hitless.tpl',
        'd3_extsearch_report_mostsearches.tpl'      => 'd3/extsearch/Application/views/admin/tpl/reports/d3_extsearch_report_mostsearches.tpl',
        'd3_extsearch_plugin.tpl'                   => 'd3/extsearch/Application/views/admin/tpl/d3_extsearch_plugin.tpl',
        'd3_extsearch_popup.tpl'                    => 'd3/extsearch/Application/views/admin/tpl/d3_extsearch_popup.tpl',

        'd3_ext_search_suggestsearch.tpl'           => 'd3/extsearch/Application/views/tpl/d3_ext_search_suggestsearch.tpl',

        'd3_ext_search_highlight.tpl'               => 'd3/extsearch/Application/views/tpl/d3_ext_search_highlight.tpl',

        'd3_ext_search_filter.tpl'                  => 'd3/extsearch/Application/views/tpl/d3_ext_search_filter.tpl',
        'd3_inc_ext_search_azure.tpl'               => 'd3/extsearch/Application/views/tpl/azure/d3_inc_ext_search.tpl',
        'd3_list_filters_azure.tpl'                 => 'd3/extsearch/Application/views/tpl/azure/d3extsearch_alist_filters.tpl',
        'd3_search_contents_flow.tpl'               => 'd3/extsearch/Application/views/tpl/flow/d3_search_contents.tpl',
        'd3_search_filters_flow.tpl'                => 'd3/extsearch/Application/views/tpl/flow/d3_search_filters.tpl',
        'd3_list_filters_flow.tpl'                  => 'd3/extsearch/Application/views/tpl/flow/d3_list_filters.tpl',
        'd3_inc_ext_search_mobile.tpl'              => 'd3/extsearch/Application/views/tpl/mobile/d3_inc_ext_search.tpl',
        'd3_list_filters_mobile.tpl'                => 'd3/extsearch/Application/views/tpl/mobile/d3extsearch_alist_filters.tpl',

        'd3_ext_search_filter_category.tpl'         => 'd3/extsearch/Application/views/tpl/filterelements/category.tpl',
        'd3_ext_search_filter_vendor.tpl'           => 'd3/extsearch/Application/views/tpl/filterelements/vendor.tpl',
        'd3_ext_search_filter_manufacturer.tpl'     => 'd3/extsearch/Application/views/tpl/filterelements/manufacturer.tpl',
        'd3_ext_search_filter_attribute.tpl'        => 'd3/extsearch/Application/views/tpl/filterelements/attribute.tpl',
        'd3_ext_search_filter_priceselector.tpl'    => 'd3/extsearch/Application/views/tpl/filterelements/priceselector.tpl',
        'd3_ext_search_filter_jqslider.tpl'         => 'd3/extsearch/Application/views/tpl/filterelements/jqslider.tpl',

        'd3_ddeovisualcmsadmin_extsearch.tpl'       => 'd3/extsearch/Application/views/tpl/d3_ddoevisualcmsadmin_extsearch.tpl',
    ),
    'events'      => array(
        'onActivate'   => '\D3\ModCfg\Application\Model\Install\d3install::checkUpdateStart',
    ),
    'settings' => array(
        array(
            'group'     => 'd3thememapping_module',
            'name'      => 'd3custParentThemeMappedToFlow_'.$sModuleId,
            'type'      => 'str',
            'value'     => ''
        ),
        array(
            'group'     => 'd3thememapping_module',
            'name'      => 'd3custParentThemeMappedToMobile_'.$sModuleId,
            'type'      => 'str',
            'value'     => ''
        ),
        array(
            'group'     => 'd3thememapping_module',
            'name'      => 'd3custParentThemeMappedToAzure_'.$sModuleId,
            'type'      => 'str',
            'value'     => ''
        ),
    ),
    'blocks'      => array(
        array(
            'template'  => 'page/search/search.tpl',
            'block'     => 'search_results',
            'file'      => 'Application/views/blocks/page/search/d3_inc_ext_search.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'layout/base.tpl',
            'block'     => 'head_css',
            'file'      => 'Application/views/blocks/layout/d3_extsearch_css.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'layout/base.tpl',
            'block'     => 'base_js',
            'file'      => 'Application/views/blocks/layout/d3_extsearch_js.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/header/search.tpl',
            'block'     => 'widget_header_search_form',
            'file'      => 'Application/views/blocks/widget/header/d3_extsearch_headersearch.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/header/search.tpl',
            'block'     => 'header_search_field',
            'file'      => 'Application/views/blocks/widget/header/d3_extsearch_searchfield.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'page/list/list.tpl',
            'block'     => 'page_list_listbody',
            'file'      => 'Application/views/blocks/page/list/d3extsearch_alist_noartfilters.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'page/list/list.tpl',
            'block'     => 'page_list_listhead',
            'file'      => 'Application/views/blocks/page/list/d3extsearch_alist_filters.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/locator/attributes.tpl',
            'block'     => 'widget_locator_attributes',
            'file'      => 'Application/views/blocks/widget/locator/d3_list_disabledefaultfilters.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_infogrid.tpl',
            'block'     => 'widget_product_listitem_infogrid_titlebox',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listiteminfogrid_title.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_grid.tpl',
            'block'     => 'widget_product_listitem_grid',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listitemgrid_title.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_grid.tpl',
            'block'     => 'widget_product_listitem_infogrid_titlebox',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listitemgrid_flowtitlebox.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_line.tpl',
            'block'     => 'widget_product_listitem_line_titlebox',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listitemline_flowtitlebox.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_line.tpl',
            'block'     => 'widget_product_listitem_line_selections',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listitemline_selections.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'widget/product/listitem_line.tpl',
            'block'     => 'widget_product_listitem_line_description',
            'file'      => 'Application/views/blocks/widget/product/d3_extsearch_listitemline_description.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'content_main.tpl',
            'block'     => 'admin_content_main_form',
            'file'      => 'Application/views/admin/blocks/d3_extsearch_content_main.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'attribute_main.tpl',
            'block'     => 'admin_attribute_main_form',
            'file'      => 'Application/views/admin/blocks/d3_extsearch_attribute_main.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'category_main.tpl',
            'block'     => 'admin_category_main_form',
            'file'      => 'Application/views/admin/blocks/d3_extsearch_category_main.tpl',
            'position'  => 1,
        ),
        array(
            'template'  => 'article_extend.tpl',
            'block'     => 'admin_article_extend_form',
            'file'      => 'Application/views/admin/blocks/d3_extsearch_article_extend.tpl',
            'position'  => 1,
        ),
    ),
    'd3FileRegister'    => array(
        'd3/extsearch/IntelliSenseHelper.php',
        'd3/extsearch/metadata.php',
        'd3/extsearch/core/smarty/plugins/function.d3_extsearch_highlight.php',
        'd3/extsearch/Application/Model/d3_phonetic_de.php',
        'd3/extsearch/Application/Model/d3_phonetic_de_voc.php',
        'd3/extsearch/public/d3_extsearch_response.php',
        'd3/extsearch/Application/translations/de/d3_extsearch_lang.php',
        'd3/extsearch/Application/translations/en/d3_extsearch_lang.php',
        'd3/extsearch/Application/views/admin/de/d3_extsearch_lang.php',
        'd3/extsearch/Application/views/admin/de/module_options.php',
        'd3/extsearch/Application/views/admin/en/d3_extsearch_lang.php',
        'd3/extsearch/Application/views/admin/en/module_options.php',
        'd3/extsearch/setup/d3_extsearch_semanticstructure.php',
        'd3/extsearch/setup/d3_extsearch_semantic_synset.php',
        'd3/extsearch/setup/d3_extsearch_semantic_term.php',
        'd3/extsearch/setup/d3_extsearch_statisticlog.php',
    ),
    'd3SetupClasses'    => array(
        ModuleSetup\d3_extsearch_update::class,
    ),
);
