<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_attribute_extsearch extends oxAdminDetails
{
    /** @var d3ordermanagerlist */
    protected $_aJobList;
    protected $_sHelpLinkMLAdd;

    /**
     * Current class template name.
     *
     * @var string
     */
    protected $_sThisTemplate = 'd3_attribute_extsearch.tpl';

    /**
     * @return string
     * @throws oxSystemComponentException
     */
    public function render()
    {
        $sRet = parent::render();

        $soxId = $this->getEditObjectId();
        $this->addTplParam("oxid", $soxId);

        if ($soxId != "-1" && isset($soxId)) {
            // load object
            $oItem = oxNew("oxattribute");
            $oItem->load($soxId);
            $this->addTplParam("edit", $oItem);
        }

        $iAoc = oxRegistry::getConfig()->getRequestParameter("aoc");
        if ($iAoc == 1) {
            /** @var d3_attribute_extsearch_ajax $oAjax */
            $oAjax = oxNew('d3_attribute_extsearch_ajax');
            $this->_aViewData['oxajax'] = $oAjax->getColumns();

            return "d3_attribute_extsearch_ajax.tpl";
        }

        return $sRet;
    }

    /**
     * Saves article attributes.
     *
     * @return mixed
     */
    public function save()
    {
        parent::save();

        $soxId = $this->getEditObjectId();
        $aParams = oxRegistry::getConfig()->getRequestParameter("editval");

        $oAttr = oxNew("oxattribute");

        if ($soxId != "-1") {
            $oAttr->loadInLang($this->_iEditLang, $soxId);
        } else {
            $aParams['oxattribute__oxid'] = null;
        }

        //Disable editing for derived items
        if ($oAttr->isDerived()) {
            return;
        }

        $oAttr->setLanguage(0);
        $oAttr->assign($aParams);
        $oAttr->setLanguage($this->_iEditLang);
        $oAttr->save();

        $this->setEditObjectId($oAttr->getId());
    }

    /**
     * @return d3_cfg_mod
     * @throws d3_cfg_mod_exception
     */
    public function d3GetSet()
    {
        return d3_cfg_mod::get('d3_extsearch');
    }
}
