<?php
 /**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright  D Data Development, Thomas Dartsch
 * @author    D Data Development - Daniel Seifert <ds@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_oxwarticledetails_extsearch extends d3_oxwarticledetails_extsearch_parent
{
    public $oD3SearchHandler = null;
    protected $_aSelectedAttributes;

    /**
     * performance, use a class wide instance
     *
     * @return d3_oxsearch_extsearch
     */
    protected function _d3GetSearchHandler()
    {
        if (!$this->oD3SearchHandler) {
            $this->oD3SearchHandler = oxNew('oxsearch');
        }

        return $this->oD3SearchHandler;
    }

    /**
     * @return array
     */
    public function getPriceFilters()
    {
        return $this->_d3GetSearchHandler()->getPriceSelectors();
    }

    /**
     * @return array
     */
    public function getAttributeFilters()
    {
        if (null == $this->_aSelectedAttributes) {
            $this->_aSelectedAttributes = $this->_d3GetSearchHandler()->getAttributeFilters();

            foreach ($this->_aSelectedAttributes as $sKey => $mValue) {
                if (is_array($mValue) && count($mValue)) {
                    foreach ($mValue as $iIdent => $sValue) {
                        $sAddStr = "&amp;d3searchattribmulti[$sKey][$iIdent]=" . urlencode(trim($sValue));
                        //$this->_sD3AdditionalParams .= $sAddStr;
                        /*$this->addTplParam(
                            'additionalparams',
                            $this->getViewDataElement('additionalparams') . $sAddStr
                        );*/
                    }
                } elseif (is_string($mValue) && trim($mValue)) {
                    $sAddStr = "&amp;d3searchattrib[$sKey]=" . urlencode(trim($mValue));
                    //$this->_sD3AdditionalParams .= $sAddStr;
                    //$this->addTplParam('additionalparams', $this->getViewDataElement('additionalparams') . $sAddStr);
                }
            }

            $this->addTplParam('aD3AttribFilters', $this->_aSelectedAttributes);
        }

        return $this->_aSelectedAttributes;
    }

    /**
     * @return mixed
     */
    public function d3getFilterPageId()
    {
// ToDo add further PageIds
        return oxRegistry::getConfig()->getRequestParameter('cnid');
    }
}
