<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_extsearch_update extends d3install_updatebase
{
    public $sModKey = 'd3_extsearch';
    public $sModName = 'erweiterte Suche';
    public $sModVersion = '5.5.0.1';
    public $sModRevision = '986';
    public $sBaseConf = 'uetWlo0NWxoWFJGMzh5Q3F5WVB4bEhTMGZ1MWVDdkpzcHNZMWNLZzViRitJNU9mLzJhUHFlL3hwWjQrM
DhOelRKYThzd1RRZ0VSZTVnQmZ0WVZwa0ZUZURVOGZDY25jK1lWQk5Hb2UxWnhZc1E1MzFLNzNaa1pyO
FQrOUk2SmwrbGdvRzY3d0QwN3VUTVI5d2c2K2pydVFPQytYenV4Qm5lamt1R0VQY3ArREp4MXBQU1UxW
XR1OERIM3Y3WjVwMjBWcjc2Y2FhMS9kVjNLUHlkZmJhcUpReGNNVGp1eFdsREJSRXdMUitrMHZ0NEdBb
FFDWWlnekNrclBFbnB6ZnlDYUdKbHp2Nk9neUtqT0tXZWJ4WHlKUWpNRVBQVXlROElFVTJJZ09pZ0tpZ
UE9';
    public $sRequirements = '';
    public $sBaseValue = 'TyUzQTglM0ElMjJzdGRDbGFzcyUyMiUzQTU3JTNBJTdCcyUzQTI4JTNBJTIyZDNfY2ZnX21vZF9fYUxpY2Vuc2VJbmZvT
WFpbCUyMiUzQmElM0EyJTNBJTdCcyUzQTQyJTNBJTIyTk9MSUNLRVlfXzQ3OTM2Mzg3MDJiNjc3MTVmMWRmYmZjODMyNDY2OTE0JTIyJTNCcyUzQTE5JTNB
JTIyMjAxMy0wMS0xNiUyMDEyJTNBMTAlM0E0MCUyMiUzQnMlM0E0NCUzQSUyMk5PU0VSSUFMSURfXzQ3OTM2Mzg3MDJiNjc3MTVmMWRmYmZjODMyNDY2OTE
0JTIyJTNCcyUzQTE5JTNBJTIyMjAxMy0wMS0xNiUyMDEyJTNBMTElM0E0MiUyMiUzQiU3RHMlM0E0MiUzQSUyMmQzX2NmZ19tb2RfX2FFeHRTZWFyY2hfc2
ltaWxhclNlYXJjaEZpZWxkcyUyMiUzQmElM0E0JTNBJTdCaSUzQTAlM0JzJTNBMTQlM0ElMjI1MCUyMCUzRCUzRSUyMG94YXJ0bnVtJTIyJTNCaSUzQTElM
0JzJTNBMTMlM0ElMjI1MCUyMCUzRCUzRSUyMG94dGl0bGUlMjIlM0JpJTNBMiUzQnMlM0ExOCUzQSUyMjQwJTIwJTNEJTNFJTIwb3hzZWFyY2hrZXlzJTIy
JTNCaSUzQTMlM0JzJTNBMTclM0ElMjIyMCUyMCUzRCUzRSUyMG94c2hvcnRkZXNjJTIyJTNCJTdEcyUzQTQzJTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJ
jaF9NdWx0aVNlYXJjaHdvcmRVc2FnZSUyMiUzQnMlM0ExMCUzQSUyMnNpbmdsZVdvcmQlMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYX
JjaF91c2VBcnROdW1TZWFyY2glMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9vcmRlckJ5UHJpb
3JpdHklMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzUlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9vcmRlckJ5UHVzaCUyMiUzQnMlM0ExJTNB
JTIyMSUyMiUzQnMlM0E0NCUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX2ZpbmRQdXRJbkFuZExlYXZlT3V0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTN
CcyUzQTM3JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfb3duRm9ybUZpZWxkcyUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzNyUzQSUyMmQzX2
NmZ19tb2RfX2JsRXh0U2VhcmNoX1ZhcmlhbnRTZWFyY2glMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzUlM0ElMjJkM19jZmdfbW9kX19zRXh0U2Vhc
mNoX1ZhcmlhbnRVc2FnZSUyMiUzQnMlM0ExMCUzQSUyMnNob3dQYXJlbnQlMjIlM0JzJTNBMzclM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaW1p
bGFyU2VhcmNoJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTMxJTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9sYW5nRmlsZSUyMiUzQnMlM0ExOCU
zQSUyMmQzX3Bob25ldGljX2RlLnBocCUyMiUzQnMlM0EzOCUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX3NpbWlsYXJFeHRMaXN0JTIyJTNCcyUzQT
ElM0ElMjIwJTIyJTNCcyUzQTM3JTNBJTIyZDNfY2ZnX21vZF9faUV4dFNlYXJjaF9zaW1pbGFyRXh0TGlzdCUyMiUzQnMlM0EyJTNBJTIyMTAlMjIlM0JzJ
TNBMzYlM0ElMjJkM19jZmdfbW9kX19pRXh0U2VhcmNoX21pblBob25MZW5ndGglMjIlM0JzJTNBMSUzQSUyMjIlMjIlM0JzJTNBMzglM0ElMjJkM19jZmdf
bW9kX19ibEV4dFNlYXJjaF9zZW1hbnRpY1NlYXJjaCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0E0MyUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmN
oX3NlbWFudGljVXNlUGhvbmV0aWMlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBNDMlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zZW1hbnRpY0
FsbG93VnVsZ2FyJTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcyUzQTMzJTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfY2F0U2VhcmNoJTIyJTNCcyUzQ
TElM0ElMjIxJTIyJTNCcyUzQTM4JTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9zaG93Q2F0QXJ0aWNsZXMlMjIlM0JzJTNBOCUzQSUyMmFydGluY2F0
JTIyJTNCcyUzQTMwJTNBJTIyZDNfY2ZnX21vZF9faUV4dFNlYXJjaF9jYXRQcmlvJTIyJTNCcyUzQTIlM0ElMjI1MCUyMiUzQnMlM0E0MiUzQSUyMmQzX2N
mZ19tb2RfX2JsRXh0U2VhcmNoX21hbnVmYWN0dXJlclNlYXJjaCUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0EzOSUzQSUyMmQzX2NmZ19tb2RfX2lFeH
RTZWFyY2hfbWFudWZhY3R1cmVyUHJpbyUyMiUzQnMlM0EyJTNBJTIyNTAlMjIlM0JzJTNBMzklM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93Q
29udGVudExpc3QlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBNDUlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9jb250ZW50U2VhcmNoTG9uZ3Rl
eHQlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzQlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9sb2dIaXRsZXNzJTIyJTNCcyUzQTElM0ElMjI
xJTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfZ2VuZXJhbGx5TG9nRm9yU2VhcmNoJTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCcy
UzQTQxJTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfYWRtaW5TaG93VmFyaWFudHMlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzglM0ElMjJkM
19jZmdfbW9kX19pRXh0U2VhcmNoX2FydGljbGVzUGVyVGljayUyMiUzQnMlM0EyJTNBJTIyMTAlMjIlM0JzJTNBMzUlM0ElMjJkM19jZmdfbW9kX19ibEV4
dFNlYXJjaF9lbXB0eVNlYXJjaCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0E0MyUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX3Nob3dIaWdobGl
naHRlZFRleHQlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBMzclM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9nb1RvVW5pcXVlSGl0JTIyJTNCcy
UzQTElM0ElMjIxJTIyJTNCcyUzQTM1JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfc2hvd0NhdExpc3QlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0JzJ
TNBMzUlM0ElMjJkM19jZmdfbW9kX19zRXh0U2VhcmNoX29yZGVyQ2F0TGlzdCUyMiUzQnMlM0E3JTNBJTIyY291bnRlciUyMiUzQnMlM0E0MiUzQSUyMmQz
X2NmZ19tb2RfX2JsRXh0U2VhcmNoX3Nob3dPbmVJdGVtQ2F0TGlzdCUyMiUzQnMlM0ExJTNBJTIyMCUyMiUzQnMlM0EzOCUzQSUyMmQzX2NmZ19tb2RfX2J
sRXh0U2VhcmNoX3Nob3dWZW5kb3JMaXN0JTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTM4JTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJjaF9vcmRlcl
ZlbmRvckxpc3QlMjIlM0JzJTNBNyUzQSUyMmNvdW50ZXIlMjIlM0JzJTNBNDUlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93T25lSXRlbVZlb
mRvckxpc3QlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBNDQlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93TWFudWZhY3R1cmVyTGlzdCUy
MiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0NCUzQSUyMmQzX2NmZ19tb2RfX3NFeHRTZWFyY2hfb3JkZXJNYW51ZmFjdHVyZXJMaXN0JTIyJTNCcyUzQTc
lM0ElMjJjb3VudGVyJTIyJTNCcyUzQTUxJTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfc2hvd09uZUl0ZW1NYW51ZmFjdHVyZXJMaXN0JTIyJTNCcy
UzQTElM0ElMjIwJTIyJTNCcyUzQTQxJTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfc2hvd0F0dHJpYnV0ZUxpc3QlMjIlM0JzJTNBMSUzQSUyMjAlM
jIlM0JzJTNBNDElM0ElMjJkM19jZmdfbW9kX19zRXh0U2VhcmNoX29yZGVyQXR0cmlidXRlTGlzdCUyMiUzQnMlM0E3JTNBJTIyY291bnRlciUyMiUzQnMl
M0E1NSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX3Nob3dOb0Fzc2lnbmVkQXR0cmlidXRlQXJ0aWNsZXMlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0J
zJTNBNDElM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9zaG93UHJpY2VTZWxlY3RvciUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0E0MSUzQSUyMm
QzX2NmZ19tb2RfX2lFeHRTZWFyY2hfcHJpY2VTZWxlY3Rvckl0ZW1zJTIyJTNCcyUzQTElM0ElMjI1JTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fY
mxFeHRTZWFyY2hfUHJpY2VTZWxlY3RvcnNSb3VuZGVkJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTQ1JTNBJTIyZDNfY2ZnX21vZF9fc0V4dFNlYXJj
aF9QcmljZVNlbGVjdG9yc0Rpc3BUeXBlJTIyJTNCcyUzQTglM0ElMjJkcm9wZG93biUyMiUzQnMlM0EzOSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmN
oX3Nob3dGaWx0ZXJQYXJhbSUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQnMlM0EzOSUzQSUyMmQzX2NmZ19tb2RfX3NFeHRTZWFyY2hfZmlsdGVyUGFyYW1GaW
VsZCUyMiUzQnMlM0E3JTNBJTIyb3h0aXRsZSUyMiUzQnMlM0E0MCUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX2VuYWJsZUFqYXhTZWFyY2glMjIlM
0JzJTNBMSUzQSUyMjElMjIlM0JzJTNBNDUlM0ElMjJkM19jZmdfbW9kX19zRXh0U2VhcmNoX1F1aWNrU2VhcmNoTWF4QXJ0aWNsZXMlMjIlM0JzJTNBMyUz
QSUyMjIwMCUyMiUzQnMlM0E0OSUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX1F1aWNrU2VhcmNoTG9hZENhdGVnb3JpZXMlMjIlM0JzJTNBMSUzQSU
yMjElMjIlM0JzJTNBNTIlM0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9RdWlja1NlYXJjaExvYWRNYW51ZmFjdHVyZXJzJTIyJTNCcyUzQTElM0ElMj
IxJTIyJTNCcyUzQTQ2JTNBJTIyZDNfY2ZnX21vZF9fYmxFeHRTZWFyY2hfUXVpY2tTZWFyY2hMb2FkVmVuZG9ycyUyMiUzQnMlM0ExJTNBJTIyMSUyMiUzQ
nMlM0E0NiUzQSUyMmQzX2NmZ19tb2RfX2JsRXh0U2VhcmNoX1F1aWNrU2VhcmNoTG9hZENvbnRlbnQlMjIlM0JzJTNBMSUzQSUyMjAlMjIlM0JzJTNBMzEl
M0ElMjJkM19jZmdfbW9kX19ibEV4dFNlYXJjaF9TaG93SUFTJTIyJTNCcyUzQTElM0ElMjIwJTIyJTNCJTdE';

    protected $_aUpdateMethods = array(
        array('check' => 'checkModCfgItemExist',
              'do'    => 'updateModCfgItemExist'),
        array('check' => 'checkRenameFields',
              'do'    => 'fixRenameFields'),
        array('check' => 'checkDeleteFields',
              'do'    => 'fixDeleteFields'),
        array('check' => 'checkIndexRefreshMsg',
              'do'    => 'fixIndexRefreshMsg'),
        array('check' => 'checkSynsetSynTableExist',
              'do'    => 'addSynsetSynTable'),
        array('check' => 'checkSynsetTermTableExist',
              'do'    => 'addSynsetTermTable'),
        array('check' => 'checkFields',
              'do'    => 'fixFields'),
        array('check' => 'checkIndizes',
              'do'    => 'fixIndizes'),
        array('check' => 'checkContentNoArtItemExist',
              'do'    => 'updateContentNoArtItemExist'),
        array('check' => 'hasUnregisteredFiles',
              'do'    => 'showUnregisteredFiles'),
        array('check' => 'checkModCfgSameRevision',
              'do'    => 'updateModCfgSameRevision'),
    );

    public $aFields = array(
        'D3_PHONETIC'        => array(
            'sTableName'  => 'oxartextends',
            'sFieldName'  => 'D3_PHONETIC',
            'sType'       => 'LONGTEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => true,
        ),
        'D3_SEARCHINDEXDATE' => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3_SEARCHINDEXDATE',
            'sType'       => 'DATETIME',
            'blNull'      => false,
            'sDefault'    => '0000-00-00 00:00:00',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => true,
        ),
        'D3PUSH'             => array(
            'sTableName'  => 'oxarticles',
            'sFieldName'  => 'D3PUSH',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '1',
            'sComment'    => 'search sort criteria',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3COUNT'            => array(
            'sTableName'  => 'oxlogs',
            'sFieldName'  => 'D3COUNT',
            'sType'       => 'INT(5)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3ISSEARCHABLE'     => array(
            'sTableName'  => 'oxcontents',
            'sFieldName'  => 'D3ISSEARCHABLE',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'modExtSearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3NOTUSE4FILTER'    => array(
            'sTableName'  => 'oxattribute',
            'sFieldName'  => 'D3NOTUSE4FILTER',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'attrib use in extsearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3NOTUSE4FILTERCAT'    => array(
            'sTableName'  => 'oxcategories',
            'sFieldName'  => 'D3NOTUSE4FILTER',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'category use in extsearch',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_OXID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'OXID',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_VERSION'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'version',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_ISACRONYM'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'is_acronym',
            'sType'       => 'BIT(1)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_ISSHORT_FORM'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'is_short_form',
            'sType'       => 'BIT(1)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_LANGUAGE_ID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'language_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_LEVEL_ID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'level_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_NORMALIZED_WORD'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'normalized_word',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_ORIGINAL_ID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'original_id',
            'sType'       => 'INT(11)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_SYNSET_ID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'synset_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_USER_COMMENT'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'user_comment',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_WORD'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'word',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_WORD_GRAMMAR_ID'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'word_grammar_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_TERM_D3_PHONETIC'    => array(
            'sTableName'  => 'd3_extsearch_term',
            'sFieldName'  => 'd3_phonetic',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_OXID'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'oxid',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_VERSION'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'version',
            'sType'       => 'CHAR(32)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_EVALUATION'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'evaluation',
            'sType'       => 'INT(11)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_IMPORT_STATUS'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'import_status',
            'sType'       => 'INT(11)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_IS_VISIBLE'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'is_visible',
            'sType'       => 'BIT(1)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_ORIGINAL_ID'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'original_id',
            'sType'       => 'INT(11)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_ORIGINALURI'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'originaluri',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_PREFCATID'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'preferred_category_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_SECTION_ID'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'section_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_SOURCE_ID'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'source_id',
            'sType'       => 'CHAR(32)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_SYNPREFTERM'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'synset_preferred_term',
            'sType'       => 'VARCHAR(255)',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'D3SYN_SYNSET_USER_COMMENT'    => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sFieldName'  => 'user_comment',
            'sType'       => 'LONGTEXT',
            'blNull'      => true,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
    );

    public $aIndizes = array(
        'D3COUNT' => array(
            'sTableName' => 'oxlogs',
            'sType'      => '',
            'sName'      => 'D3COUNT',
            'aFields'    => array(
                'D3COUNT' => 'D3COUNT',
            ),
        ),
        'PRIMARY'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'     => 'PRIMARY',
            'sName'     => 'PRIMARY',
            'aFields'   => array(
                'OXID' => 'OXID',
            ),
            'blMultilang' => false,
        ),
        'FK36446CA3843755'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'sName'     => 'FK36446CA3843755',
            'aFields' => array(
                'SYNSET_ID' => 'SYNSET_ID',
            ),
            'blMultilang' => false,
        ),
        'FK36446C6EBCBF4A'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'sName'     => 'FK36446C6EBCBF4A',
            'aFields' => array(
                'WORD_GRAMMAR_ID' => 'WORD_GRAMMAR_ID',
            ),
            'blMultilang' => false,
        ),
        'FK36446C534B2C73'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'sName'     => 'FK36446C534B2C73',
            'aFields' => array(
                'LEVEL_ID' => 'LEVEL_ID',
            ),
            'blMultilang' => false,
        ),
        'FK36446C5CA8CBD5'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'sName'     => 'FK36446C5CA8CBD5',
            'aFields' => array(
                'LANGUAGE_ID' => 'LANGUAGE_ID',
            ),
            'blMultilang' => false,
        ),
        'WORD'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'aFields' => array(
                'WORD' => 'WORD',
            ),
            'blMultilang' => false,
        ),
        'NORMALIZED_WORD'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'aFields' => array(
                'NORMALIZED_WORD' => 'NORMALIZED_WORD',
            ),
            'blMultilang' => false,
        ),
        'D3_PHONETIC'  => array(
            'sTableName'  => 'd3_extsearch_term',
            'sType'   => '',
            'aFields' => array(
                'D3_PHONETIC' => 'D3_PHONETIC',
            ),
            'blMultilang' => false,
        ),
        'SYNSET_PRIMARY'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => 'PRIMARY',
            'sName'     => 'PRIMARY',
            'aFields' => array(
                'OXID' => 'OXID',
            ),
            'blMultilang' => false,
        ),
        'FKCB1A289A4A27BB5'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => '',
            'sName'     => 'FKCB1A289A4A27BB5',
            'aFields' => array(
                'SOURCE_ID' => 'SOURCE_ID',
            ),
            'blMultilang' => false,
        ),
        'FKCB1A289AED375357'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => '',
            'sName'     => 'FKCB1A289AED375357',
            'aFields' => array(
                'PREFERRED_CATEGORY_ID' => 'PREFERRED_CATEGORY_ID',
            ),
            'blMultilang' => false,
        ),
        'FKCB1A289AD9BB831F'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => '',
            'sName'     => 'FKCB1A289AD9BB831F',
            'aFields' => array(
                'SECTION_ID' => 'SECTION_ID',
            ),
            'blMultilang' => false,
        ),
        'IS_VISIBLE'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => '',
            'aFields' => array(
                'IS_VISIBLE' => 'IS_VISIBLE',
            ),
            'blMultilang' => false,
        ),
        'IS_ORIGINAL'  => array(
            'sTableName'  => 'd3_extsearch_synset',
            'sType'   => '',
            'aFields' => array(
                'ORIGINAL_ID' => 'ORIGINAL_ID',
            ),
            'blMultilang' => false,
        ),
    );

    public $aRenameFields = array(
        'D3_PHONETIC'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3_phonetic'), // is case sensitive
           'sFieldName'  => 'D3_PHONETIC',
           'blMultilang' => true,
        ),
        'D3_SEARCHINDEXDATE'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3_searchIndexDate'), // is case sensitive
           'sFieldName'  => 'D3_SEARCHINDEXDATE',
           'blMultilang' => true,
        ),
        'D3PUSH'        => array(
           'sTableName'  => 'oxarticles',
           'mOldFieldNames' => array('d3push'), // is case sensitive
           'sFieldName'  => 'D3PUSH',
           'blMultilang' => false,
        ),
        'D3NOTUSE4FILTER'        => array(
           'sTableName'  => 'oxattribute',
           'mOldFieldNames' => array('d3notuse4filter'), // is case sensitive
           'sFieldName'  => 'D3NOTUSE4FILTER',
           'blMultilang' => false,
        ),
    );

    public $aOldModuleFiles = array(
        'd3/d3_extsearch/models/d3_extsearch_update.php',
    );

    protected $_aRefreshMetaModuleIds = array('d3_extsearch');

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            $this->setInitialExecMethod(__METHOD__);

            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                    'oxnewrevision' => $this->sModRevision,
                );

                if ($this->_checkTableItemNotExist('d3_cfg_mod', $aWhere)) {
                    // update don't use this property
                    unset($aWhere['oxnewrevision']);

                    $aInsertFields = array(
                        'OXID'           => array (
                            'content'       => "md5('" . $this->sModKey . " " . $oShop->getId() . " de')",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXSHOPID'       => array (
                            'content'       => $oShop->getId(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXMODID'        => array (
                            'content'       => $this->sModKey,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXNAME'         => array (
                            'content'       => $this->sModName,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXACTIVE'       => array (
                            'content'       => "0",
                            'force_update'  => false,
                            'use_quote'     => false,
                        ),
                        'OXBASECONFIG'   => array (
                            'content'       => $this->sBaseConf,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSERIAL'   => array (
                            'content'       => "",
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXINSTALLDATE'  => array (
                            'content'       => "NOW()",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXVERSION'      => array (
                            'content'       => $this->sModVersion,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSHOPVERSION'  => array (
                            'content'       => oxRegistry::getConfig()->getEdition(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXREQUIREMENTS' => array (
                            'content'       => $this->sRequirements,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXVALUE'        => array(
                            'content'       => $this->sBaseValue,
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXNEWREVISION'  => array(
                            'content'       => $this->sModRevision,
                            'force_update'  => true,
                            'use_quote'     => true,
                        )
                    );

                    $this->setInitialExecMethod(__METHOD__);
                    $blRet  = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
                }
            }
        }
        return $blRet;
    }

    /**
     * config example:
     *  public $aDeleteFields = array(
     *      'D3_PHONETIC'        => array(
     *          'sTableName'  => 'oxarticles',
     *          'sFieldName'  => 'D3_PHONETIC',
     *          'blMultilang' => true,
     *       ),
     *  );
     *
     * @return bool
     */
    public function checkDeleteFields()
    {
        $blReturn = false;

        $blCS = false; // search is case sensitive

        if ($this->aDeleteFields && is_array($this->aDeleteFields) && count($this->aDeleteFields)) {
            foreach ($this->aDeleteFields as $aField) {
                $iChangeLang = $aField['blMultilang'] ? 15 : 0;
                for ($iLang=$iChangeLang; $iLang >= 0; $iLang--) {
                    $sCheckName = $this->_addMultiLangAddOn($aField['sFieldName'], $iLang);
                    $sMLTableName = getLangTableName($aField['sTableName'], $iLang);
                    $blReturn = $this->_checkTableFieldExist($sMLTableName, $sCheckName, $blCS);

                    if ($blReturn) {
                        return $blReturn;
                    }
                }
            }
        }

        return $blReturn;
    }

    /**
     * config example:
     *  public $aDeleteFields = array(
     *      'D3_PHONETIC'        => array(
     *          'sTableName'  => 'oxarticles',
     *          'sFieldName'  => 'D3_PHONETIC',
     *          'blMultilang' => true,
     *       ),
     *  );
     *
     * @param string $sMethodName
     *
     * @return bool
     */
    public function fixDeleteFields($sMethodName = __METHOD__)
    {
        $blReturn = true;

        if ($this->aDeleteFields && is_array($this->aDeleteFields) && count($this->aDeleteFields)) {
            foreach ($this->aDeleteFields as $aField) {
                $iChangeLang = $aField['blMultilang'] ? 15 : 0;
                for ($iLang=$iChangeLang; $iLang >= 0; $iLang--) {
                    $sCheckName = $this->_addMultiLangAddOn($aField['sFieldName'], $iLang);
                    $sMLTableName = getLangTableName($aField['sTableName'], $iLang);
                    if ($this->_checkTableFieldExist($sMLTableName, $sCheckName, $blCS = false)) {
                        $blReturn = $this->_dropTableField($sMLTableName, $sCheckName, $sMethodName);

                        $sFieldName = 'D3_SEARCHINDEXDATE';
                        $sIndexCheckName = $this->_addMultiLangAddOn($sFieldName, $iLang);

                        if ($this->_checkTableFieldExist($sMLTableName, $sIndexCheckName, $blCS = false)) {
                            $aWhere = array(
                                'oxactive'      => '1',
                            );

                            $aUpdateFields = array(
                                $sIndexCheckName       => array(
                                    'fieldname'    => $sIndexCheckName,
                                    'content'      => '0000-00-00',
                                    'force_update' => true,
                                    'use_quote'    => true,
                                ),
                            );

                            $this->setInitialExecMethod(__METHOD__);
                            $blReturn  = $this->_updateTableItem2($sMLTableName, $aUpdateFields, $aWhere);

                            oxRegistry::getSession()->setVariable('checkIndexRefreshMsg', true);
                        }
                    }
                }
            }
        }

        return $blReturn;
    }

    /**
     * @return bool
     */
    public function checkIndexRefreshMsg()
    {
        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function fixIndexRefreshMsg()
    {
        $blRet = true;

        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            oxRegistry::getSession()->setVariable('checkIndexRefreshMsg', false);
            $this->_confirmMessage('D3_EXTSEARCH_UPDATE_GENPHONETIC');
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkContentNoArtItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('oxcontents', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateContentNoArtItemExist()
    {
        $blRet = false;

        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            if ($this->_checkTableItemNotExist('oxcontents', $aWhere)) {
                $aWhere = array();
                $aInsertFields = array(
                    array (
                        'fieldname'     => 'OXID',
                        'content'       => "md5('d3extsearch_noarticlefound " . $oShop->getId() . "')",
                        'force_update'  => true,
                        'use_quote'     => false,
                    ),
                    array (
                        'fieldname'     => 'OXLOADID',
                        'content'       => "d3extsearch_noarticlefound",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSHOPID',
                        'content'       => $oShop->getId(),
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSNIPPET',
                        'content'       => "1",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXTYPE',
                        'content'       => "0",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXACTIVE',
                        'content'       => "1",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXPOSITION',
                        'content'       => "",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'de'),
                        'content'       => "Leider wurden keine Artikel gefunden",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXCONTENT',
                        'content'       => "<p>Versuchen Sie es mit einem anderen Suchbegriff, einer anderen ".
                            "Schreibweise oder anderen Filtern bitte noch einmal. </p><p>Erhalten Sie dennoch keine ".
                            "Ergebnisse, kontaktieren Sie uns bitte ".
                            "<a href=\"[{oxgetseourl ident=\$oViewConf->getSelfLink()|cat:\"cl=contact\"}]\">hier</a>.".
                            "</p><br />",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'en'),
                        'content'       => "Sorry, no items were found.",
                        'force_update'  => false,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXCATID',
                        'content'       => "kgo83a794223bfd23cbb091d0a34019d",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXFOLDER',
                        'content'       => "CMSFOLDER_USERINFO",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                );

                $this->setInitialExecMethod(__METHOD__);
                $blRet  = $this->_updateTableItem2('oxcontents', $aInsertFields, $aWhere);

                if ($this->getStepByStepMode()) {
                    break;
                }
            }
        }

        return $blRet;
    }

    /**
     * @return bool true, if table is missing
     */
    public function checkSynsetTermTableExist()
    {
        return $this->_checkTableNotExist('d3_extsearch_term');
    }

    /**
     * @return bool
     */
    public function addSynsetTermTable()
    {
        $this->setInitialExecMethod(__METHOD__);

        return $this->_addTable2(
            'd3_extsearch_term',
            $this->aFields,
            $this->aIndizes,
            '',
            'MyISAM'
        );
    }

    /**
     * @return bool true, if table is missing
     */
    public function checkSynsetSynTableExist()
    {
        return $this->_checkTableNotExist('d3_extsearch_synset');
    }

    /**
     * @return bool
     */
    public function addSynsetSynTable()
    {
        $this->setInitialExecMethod(__METHOD__);

        return $this->_addTable2(
            'd3_extsearch_synset',
            $this->aFields,
            $this->aIndizes,
            '',
            'MyISAM'
        );
    }

    /**
     * @return bool
     */
    public function hasUnregisteredFiles()
    {
        return $this->_hasUnregisteredFiles('d3_extsearch', array('blocks', 'd3FileRegister'));
    }

    /**
     * @return bool
     */
    public function showUnregisteredFiles()
    {
        return $this->_showUnregisteredFiles('d3_extsearch', array('blocks', 'd3FileRegister'));
    }
}
