<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL);

define("OX_IS_ADMIN", true);

/**
 * Returns shop base path.
 *
 * @return string
 */
function getShopBasePath()
{
    return dirname(__FILE__) . '/../../../../';
}

require_once getShopBasePath() . "/bootstrap.php";

if (false == isset($argv[1])) {
    echo "No arguments defined!";
    var_dump($argv);
    exit(1);
}

// EE Shop
if (isset($argv[3])) {
    oxRegistry::getConfig()->setShopId($argv[3]);
}

// import
$soxId = $argv[1];
/** @var $oImportConfig d3importconfig */
$oImportConfig = oxNew("d3importconfig");
if (false == $oImportConfig->load($soxId)) {
    echo "The import profile with id '$soxId' could not be loaded!";
    exit(1);
}
$oImportConfig->overwriteImportTicker(0);

/** @var $oImporter d3importer */
$oImporter = oxNew("d3importer", $oImportConfig);
$oImporter->setAfterTickerMaximum(9999999999);
$oImporter->import();
$oDB = oxDb::getDb();
echo 'Imported: ' . $oDB->GetOne("select count(oxid) from oxarticles where d3importflag = 'IMPORTED'") . PHP_EOL;
echo 'Updated: ' . $oDB->GetOne("select count(oxid) from oxarticles where d3importflag = 'UPDATED'") . PHP_EOL;

$aViewData                = array();
$aViewData["iFailImport"] = $oImporter->getFailImport();
$aViewData["blEOF"]       = $oImporter->isEndOfFile();
$aViewData["iFilePos"]    = $oImporter->getFilePointerPosisition();
$aViewData["iLinePos"]    = $oImporter->getActualLinePosition();

// delete or inactive
if (isset($argv[2])) {
    $sAction = $argv[2];
    if ($sAction == 'delete' || $sAction == 'inactive') {
        $oImporter->afterimport($sAction);
    }
}

if ($aViewData['iFailImport']) {
    echo oxRegistry::getLang()->translateString("D3_IMPORTER_FAILIMPORT_{$aViewData['iFailImport']}") . PHP_EOL;
    exit(2);
}

// picture import
echo 'starting picture import.' . PHP_EOL;
/** @var $oPictureImporter d3pictureimport */
$oPictureImporter = oxNew("d3pictureimport", $oImportConfig);
$oPictureImporter->setIsCronJob();
$oPictureImporter->setMaxImportCount(9999999999);
$oPictureImporter->setMaxPictureCount(9999999999);

$oPictureImporter->ImportExternPictures();
echo "Picture downloaded: {$oPictureImporter->iActImportExtPictureCount}" . PHP_EOL;
echo $oPictureImporter->ScanPictureDir() . PHP_EOL;
$oPictureImporter->import();
if ($oPictureImporter->getConfigFailure() != 0) {
    echo "Config failure: {$oPictureImporter->getConfigFailure()}" . PHP_EOL;
}

echo "Handled {$oPictureImporter->getActualImportCounter()} Pictures" . PHP_EOL;


