<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'          => 'd3importer',
    'title'       => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Importer',
    'description' => array(
        'de' => 'Umfangreiche Importm&ouml;glichkeiten der Artikel inkl. dem Import von Bildern, ' //
            . 'sowie alle Datenfelder von Artikeln, Kategorien, Crossselling, Attribute, ' //
            . 'Auswahllisten, Varianten, Staffelpreise, Hersteller & Lieferanten',
        'en' => 'n/a',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '4.4.2.0',
    'author'      => 'D&sup3; Data Development, Inh. Thomas Dartsch',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'extend'      => array(
        // Smarty-Verzeichniss innerhalb des Modul-Verzeichnisses
        'oxutilsview' => 'd3/d3importer/modules/core/d3_oxutilsview_importer',
    ),
    'files'       => array(
        'd3importer_update'                             => 'd3/d3importer/setup/d3importer_update.php',
        'd3_importer'                                   => 'd3/d3importer/controllers/admin/d3_importer.php',
        'd3_importer_afterimport'                       => 'd3/d3importer/controllers/admin/d3_importer_afterimport.php',
        'd3_importer_attrib'                            => 'd3/d3importer/controllers/admin/d3_importer_attrib.php',
        'd3_importer_category'                          => 'd3/d3importer/controllers/admin/d3_importer_category.php',
        'd3_importer_config'                            => 'd3/d3importer/controllers/admin/d3_importer_config.php',
        'd3_importer_cross'                             => 'd3/d3importer/controllers/admin/d3_importer_cross.php',
        'd3_importer_fields'                            => 'd3/d3importer/controllers/admin/d3_importer_fields.php',
        'd3_importer_import'                            => 'd3/d3importer/controllers/admin/d3_importer_import.php',
        'd3_importer_list'                              => 'd3/d3importer/controllers/admin/d3_importer_list.php',
        'd3_importer_main'                              => 'd3/d3importer/controllers/admin/d3_importer_main.php',
        'd3_importer_price2art'                         => 'd3/d3importer/controllers/admin/d3_importer_price2art.php',
        'd3_importer_selectlist'                        => 'd3/d3importer/controllers/admin/d3_importer_selectlist.php',
        'd3_importer_variants'                          => 'd3/d3importer/controllers/admin/d3_importer_variants.php',
        'd3_importer_vendors'                           => 'd3/d3importer/controllers/admin/d3_importer_vendors.php',
        'd3_importercfg'                                => 'd3/d3importer/controllers/admin/d3_importercfg.php',
        'd3_importercfg_list'                           => 'd3/d3importer/controllers/admin/d3_importercfg_list.php',
        'd3_importercfg_support'                        => 'd3/d3importer/controllers/admin/d3_importercfg_support.php',
        'd3_picture'                                    => 'd3/d3importer/controllers/admin/d3_picture.php',
        'd3_picture_import'                             => 'd3/d3importer/controllers/admin/d3_picture_import.php',
        'd3_picture_list'                               => 'd3/d3importer/controllers/admin/d3_picture_list.php',
        'd3_picture_main'                               => 'd3/d3importer/controllers/admin/d3_picture_main.php',
        'd3_d3importer_controllers_admin_base'          => 'd3/d3importer/controllers/admin/base.php',
        'd3importconfig'                                => 'd3/d3importer/models/d3importconfig.php',
        'd3importer'                                    => 'd3/d3importer/models/d3importer.php',
        'd3importerdesc'                                => 'd3/d3importer/models/d3importerdesc.php',
        'd3pictureimport'                               => 'd3/d3importer/models/d3pictureimport.php',
        'd3_d3importer_controllers_admin_basesettings'  => 'd3/d3importer/controllers/admin/basesettings.php',
        'd3_cfg_importerlog'                            => 'd3/d3importer/controllers/admin/log/d3_cfg_importerlog.php',
        'd3_cfg_importerlog_list'                       => 'd3/d3importer/controllers/admin/log/d3_cfg_importerlog_list.php',
        'd3_d3importer_models_profilemapper'            => 'd3/d3importer/models/profilemapper.php',
        'd3_d3importer_models_formbuilder'              => 'd3/d3importer/models/formbuilder.php',
        'd3_d3importer_models_settings_complex'         => 'd3/d3importer/models/settings/complex.php',
        'd3_d3importer_models_settings_config'          => 'd3/d3importer/models/settings/config.php',
        'd3_d3importer_models_settings_defaultboolean'  => 'd3/d3importer/models/settings/defaultboolean.php',
        'd3_d3importer_models_settings_element'         => 'd3/d3importer/models/settings/element.php',
        'd3_d3importer_models_settings_combined'        => 'd3/d3importer/models/settings/combined.php',
        'd3_d3importer_models_groupbuilder'             => 'd3/d3importer/models/groupbuilder.php',
        'd3_d3importer_controllers_admin_desc_item'     => 'd3/d3importer/controllers/admin/desc/item.php',
        'd3_d3importer_controllers_admin_desc_itemlist' => 'd3/d3importer/controllers/admin/desc/itemlist.php',
        'd3_d3importer_controllers_admin_desc_itemmain' => 'd3/d3importer/controllers/admin/desc/main.php',
    ),
    'templates'   => array(
        'd3_importer.tpl'                                     => 'd3/d3importer/views/admin/tpl/d3_importer.tpl',
        'd3_importer_afterimport.tpl'                         => 'd3/d3importer/views/admin/tpl/d3_importer_afterimport.tpl',
        'd3_importer_afterticker.tpl'                         => 'd3/d3importer/views/admin/tpl/d3_importer_afterticker.tpl',
        'd3_importer_attrib.tpl'                              => 'd3/d3importer/views/admin/tpl/d3_importer_attrib.tpl',
        'd3_importer_category.tpl'                            => 'd3/d3importer/views/admin/tpl/d3_importer_category.tpl',
        'd3_importer_config.tpl'                              => 'd3/d3importer/views/admin/tpl/d3_importer_config.tpl',
        'd3_importer_cross.tpl'                               => 'd3/d3importer/views/admin/tpl/d3_importer_cross.tpl',
        'd3_importer_fields.tpl'                              => 'd3/d3importer/views/admin/tpl/d3_importer_fields.tpl',
        'd3_importer_import.tpl'                              => 'd3/d3importer/views/admin/tpl/d3_importer_import.tpl',
        'd3_importer_inc_nav.tpl'                             => 'd3/d3importer/views/admin/tpl/d3_importer_inc_nav.tpl',
        'd3_importer_list.tpl'                                => 'd3/d3importer/views/admin/tpl/d3_importer_list.tpl',
        'd3_importer_main.tpl'                                => 'd3/d3importer/views/admin/tpl/d3_importer_main.tpl',
        'd3_importer_price2art.tpl'                           => 'd3/d3importer/views/admin/tpl/d3_importer_price2art.tpl',
        'd3_importer_selectlist.tpl'                          => 'd3/d3importer/views/admin/tpl/d3_importer_selectlist.tpl',
        'd3_importer_ticker.tpl'                              => 'd3/d3importer/views/admin/tpl/d3_importer_ticker.tpl',
        'd3_importer_variants.tpl'                            => 'd3/d3importer/views/admin/tpl/d3_importer_variants.tpl',
        'd3_importer_vendors.tpl'                             => 'd3/d3importer/views/admin/tpl/d3_importer_vendors.tpl',
        'd3_picture.tpl'                                      => 'd3/d3importer/views/admin/tpl/d3_picture.tpl',
        'd3_picture_extticker.tpl'                            => 'd3/d3importer/views/admin/tpl/d3_picture_extticker.tpl',
        'd3_picture_import.tpl'                               => 'd3/d3importer/views/admin/tpl/d3_picture_import.tpl',
        'd3_picture_list.tpl'                                 => 'd3/d3importer/views/admin/tpl/d3_picture_list.tpl',
        'd3_picture_main.tpl'                                 => 'd3/d3importer/views/admin/tpl/d3_picture_main.tpl',
        'd3_picture_ticker.tpl'                               => 'd3/d3importer/views/admin/tpl/d3_picture_ticker.tpl',
        'd3_d3importer_views_admin_tpl_basesettings.tpl'      => 'd3/d3importer/views/admin/tpl/basesettings.tpl',
        'd3_d3importer_views_admin_tpl_formelementloader.tpl' => 'd3/d3importer/views/admin/tpl/formelementloader.tpl',
        'd3_d3importer_views_admin_tpl_forms_text.tpl'        => 'd3/d3importer/views/admin/tpl/forms/text.tpl',
        'd3_d3importer_views_admin_tpl_forms_choice.tpl'      => 'd3/d3importer/views/admin/tpl/forms/choice.tpl',
        'd3_d3importer_views_admin_tpl_forms_bool.tpl'        => 'd3/d3importer/views/admin/tpl/forms/bool.tpl',
        'd3_d3importer_views_admin_tpl_forms_textarea.tpl'    => 'd3/d3importer/views/admin/tpl/forms/textarea.tpl',
        'd3_d3importer_views_admin_tpl_errormessages.tpl'     => 'd3/d3importer/views/admin/tpl/errormessages.tpl',
        'd3_d3importer_views_admin_tpl_desc_list.tpl'     => 'd3/d3importer/views/admin/tpl/desc/list.tpl',
        'd3_d3importer_views_admin_tpl_desc_main.tpl'     => 'd3/d3importer/views/admin/tpl/desc/main.tpl',
    ),
    'blocks'      => array(
        array(
            'template' => 'bottomnaviitem.tpl',
            'block'    => 'admin_bottomnavicustom',
            'file'     => '/views/blocks/admin_bottomnavicustom.tpl'
        ),
    ),
);
