<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_usermanageritem_action extends d3_cfg_usermanageritem_settings
{
    protected $_sThisTemplate = "d3_cfg_usermanageritem_action.tpl";
    protected $_sMenuSubItemTitle = 'd3mxusermanager_items';
    protected $_sSavedId;
    protected $_sExportFieldDescMLIdent = 'D3_USERMANAGER_FIELDDESC';
    protected $_sExportFieldTitleBaseMLIdent = 'D3_USERMANAGER_FIELDTITLE_';
    protected $_sExportFieldLangMLIdent = 'D3_USERMANAGER_FIELDADD_LANG';

    /**
     * @throws oxSystemComponentException
     */
    public function save()
    {
        parent::save();

        $aMissingRequiredValues = array();
        /** @var d3usermanager_action_abstract $oAction */
        foreach ($this->getActionList() as $sId => $oAction) {
            if ($this->getProfile()->getValue($oAction->sActionActiveSwitch) && false == $oAction->hasRequiredValues()) {
                $aMissingRequiredValues[] = $sId;
            }
        };

        if (count($aMissingRequiredValues)) {
            $this->addTplParam('missingRequValuesActions', $aMissingRequiredValues);
        }
    }

    /**
     * @return oxlist
     * @throws oxSystemComponentException
     */
    public function getContentList()
    {
        /** @var $oContentList oxcontentlist */
        $oContentList = oxNew('oxcontentlist');
        return $this->_getObjectList($oContentList);
    }

    /**
     * @param $blAdmin
     * @return string
     */
    public function getManagerTemplateDirs($blAdmin)
    {
        return oxRegistry::getConfig()->getTemplateDir($blAdmin);
    }

    /**
     * @return array
     * @throws oxSystemComponentException
     */
    public function getItemFieldNames()
    {
        /** @var oxuser $oUser */
        $oUser = oxNew('oxuser');
        return $oUser->getFieldNames();
    }

    /**
     * @return string
     * @throws oxSystemComponentException
     */
    public function getExportExamplePath()
    {
        /** @var d3usermanager $oProfile */
        $oProfile = oxNew($this->_sD3ObjectClass);
        $soxId    = oxRegistry::getConfig()->getRequestParameter("oxid");

        if (isset( $soxId) && $soxId && $soxId != "-1") {
            // load object
            $oProfile->loadInLang($this->_iEditLang, $soxId);
            $oProfile = $this->_d3LoadInOtherLang($oProfile, $soxId);
        }

        $aSearch = array(date('Y-m-d_H-i-s', $oProfile->getStartTime()));
        $aReplace = array(oxRegistry::getLang()->translateString('D3_USERMANAGER_ACTION_DATEPLACEHOLDER'));

        return str_replace($aSearch, $aReplace, $oProfile->getListExportFilePath());
    }

    /**
     * @param $sFieldName
     *
     * @return string
     */
    public function getFieldNameDescription($sFieldName)
    {
        if (($sFieldNameTitle = $this->getFieldNameTitle($sFieldName))) {
            return sprintf(
                oxRegistry::getLang()->translateString($this->_sExportFieldDescMLIdent),
                $sFieldNameTitle,
                $sFieldName
            );
        } else {
            return $sFieldName;
        }
    }

    /**
     * @param $sFieldName
     *
     * @return null|string
     */
    public function getFieldNameTitle($sFieldName)
    {
        $sLangAdd = '';
        $sPattern = "@(.*)([_]{1}([0-9]{1,3}))$@";
        if (preg_match($sPattern, $sFieldName, $aMatches)) {
            $sFieldMLIdent = $this->_sExportFieldTitleBaseMLIdent.strtoupper($aMatches[1]);
            $aLangNames = oxRegistry::getLang()->getLanguageNames();
            $sLangAdd  = sprintf(
                oxRegistry::getLang()->translateString($this->_sExportFieldLangMLIdent),
                $aLangNames[$aMatches[3]]
            );
        } else {
            $sFieldMLIdent = $this->_sExportFieldTitleBaseMLIdent.strtoupper($sFieldName);
        }

        $sFieldName = oxRegistry::getLang()->translateString($sFieldMLIdent);

        if ($sFieldName != $sFieldMLIdent) {
            return $sFieldName.$sLangAdd;
        } else {
            return null;
        }
    }

    /**
     * @return array
     * @throws oxSystemComponentException
     */
    public function getGroupedActionList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        $oItem = oxNew('oxuser');

        /** @var d3usermanager_actiongrouplist $oActionList */
        $oActionList = oxNew('d3usermanager_actiongrouplist', $oManager, $oItem);
        $oActionList->setGroups($oManager->getConfiguration()->getGroupedActionIdList());

        return $oActionList->getGroupList();
    }

    /**
     * @return array
     * @throws oxSystemComponentException
     */
    public function getActionList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        $oItem = oxNew('oxuser');

        /** @var d3usermanager_actionlist $oActionList */
        $oActionList = oxNew('d3usermanager_actionlist', $oManager, $oItem);
        $oActionList->setActions($oManager->getConfiguration()->getActionIdList());

        return $oActionList->getActionList();
    }

    /**
     * @param d3usermanager $oProfile
     * @param               $soxId
     *
     * @return d3usermanager
     */
    protected function _d3LoadInOtherLang(d3usermanager $oProfile, $soxId)
    {
        // load object in other languages
        $oOtherLang = $oProfile->getAvailableInLangs();
        if (false == isset($oOtherLang[$this->_iEditLang])) {
            $oProfile->loadInLang(key($oOtherLang), $soxId);
        }

        return $oProfile;
    }

    /**
     * @return array
     * @throws d3ShopCompatibilityAdapterException
     * @throws oxSystemComponentException
     */
    public function getModulePathList()
    {
        $sModulesDir = oxRegistry::getConfig()->getModulesDir();
        $aModulePathList = array();

        /** @var oxmodule $oModule */
        $oModule = oxNew('oxmodule');
        /** @var oxmodulelist $oModuleList */
        $oModuleList = oxNew("oxModuleList");
        foreach (array_keys($oModuleList->getModulesFromDir($sModulesDir)) as $sId) {
            /** @var d3ShopCompatibilityAdapterHandler $oD3CompatibilityAdapterHandler */
            $oD3CompatibilityAdapterHandler = oxNew('d3ShopCompatibilityAdapterHandler');
            $sModulePath = $oD3CompatibilityAdapterHandler->call(
                'oxmodule__getModuleFullPath',
                array($oModule, $sId)
            );

            $aModulePathList[$sId] = $sModulePath;
        };

        return $aModulePathList;
    }

    /**
     * @throws d3ParameterNotFoundException
     * @throws oxConnectionException
     * @throws oxSystemComponentException
     */
    public function markAsFinished()
    {
        /** @var d3usermanager $oProfile */
        $oProfile = $this->getProfile();
        $iCount = $oProfile->markConcernedItemsAsFinished();
        $this->_aMessages[] = sprintf(
            oxRegistry::getLang()->translateString('D3_USERMANAGER_ACTION_MARKASFINISHED_MESSAGE'),
            $iCount
        );
    }
}
