<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_usermanageritem_overview extends d3_cfg_mod_main
{
    protected $_sSetModId = 'd3_usermanager';
    protected $_sModId = 'd3_usermanager';
    protected $_sThisTemplate = "d3_cfg_usermanageritem_overview.tpl";
    protected $_sMenuItemTitle = 'd3mxusermanager';
    protected $_sMenuSubItemTitle = 'd3tbclusermanager_items_overview';
    protected $_blUseOwnOxid = true;
    protected $_aNaviItems = array(
        'new' => array(
            'sScript' => 'top.oxid.admin.editThis( -1 );return false;',
            'sTranslationId' => 'D3_TOOLTIPS_NEWUSERMANAGER',
        ),
    );
    protected $_sD3ObjectClass = 'd3usermanager';
    protected $_sRequestData;

    /**
     * @param $sName
     * @param $aArguments
     *
     * @return mixed
     */
    public function __call($sName, $aArguments)
    {
        /** @var d3_cfg_usermanageritem_action $oActionView */
        $oActionView = oxNew('d3_cfg_usermanageritem_action');
        if (method_exists($oActionView, $sName)) {
            return call_user_func_array(array($oActionView, $sName), $aArguments);
        }

        /** @var d3_cfg_usermanageritem_requ $oRequView */
        $oRequView = oxNew('d3_cfg_usermanageritem_requ');
        if (method_exists($oRequView, $sName)) {
            return call_user_func_array(array($oRequView, $sName), $aArguments);
        }

        return parent::__call($sName, $aArguments);
    }

    /**
     * @return d3usermanager_requirementlist
     */
    public function getRequirementList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        /** @var d3usermanager_requirementlist $oRequList */
        $oRequList = oxNew('d3usermanager_requirementlist', $oManager);
        $oRequList->setRequirements($oManager->getConfiguration()->getRequirementIdList());

        return $oRequList->getRequirementList();
    }

    /**
     * @return d3usermanager_actionlist
     */
    public function getActionList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        $oItem = oxNew('oxuser');
        /** @var d3usermanager_actionlist $oActionList */
        $oActionList = oxNew('d3usermanager_actionlist', $oManager, $oItem);
        $oActionList->setActions($oManager->getConfiguration()->getActionIdList());

        return $oActionList->getActionList();
    }

    /**
     * @return bool
     */
    public function isEditMode()
    {
        return false;
    }

    public function setRequestData()
    {
        $this->_sRequestData = oxRegistry::getConfig()->getRequestParameter('sRequestData');
    }

    /**
     * @return int
     */
    public function getToFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('toFinishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3usermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getConcernedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('finishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3usermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getFinishedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getFinishedMonthCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('finishedMonthCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3usermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getFinishedMonthItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @return int
     */
    public function getNotFinishedCount()
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter('notFinishedCount');

        if ($this->canRequestData(__FUNCTION__)) {
            /** @var d3usermanager $oProfile */
            $oProfile = $this->getProfile();
            return $oProfile->getListGenerator()->getNotFinishedItemCount();
        } elseif ($this->canUseRequestData($iRequestCount)) {
            return $iRequestCount;
        }

        return '';
    }

    /**
     * @param $sFunctionName
     *
     * @return bool
     */
    public function canRequestData($sFunctionName)
    {
        return !$this->getDataOnDemand()
            || $this->_sRequestData == $sFunctionName;
    }

    /**
     * @param $iRequestCount
     *
     * @return bool
     */
    public function canUseRequestData($iRequestCount)
    {
        return $this->getDataOnDemand()
            && strlen($iRequestCount);
    }

    /**
     * @return bool
     */
    public function getDataOnDemand()
    {
        return $this->d3GetSet()->getValue('blCalcStatOnDemand');
    }

    /**
     * @param $sRequestName
     * @param $sFunctionName
     *
     * @return bool
     */
    public function hasRequestedData($sRequestName, $sFunctionName)
    {
        $iRequestCount = oxRegistry::getConfig()->getRequestParameter($sRequestName);

        if (strlen($iRequestCount) || $this->_sRequestData == $sFunctionName) {
            return true;
        }

        return false;
    }
}
