<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

// fallback for non ee editions
if (false == class_exists('Admin_Mall')) {
    /**
     *
     */
    class Admin_Mall extends oxAdminDetails
    {
        protected $_blThisTemplate = "d3_cfg_usermanageritem_mall.tpl";

        /**
         * @return string
         */
        public function render()
        {
            parent::render();
            return $this->_blThisTemplate;
        }

        public function assignToSubshops()
        {
        }
    }
}

/**
 *
 */
class d3_cfg_usermanageritem_mall extends Admin_Mall
{
    /**
     * DB table having oxshopincl and oxshopexcl fields we are going to deal with
     */
    protected $_sMallTable = "d3modprofile";
    protected $_blUseOwnOxid = true;
    protected $_sMenuItemTitle = 'd3mxusermanager';
    protected $_sMenuSubItemTitle = 'd3mxusermanager_items';
    protected $_sUpdateAddSql;
    protected $_sHelpLinkMLAdd;
    protected $_aNaviItems = array(
        'new' => array(
            'sScript' => 'top.oxid.admin.editThis( -1 );return false;',
            'sTranslationId' => 'D3_TOOLTIPS_NEWUSERMANAGER',
        ),
    );
    /**
     * Class name of object to load
     */
    protected $_sObjectClassName = "d3usermanager";

    /**
     * @return string
     * @throws oxSystemComponentException
     */
    public function render()
    {
        /** @var d3usermanager $oProfile */
        $oProfile = oxNew($this->_sObjectClassName);
        $soxId = oxRegistry::getConfig()->getRequestParameter("oxid");

        if ($this->_isSetOxid($soxId)) {
            // load object
            $oProfile->loadInLang($this->_iEditLang, $soxId);
            $oProfile = $this->_d3LoadInOtherLang($oProfile, $soxId);
        }

        $this->addTplParam('edit', $oProfile);

        return parent::render();
    }

    /**
     * Assigns record information in multiple shop field
     *
     */
    public function assignToSubshops()
    {
        $sOXID = $this->getEditObjectId();
        $this->_sUpdateAddSql = " ";

        parent::assignToSubshops();

        //reseting oxfield2shop values
        $oShop = $this->_getEditShop($sOXID);

        // bc for OXID 5.0 + 5.1
        if (method_exists($oShop, 'cleanMultishopFields')) {
            $oShop->cleanMultishopFields($sOXID);
        }
    }

    /**
     * @return array
     */
    public function getUserMessages()
    {
        return array();
    }

    /**
     * @deprecated
     * @return mixed
     */
    public function getBGLogoUrl()
    {
        return '';
    }

    /**
     * @deprecated
     */
    public function background_logo()
    {
        d3_cfg_mod::background_logo();
    }

    /**
     * @return string
     * @throws d3_cfg_mod_exception
     * @throws oxSystemComponentException
     */
    public function getHelpURL()
    {
        $sUrl = $this->d3GetSet()->getHelpURL();
        /** @var $oFS d3filesystem */
        $oFS = oxNew('d3filesystem');

        if ($this->_sHelpLinkMLAdd) {
            $sUrl .= $oFS->unprefixedslashit(oxRegistry::getLang()->TranslateString($this->_sHelpLinkMLAdd));
        }

        $aFileName = $oFS->splitFilename($sUrl);

        // has no extension
        if (false == $aFileName['ext']) {
            $sUrl = $oFS->trailingslashit($sUrl);
        }

        return $sUrl;
    }

    /**
     * @return d3_cfg_mod
     * @throws d3_cfg_mod_exception
     */
    public function d3GetSet()
    {
        return d3_cfg_mod::get('d3usermanager');
    }

    /**
     * exampleItem:     array('new' => array(
     *                      'sScript' => 'top.oxid.admin.editThis( -1 );return false;',
     *                      'sTranslationId' => 'foo',
     *                  )
     * @return array
     */
    public function getNaviItems()
    {
        return $this->_aNaviItems;
    }

    /**
     * @return string
     */
    public function d3GetMenuItemTitle()
    {
        return $this->_sMenuItemTitle;
    }

    /**
     * @return string
     */
    public function d3GetMenuSubItemTitle()
    {
        return $this->_sMenuSubItemTitle;
    }

    /**
     * @param $soxId
     *
     * @return bool
     */
    protected function _isSetOxid($soxId)
    {
        return isset($soxId) && $soxId && $soxId != "-1";
    }

    /**
     * @param d3usermanager $oProfile
     * @param               $soxId
     *
     * @return d3usermanager
     */
    protected function _d3LoadInOtherLang(d3usermanager $oProfile, $soxId)
    {
        // load object in other languages
        $oOtherLang = $oProfile->getAvailableInLangs();
        if (false == isset($oOtherLang[$this->_iEditLang])) {
            $oProfile->loadInLang(key($oOtherLang), $soxId);
        }

        return $oProfile;
    }
}
