<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'          => 'd3usermanager',
    'title'       => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Kundenmanager',
    'description' => array(
        'de' => 'Bearbeitet frei definierbare Auftr&auml;ge auf Basis von einstellbaren Kundenlisten.',
        'en' => '',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '2.3.2.0',
    'author'      => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'extend'      => array(
        'oxemail' => 'd3/d3usermanager/modules/models/d3_oxemail_usermanager',
        'oxuser'  => 'd3/d3usermanager/modules/models/d3_oxuser_usermanager',
    ),
    'files'       => array(
        'd3_usermanager_cron'                       => 'd3/d3usermanager/public/d3_usermanager_cron.php',
        'd3usermanager'                             => 'd3/d3usermanager/models/d3usermanager.php',
        'd3usermanagerlist'                         => 'd3/d3usermanager/models/d3usermanagerlist.php',
        'd3usermanager_listgenerator'               => 'd3/d3usermanager/models/d3usermanager_listgenerator.php',
        'd3usermanager_remark'                      => 'd3/d3usermanager/models/d3usermanager_remark.php',
        'd3usermanager_update'                      => 'd3/d3usermanager/setup/d3usermanager_update.php',
        'd3usermanager_export'                      => 'd3/d3usermanager/models/d3usermanager_export.php',
        'd3usermanager_conf'                        => 'd3/d3usermanager/models/d3usermanager_conf.php',
        'd3usermanager_toUserAssignment'            => 'd3/d3usermanager/models/d3usermanager_touserassignment.php',
        'd3usermanager_execute'                     => 'd3/d3usermanager/models/d3usermanager_execute.php',
        'd3usermanager_cronUnavailableException'    =>
            'd3/d3usermanager/models/exceptions/d3usermanager_cronunavailableexception.php',
        'd3usermanager_requirementException'        =>
            'd3/d3usermanager/models/exceptions/d3usermanager_requirementexception.php',
        'd3usermanager_partgrouplist_abstract'      =>
            'd3/d3usermanager/models/d3usermanager_partgrouplist_abstract.php',
        'd3usermanager_partgrouplist_interface'     =>
            'd3/d3usermanager/models/d3usermanager_partgrouplist_interface.php',
        'd3usermanager_response'                    => 'd3/d3usermanager/controllers/d3usermanager_response.php',

        'd3usermanager_requirement_abstract'        =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_abstract.php',
        'd3usermanager_requirement_interface'       =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_interface.php',
        'd3usermanager_requirementgrouplist'        =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirementgrouplist.php',
        'd3usermanager_requirementlist'             =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirementlist.php',
        'd3usermanager_requirement_activefilter'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_activefilter.php',
        'd3usermanager_requirement_registerfrom'     =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_registerfrom.php',
        'd3usermanager_requirement_registerto'       =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_registerto.php',
        'd3usermanager_requirement_registertimespan' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_registertimespan.php',
        'd3usermanager_requirement_custnrfrom'       =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_custnrfrom.php',
        'd3usermanager_requirement_custnrto'         =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_custnrto.php',
        'd3usermanager_requirement_passwordfilter'   =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_passwordfilter.php',
        'd3usermanager_requirement_ingroupfilter'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ingroupfilter.php',
        'd3usermanager_requirement_notingroupfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_notingroupfilter.php',
        'd3usermanager_requirement_newsletterfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_newsletterfilter.php',
        'd3usermanager_requirement_hasbirthday'      =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_hasbirthday.php',
        'd3usermanager_requirement_birthdatefrom'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_birthdatefrom.php',
        'd3usermanager_requirement_birthdateto'      =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_birthdateto.php',
        'd3usermanager_requirement_agecheck'      =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_agecheck.php',
        'd3usermanager_requirement_validnewslettermail'  =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_validnewslettermail.php',
        'd3usermanager_requirement_bonifilter'       =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_bonifilter.php',
        'd3usermanager_requirement_deladdrfilter'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_deladdrfilter.php',
        'd3usermanager_requirement_executemethodfilter'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_executemethodfilter.php',
        'd3usermanager_requirement_invgenderfilter'  =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invgenderfilter.php',
        'd3usermanager_requirement_invcountryfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invcountryfilter.php',
        'd3usermanager_requirement_invzipfilter'     =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invzipfilter.php',
        'd3usermanager_requirement_invcompanyfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invcompanyfilter.php',
        'd3usermanager_requirement_invustidfilter'   =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invustidfilter.php',
        'd3usermanager_requirement_invfieldfilter'   =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_invfieldfilter.php',
        'd3usermanager_requirement_delgenderfilter'  =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_delgenderfilter.php',
        'd3usermanager_requirement_delcountryfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_delcountryfilter.php',
        'd3usermanager_requirement_delzipfilter'     =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_delzipfilter.php',
        'd3usermanager_requirement_delcompanyfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_delcompanyfilter.php',
        'd3usermanager_requirement_delfieldfilter'   =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_delfieldfilter.php',
        'd3usermanager_requirement_ordernocount'     =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordernocount.php',
        'd3usermanager_requirement_ordermincount'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordermincount.php',
        'd3usermanager_requirement_ordermaxcount'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordermaxcount.php',
        'd3usermanager_requirement_orderminsum'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_orderminsum.php',
        'd3usermanager_requirement_ordermaxsum'    =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordermaxsum.php',
        'd3usermanager_requirement_ordermintimespan' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordermintimespan.php',
        'd3usermanager_requirement_ordermaxtimespan' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordermaxtimespan.php',
        'd3usermanager_requirement_orderpaymentfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_orderpaymentfilter.php',
        'd3usermanager_requirement_orderdeltypefilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_orderdeltypefilter.php',
        'd3usermanager_requirement_orderlanguagefilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_orderlanguagefilter.php',
        'd3usermanager_requirement_orderfieldfilter' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_orderfieldfilter.php',
        'd3usermanager_requirement_hasuserbasket' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_hasuserbasket.php',
        'd3usermanager_requirement_userbasketfrom' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_userbasketfrom.php',
        'd3usermanager_requirement_userbasketto' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_userbasketto.php',
        'd3usermanager_requirement_userbaskettimespan' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_userbaskettimespan.php',
        'd3usermanager_requirement_ordertimespan' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_ordertimespan.php',
        'd3usermanager_requirement_hasnoticelist' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_hasnoticelist.php',
        'd3usermanager_requirement_haswishlist' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_haswishlist.php',
        'd3usermanager_requirement_noticelistcount' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_noticelistcount.php',
        'd3usermanager_requirement_wishlistcount' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_wishlistcount.php',
        'd3usermanager_requirement_hasvoucher' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_hasvoucher.php',
        'd3usermanager_requirement_vouchernumber' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_vouchernumber.php',
        'd3usermanager_requirement_voucherserie' =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_voucherserie.php',
        'd3usermanager_requirement_otherjob'                       =>
            'd3/d3usermanager/models/requirements/d3usermanager_requirement_otherjob.php',

        'd3usermanager_action_abstract'        => 'd3/d3usermanager/models/actions/d3usermanager_action_abstract.php',
        'd3usermanager_action_interface'       => 'd3/d3usermanager/models/actions/d3usermanager_action_interface.php',
        'd3usermanager_actionlist'             => 'd3/d3usermanager/models/actions/d3usermanager_actionlist.php',
        'd3usermanager_actiongrouplist'        => 'd3/d3usermanager/models/actions/d3usermanager_actiongrouplist.php',
        'd3usermanager_action_setactiveflag'   =>
            'd3/d3usermanager/models/actions/d3usermanager_action_setactiveflag.php',
        'd3usermanager_action_add2group'       => 'd3/d3usermanager/models/actions/d3usermanager_action_add2group.php',
        'd3usermanager_action_deletefromgroup' =>
            'd3/d3usermanager/models/actions/d3usermanager_action_deletefromgroup.php',
        'd3usermanager_action_deleteuser'      => 'd3/d3usermanager/models/actions/d3usermanager_action_deleteuser.php',
        'd3usermanager_action_setfieldvalue'   =>
            'd3/d3usermanager/models/actions/d3usermanager_action_setfieldvalue.php',
        'd3usermanager_action_executemethod'   =>
            'd3/d3usermanager/models/actions/d3usermanager_action_executemethod.php',
        'd3usermanager_action_sendmail'        => 'd3/d3usermanager/models/actions/d3usermanager_action_sendmail.php',
        'd3usermanager_action_exportlist'      => 'd3/d3usermanager/models/actions/d3usermanager_action_exportlist.php',

        'd3_cfg_usermanagerset'                => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerset.php',
        'd3_cfg_usermanagerset_list'           => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerset_list.php',
        'd3_cfg_usermanagerset_main'           => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerset_main.php',
        'd3_cfg_usermanagerset_licence'        =>
            'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerset_licence.php',
        'd3_cfg_usermanagerlog'                => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerlog.php',
        'd3_cfg_usermanagerlog_list'           => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanagerlog_list.php',
        'd3_cfg_usermanageritem'               => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem.php',
        'd3_cfg_usermanageritem_list'          => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_list.php',
        'd3_cfg_usermanageritem_main'          => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_main.php',
        'd3_cfg_usermanageritem_mall'          => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_mall.php',
        'd3_cfg_usermanageritem_settings'      =>
            'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_settings.php',
        'd3_cfg_usermanageritem_requ'          => 'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_requ.php',
        'd3_cfg_usermanageritem_action'        =>
            'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_action.php',
        'd3_cfg_usermanageritem_overview'      =>
            'd3/d3usermanager/controllers/admin/d3_cfg_usermanageritem_overview.php',
        'd3_usermanager_jobs'                  => 'd3/d3usermanager/controllers/admin/d3_usermanager_jobs.php',
    ),
    'templates'   => array(
        'd3_cfg_usermanagerset_main.tpl'        => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanagerset_main.tpl',
        'd3_cfg_usermanageritem_list.tpl'       => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_list.tpl',
        'd3_cfg_usermanageritem_main.tpl'       => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_main.tpl',
        'd3_cfg_usermanageritem_mall.tpl'       => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_mall.tpl',
        'd3_cfg_usermanageritem_requ.tpl'       => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_requ.tpl',
        'd3_cfg_usermanageritem_action.tpl'     => 'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_action.tpl',
        'd3_cfg_usermanageritem_overview.tpl'   =>
            'd3/d3usermanager/views/admin/tpl/d3_cfg_usermanageritem_overview.tpl',
        'd3_usermanager_jobs.tpl'               => 'd3/d3usermanager/views/admin/tpl/d3_usermanager_jobs.tpl',
        'd3usermanager_info_html.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/email/html/d3usermanager_info_html.tpl',
        'd3usermanager_info_plain.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/email/plain/d3usermanager_info_plain.tpl',

        'd3usermanager_requ_activefilter.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_activefilter.tpl',
        'd3usermanager_requ_birthdatefrom.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_birthdatefrom.tpl',
        'd3usermanager_requ_agecheck.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_agecheck.tpl',
        'd3usermanager_requ_birthdateto.tpl'            =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_birthdateto.tpl',
        'd3usermanager_requ_bonifilter.tpl'             =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_bonifilter.tpl',
        'd3usermanager_requ_custnrfrom.tpl'             =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_custnrfrom.tpl',
        'd3usermanager_requ_custnrto.tpl'               =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_custnrto.tpl',
        'd3usermanager_requ_deladdrfilter.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_deladdrfilter.tpl',
        'd3usermanager_requ_hasbirthday.tpl'            =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_hasbirthday.tpl',
        'd3usermanager_requ_ingroupfilter.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ingroupfilter.tpl',
        'd3usermanager_requ_newsletterfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_newsletterfilter.tpl',
        'd3usermanager_requ_notingroupfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_notingroupfilter.tpl',
        'd3usermanager_requ_passwordfilter.tpl'         =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_passwordfilter.tpl',
        'd3usermanager_requ_registerfrom.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_registerfrom.tpl',
        'd3usermanager_requ_registertimespan.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_registertimespan.tpl',
        'd3usermanager_requ_registerto.tpl'             =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_registerto.tpl',
        'd3usermanager_requ_validnewslettermail.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_validnewslettermail.tpl',
        'd3usermanager_requ_executemethodfilter.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_executemethodfilter.tpl',
        'd3usermanager_requ_invcompanyfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invcompanyfilter.tpl',
        'd3usermanager_requ_invcountryfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invcountryfilter.tpl',
        'd3usermanager_requ_invfieldfilter.tpl'         =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invfieldfilter.tpl',
        'd3usermanager_requ_invgenderfilter.tpl'        =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invgenderfilter.tpl',
        'd3usermanager_requ_invustidfilter.tpl'         =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invustidfilter.tpl',
        'd3usermanager_requ_invzipfilter.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_invzipfilter.tpl',
        'd3usermanager_requ_delcompanyfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_delcompanyfilter.tpl',
        'd3usermanager_requ_delcountryfilter.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_delcountryfilter.tpl',
        'd3usermanager_requ_delfieldfilter.tpl'         =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_delfieldfilter.tpl',
        'd3usermanager_requ_delgenderfilter.tpl'        =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_delgenderfilter.tpl',
        'd3usermanager_requ_delzipfilter.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_delzipfilter.tpl',
        'd3usermanager_requ_orderdeltypefilter.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_orderdeltypefilter.tpl',
        'd3usermanager_requ_orderlanguagefilter.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_orderlanguagefilter.tpl',
        'd3usermanager_requ_ordermaxcount.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordermaxcount.tpl',
        'd3usermanager_requ_ordermaxsum.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordermaxsum.tpl',
        'd3usermanager_requ_ordermaxtimespan.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordermaxtimespan.tpl',
        'd3usermanager_requ_ordermincount.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordermincount.tpl',
        'd3usermanager_requ_orderminsum.tpl'          =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_orderminsum.tpl',
        'd3usermanager_requ_ordermintimespan.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordermintimespan.tpl',
        'd3usermanager_requ_ordernocount.tpl'           =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordernocount.tpl',
        'd3usermanager_requ_orderpaymentfilter.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_orderpaymentfilter.tpl',
        'd3usermanager_requ_orderfieldfilter.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_orderfieldfilter.tpl',
        'd3usermanager_requ_hasuserbasket.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_hasuserbasket.tpl',
        'd3usermanager_requ_userbasketfrom.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_userbasketfrom.tpl',
        'd3usermanager_requ_userbasketto.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_userbasketto.tpl',
        'd3usermanager_requ_userbaskettimespan.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_userbaskettimespan.tpl',
        'd3usermanager_requ_ordertimespan.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_ordertimespan.tpl',
        'd3usermanager_requ_hasnoticelist.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_hasnoticelist.tpl',
        'd3usermanager_requ_haswishlist.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_haswishlist.tpl',
        'd3usermanager_requ_noticelistcount.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_noticelistcount.tpl',
        'd3usermanager_requ_wishlistcount.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_wishlistcount.tpl',
        'd3usermanager_requ_hasvoucher.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_hasvoucher.tpl',
        'd3usermanager_requ_vouchernumber.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_vouchernumber.tpl',
        'd3usermanager_requ_voucherserie.tpl'     =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_voucherserie.tpl',
        'd3usermanager_requ_otherjob.tpl'            =>
            'd3/d3usermanager/views/admin/tpl/requirements/d3usermanager_requ_otherjob.tpl',

        'd3_cfg_usermanageritem_restrictions.tpl'   =>
            'd3/d3usermanager/views/admin/tpl/inc/d3_cfg_usermanageritem_restrictions.tpl',
        'd3usermanager_action_addtogroup.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_addtogroup.tpl',
        'd3usermanager_action_deletefromgroup.tpl'  =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_deletefromgroup.tpl',
        'd3usermanager_action_setactiveflag.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_setactiveflag.tpl',
        'd3usermanager_action_deleteuser.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_deleteuser.tpl',
        'd3usermanager_action_setfieldvalue.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_setfieldvalue.tpl',
        'd3usermanager_action_executemethod.tpl'    =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_executemethod.tpl',
        'd3usermanager_action_sendmail.tpl'         =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_sendmail.tpl',
        'd3usermanager_action_exportlist.tpl'       =>
            'd3/d3usermanager/views/admin/tpl/actions/d3usermanager_action_exportlist.tpl',
    ),
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'blocks'      => array(
        array(
            'template'  => 'user_remark.tpl',
            'block'     => 'd3usermanager_user_remark_type',
            'file'      => 'views/admin/blocks/d3usermanager_user_remark_type.tpl',
        )
    ),
    'd3FileRegister'    => array(
        'd3/d3usermanager/IntelliSenseHelper.php',
        'd3/d3usermanager/metadata.php',
        'd3/d3usermanager/views/admin/blocks/d3usermanager_user_remark_type.tpl',
        'd3/d3usermanager/views/admin/de/d3_usermanager_lang.php',
        'd3/d3usermanager/views/admin/tpl/d3_usermanager_bottomnaviitem.tpl',
        'd3/d3usermanager/views/admin/tpl/email/html/d3orderbreak.tpl',
        'd3/d3usermanager/views/admin/tpl/email/plain/d3orderbreak.tpl',
    ),
);
